/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.softline.client.AbstractEditor;
import ru.bitel.bgbilling.modules.softline.client.SoftLineConfigureProductPanel;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionPeriodType;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineTypeProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SotfLineProductCategory;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ProductPanel
extends BGUPanel
implements ActionListener {
    private BGUTable productTable = null;
    private BGControlPanelPages page = new BGControlPanelPages();
    private SoftLineProductTableModel tableModel;
    private SoftLineConfigureProductPanel parent;
    private ProductEditor editor;

    ProductPanel(SoftLineConfigureProductPanel parent) {
        this.parent = parent;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new SoftLineProductTableModel(SoftLineProductTableModel.class.getName());
        this.editor = new ProductEditor();
        BGDialogToolBar toolBar = this.parent.buildToolBar(this);
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.add(this.getFilterPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)this.getProductTable()), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)((Object)this.editor), new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 3, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (BGDialogToolBar.ButtonData.of((String)e.getActionCommand())) {
            case NEW_ITEM: {
                this.editor.newItem();
                break;
            }
            case EDIT_ITEM: {
                this.editor.editItem();
                break;
            }
            case DELETE_ITEM: {
                this.editor.deleteItem();
                break;
            }
        }
    }

    private JPanel getFilterPanel() {
        this.page.setKey(this.getClass().getName());
        this.page.init();
        this.page.addPropertyChangeListener(evt -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.page, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        return filterPanel;
    }

    private BGUTable getProductTable() {
        if (this.productTable == null) {
            this.productTable = new BGUTable((TableModel)((Object)this.tableModel));
            this.productTable.setSelectionMode(0);
            this.productTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1 && ProductPanel.this.tableModel.getSelectedRow() != null) {
                        ProductPanel.this.editor.editItem();
                    }
                }
            });
        }
        return this.productTable;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult result = this.parent.getService().getProducts(this.page.getPage());
            this.tableModel.setData(result.getList());
            this.page.setPage(result.getPage());
        });
    }

    private class SoftLineProductTableModel
    extends BGTableModel<SoftLineProduct> {
        SoftLineProductTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 400, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, 500, -1, "description", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0426\u0435\u043d\u0430", -1, 100, -1, "price", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0432 SoftLine", -1, 100, -1, "softLineCode", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", -1, 200, -1, "periodType", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", -1, 100, -1, "productCategoryId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", -1, 200, -1, "categoryTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(SoftLineProduct product, int column) throws BGException {
            switch (column) {
                case 5: {
                    return product.getPeriodType() != null ? product.getPeriodType().getDescription() : "";
                }
                case 7: {
                    SotfLineProductCategory category = ProductPanel.this.parent.getService().getCategoryOfProduct(product.getProductCategoryId());
                    if (category == null) break;
                    return category.getTitle();
                }
            }
            return super.getValue((Object)product, column);
        }
    }

    class ProductEditor
    extends AbstractEditor {
        private JTextField productCategoryId = new JTextField();
        private JTextField price = new JTextField();
        private JTextField softLineCode = new JTextField();
        private BGUComboBox<SoftLineSubscriptionPeriodType> periodType = new BGUComboBox();
        private JLabel daysCountLabel = new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439");
        private JTextField daysCount = new JTextField();
        private BGUComboBox<Service> services = new BGUComboBox();
        private SoftLineProduct current;
        private List<Service> moduleServices = new ArrayList<Service>();

        ProductEditor() {
        }

        @Override
        protected void jbInit() throws Exception {
            super.jbInit();
            this.periodType.setData(Arrays.asList(SoftLineSubscriptionPeriodType.values()));
            this.periodType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (ProductEditor.this.periodType.getSelectedItem() == SoftLineSubscriptionPeriodType.DAY) {
                            ProductEditor.this.daysCountLabel.setVisible(true);
                            ProductEditor.this.daysCount.setVisible(true);
                        } else {
                            ProductEditor.this.daysCountLabel.setVisible(false);
                            ProductEditor.this.daysCount.setVisible(false);
                        }
                    }
                }
            });
            this.moduleServices.addAll(((ModuleService)((ClientContext)this.getContext()).getWebService(ModuleService.class, 0)).serviceList(((ClientContext)this.getContext()).getModuleId()));
            this.services.setData(this.moduleServices);
            this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.getDescriptionPanel(), new GridBagConstraints(1, 1, 1, 14, 1.0, 1.0, 18, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("ID \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.productCategoryId, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u0426\u0435\u043d\u0430"), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.price, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add((Component)this.services, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u041a\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0432 SoftLine"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.softLineCode, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u0422\u0438\u043f \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add((Component)this.periodType, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.daysCountLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.daysCount, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.productPicture, new GridBagConstraints(1, 11, 1, 4, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.selectPicture, new GridBagConstraints(1, 15, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 5, 0), 0, 0));
            this.add((Component)this.buttonPanel, new GridBagConstraints(1, 16, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 3, 0), 0, 0));
        }

        @Override
        protected void newItem() {
            this.current = new SoftLineProduct();
            this.performActionOpen();
        }

        @Override
        protected void editItem() {
            this.current = (SoftLineProduct)ProductPanel.this.tableModel.getSelectedRow();
            if (this.current != null) {
                this.performActionOpen();
            }
            ProductPanel.this.parent.performAction("refresh");
        }

        @Override
        protected void deleteItem() {
            this.current = (SoftLineProduct)ProductPanel.this.tableModel.getSelectedRow();
            if (this.current == null) {
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u0432\u0441\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0441 \u0443\u0447\u0430\u0441\u0442\u0438\u0435\u043c \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430. \u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0431\u0443\u0434\u0443\u0442 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b.\u0414\u043b\u044f \u0432\u0441\u0435\u0445 \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a \u0431\u0443\u0434\u0435\u0442 \u043e\u0447\u0438\u0449\u0435\u043d\u0430 \u0438\u0441\u0442\u043e\u0440\u0438\u044f. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 " + this.current.getTitle() + " ?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    ProductPanel.this.parent.getService().deleteProduct(this.current);
                    ProductPanel.this.parent.performAction("refresh");
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }

        @Override
        protected void actionOpen() {
            if (this.current != null) {
                this.title.setText(this.current.getTitle());
                this.productCategoryId.setText(String.valueOf(this.current.getProductCategoryId()));
                this.description.setText(this.current.getDescription());
                this.softLineCode.setText(this.current.getSoftLineCode());
                this.price.setText(this.current.getPrice() == null ? "" : this.current.getPrice().toString());
                this.services.setSelectedItem((Object)this.moduleServices.stream().anyMatch(service -> service.getId() == this.current.getServiceId()));
                this.periodType.setSelectedItem((Object)this.current.getPeriodType());
                try {
                    this.setPicture(ProductPanel.this.parent.getService().getProductPicture(this.current.getId(), SoftLineTypeProduct.PRODUCT));
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((String)e.getMessage());
                }
            }
        }

        @Override
        protected void actionSave() throws BGException {
            String productTitle;
            if (this.current == null) {
                this.current = new SoftLineProduct();
            }
            if (Utils.isBlankString((String)(productTitle = this.title.getText()))) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                return;
            }
            int categoryId = Utils.parseInt((String)this.productCategoryId.getText(), (int)-1);
            if (categoryId < 0) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 0");
                return;
            }
            String code = this.softLineCode.getText();
            if (Utils.isBlankString((String)code)) {
                BGToolTip.showErrorMessage((JComponent)this.softLineCode, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 SoftLine");
                return;
            }
            SoftLineSubscriptionPeriodType selectedPeriodType = (SoftLineSubscriptionPeriodType)this.periodType.getSelectedItem();
            if (selectedPeriodType == null) {
                BGToolTip.showErrorMessage(this.periodType, (String)"\u0412\u044b\u0431\u0438\u0440\u0435\u0442\u0438 \u0442\u0438\u043f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                return;
            }
            this.current.setPeriodType(selectedPeriodType);
            Service selectedService = (Service)this.services.getSelectedItem();
            if (selectedService == null) {
                BGToolTip.showErrorMessage(this.services, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u043c\u043e\u0434\u0443\u043b\u044f \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                return;
            }
            BigDecimal productPrice = this.getValidPrice();
            if (productPrice == null) {
                return;
            }
            this.current.setTitle(productTitle);
            this.current.setProductCategoryId(categoryId);
            this.current.setDescription(this.description.getText());
            this.current.setSoftLineCode(code);
            this.current.setPrice(productPrice);
            this.current.setServiceId(selectedService.getId());
            if (selectedPeriodType == SoftLineSubscriptionPeriodType.DAY) {
                int days = Utils.parseInt((String)this.daysCount.getText(), (int)-1);
                this.current.setAmountOfDays(days <= 0 ? 1 : days);
            }
            ProductPanel.this.parent.getService().updateProduct(this.current);
            byte[] bytesPicture = this.getSelectedPicture();
            if (bytesPicture != null) {
                ProductPanel.this.parent.getService().setProductPicture(this.current.getId(), bytesPicture, SoftLineTypeProduct.PRODUCT);
            }
            ProductPanel.this.performAction("refresh");
            this.setVisible(false);
        }

        private BigDecimal getValidPrice() {
            try {
                return new BigDecimal(this.price.getText());
            }
            catch (NumberFormatException ex) {
                BGToolTip.showErrorMessage((JComponent)this.price, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0446\u0435\u043d\u0435");
                return null;
            }
        }
    }
}

