/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class SbPilotBinWrapper {
    private File pathBin;
    private File workdir;
    private String pathE;
    private String pathP;
    private String pathE2;
    private WrapperAction wrapperAction;
    private String encodingFileE = null;
    private int storedLineCountFileE2;
    private Process proc = null;
    int t = 3;
    private static final Pattern linePattern = Pattern.compile("^\\d\\d.\\d\\d\\s+\\d\\d:\\d\\d:\\d\\d\\s+(\\w+)\\s+=\\s+(.+)$");
    private static final Pattern linePatternE3 = Pattern.compile("^[\\.\\:\\d ]+\\s+\\w+:\\s+(\\w+)\\s+=\\s+(.+)$");

    public SbPilotBinWrapper(File pathBin, File workdir, String pathE, String pathP, String pathE2, WrapperAction wrapperAction) {
        this.pathBin = pathBin;
        this.workdir = workdir;
        this.pathE = pathE;
        this.pathP = pathP;
        this.pathE2 = pathE2;
        this.wrapperAction = wrapperAction;
        String osname = System.getProperty("os.name").toLowerCase();
        this.encodingFileE = osname.indexOf("win") >= 0 ? "cp866" : "koi8-r";
        if (this.pathE2 != null) {
            Calendar now = Calendar.getInstance();
            this.pathE2 = this.pathE2.replace("%YY", String.valueOf(now.get(1) - 2000));
            this.pathE2 = this.pathE2.replace("%MM", String.format("%02d", now.get(2) + 1));
        }
    }

    public synchronized void doPayment(int summa) throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "1", String.valueOf(summa), "0");
    }

    public synchronized void doZ() throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "7");
    }

    public synchronized void doX(boolean full) throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "9", full ? "1" : "0");
    }

    public synchronized void doCancel13(int summa, String authcode) throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "13", String.valueOf(summa), authcode);
    }

    public synchronized void doRepeat() throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "12");
    }

    public synchronized void doCancel8(int summa) throws BGException {
        if (summa > 0) {
            this.doSomething(this.pathBin.getAbsolutePath(), "8", String.valueOf(summa));
        } else {
            this.doSomething(this.pathBin.getAbsolutePath(), "8");
        }
    }

    public synchronized void doCancel3(int summa) throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "3", String.valueOf(summa));
    }

    public synchronized void doInfo() throws BGException {
        this.doSomething(this.pathBin.getAbsolutePath(), "36");
    }

    private synchronized void doSomething(String ... command) throws BGException {
        InputStreamReader is = null;
        try {
            this.storedLineCountFileE2 = this.calcLineCountFileE2();
            this.wrapperAction.line("cmd: \"" + Utils.toString((Object[])command, (String)" ") + "\" (workdir: \"" + this.workdir.getAbsolutePath() + "\")");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(this.workdir);
            builder.redirectErrorStream(true);
            this.proc = builder.start();
            is = new InputStreamReader(this.proc.getInputStream());
            StringBuilder sb = new StringBuilder();
            do {
                Thread.sleep(1000L);
                while (is.ready()) {
                    sb.append((char)is.read());
                }
                if (sb.length() <= 0) continue;
                this.wrapperAction.line("out: " + sb.toString());
                sb.setLength(0);
            } while (this.proc.isAlive());
            this.wrapperAction.line("return value: " + this.proc.exitValue());
        }
        catch (Exception e) {
            throw new BGException("error run process", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.wrapperAction.line("error close inputstream: " + e.toString());
            }
        }
    }

    public E parseE1() throws BGException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.pathE)), this.encodingFileE));
            E e = new E();
            String line1 = reader.readLine();
            String[] pair = line1.trim().split(",", 58);
            e.errcode = Integer.parseInt(pair[0]);
            e.errmsg = pair[1];
            e.cardnum = reader.readLine();
            e.carddate = reader.readLine();
            e.authcode = reader.readLine();
            e.internalnum = reader.readLine();
            e.cardtype = reader.readLine();
            e.unc1 = reader.readLine();
            e.unc2 = reader.readLine();
            e.unc3 = reader.readLine();
            reader.close();
            return e;
        }
        catch (Throwable e) {
            throw new BGException(e);
        }
    }

    private int calcLineCountFileE2() {
        if (this.pathE2 == null) {
            return -1;
        }
        int lines = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.pathE2));){
            while (reader.readLine() != null) {
                ++lines;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return lines;
    }

    public E parseE2() throws BGException {
        E e;
        int lineCountFileE2;
        if (this.storedLineCountFileE2 == -1) {
            this.storedLineCountFileE2 = 0;
        }
        if ((lineCountFileE2 = this.calcLineCountFileE2()) == -1) {
            throw new BGException("\u041b\u043e\u0433-\u0444\u0430\u0439\u043b (" + this.pathE2 + ") \u043f\u043e\u0441\u043b\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0443\u0442\u0438\u043b\u0438\u0442\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        if (lineCountFileE2 - this.storedLineCountFileE2 < 2) {
            throw new BGException("\u041b\u043e\u0433-\u0444\u0430\u0439\u043b (" + this.pathE2 + ") \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c 2 \u043d\u043e\u0432\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 (\u0434\u043e: " + this.storedLineCountFileE2 + ", \u043f\u043e\u0441\u043b\u0435: " + lineCountFileE2 + ")");
        }
        if (lineCountFileE2 - this.storedLineCountFileE2 > 2) {
            return this.parseE3();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.pathE2)), this.encodingFileE));
        try {
            E e2 = new E();
            for (int i = 0; i < this.storedLineCountFileE2; ++i) {
                reader.readLine();
            }
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            this.wrapperAction.line("logfile: " + line1);
            this.wrapperAction.line("logfile: " + line2);
            Matcher m1 = linePattern.matcher(line1);
            Matcher m2 = linePattern.matcher(line2);
            if (m1.find() && m2.find()) {
                String w1 = m1.group(1);
                String w2 = m2.group(1);
                if (!"Command".equals(w1) || !"Result".equals(w2)) {
                    throw new BGException("\u0421\u0442\u0440\u043e\u043a\u0438 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 Command/Result \u0432 \u043d\u0443\u0436\u043d\u043e\u043c \u043c\u0435\u0441\u0442\u0435");
                }
            } else {
                throw new BGException("\u0421\u0442\u0440\u043e\u043a\u0438 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430");
            }
            String ercod = m2.group(2);
            e2.errcode = Integer.parseInt(ercod);
            e2.errmsg = e2.errcode == 0 ? "\u0423\u0421\u041f\u0415\u0428\u041d\u041e" : "\u041e\u0428\u0418\u0411\u041a\u0410";
            reader.close();
            e = e2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e3) {
                throw e3;
            }
            catch (Throwable e4) {
                throw new BGException(e4);
            }
        }
        reader.close();
        return e;
    }

    public E parseE3() throws BGException {
        E e;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.pathE2)), this.encodingFileE));
        try {
            E e2 = new E();
            for (int i = 0; i < this.storedLineCountFileE2; ++i) {
                reader.readLine();
            }
            String line = null;
            String comndline = null;
            String ercod = null;
            while ((line = reader.readLine()) != null) {
                this.wrapperAction.line("logfile: " + line);
                Matcher m1 = linePatternE3.matcher(line);
                if (!m1.find()) continue;
                String w1 = m1.group(1);
                if ("Command".equals(w1)) {
                    comndline = m1.group(2);
                }
                if (!"Result".equals(w1) || !(ercod = m1.group(2)).contains(",")) continue;
                ercod = ercod.split(",")[0];
            }
            if (comndline == null) {
                throw new BGException("\u0421\u0442\u0440\u043e\u043a\u0438 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 Command");
            }
            if (ercod == null) {
                throw new BGException("\u0421\u0442\u0440\u043e\u043a\u0438 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 Result");
            }
            e2.errcode = Integer.parseInt(ercod);
            e2.errmsg = e2.errcode == 0 ? "\u0423\u0421\u041f\u0415\u0428\u041d\u041e" : "\u041e\u0428\u0418\u0411\u041a\u0410";
            reader.close();
            e = e2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e3) {
                throw e3;
            }
            catch (Throwable e4) {
                throw new BGException(e4);
            }
        }
        reader.close();
        return e;
    }

    public E parseE() throws BGException {
        return this.pathE != null ? this.parseE1() : this.parseE2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNeedPrintCheck() {
        File checkfile = new File(this.pathP);
        if (!checkfile.exists()) return null;
        if (!checkfile.canRead()) return null;
        try (FileInputStream fis = new FileInputStream(checkfile);){
            byte[] bytes = Utils.readByBlock((InputStream)fis);
            if (bytes.length <= 0) return null;
            String string = new String(bytes, this.encodingFileE);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void abort() {
        if (this.proc != null && this.proc.isAlive()) {
            this.proc.destroy();
        }
    }

    public static interface WrapperAction {
        public void line(String var1);
    }

    public static class E {
        public int errcode;
        public String errmsg;
        public String cardnum;
        public String carddate;
        public String authcode;
        public String internalnum;
        public String cardtype;
        public String unc1;
        public String unc2;
        public String unc3;
    }
}

