/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.runtel.client.ServicePropertiesPanel;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.common.service.RunTelService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ServicePropertiesLogTabPanel
extends BGUPanel {
    private TariffTableModel tableModel = null;
    private ServicePropertiesPanel parentPanel = null;

    public ServicePropertiesLogTabPanel(ServicePropertiesPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTariffLogPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ServicePropertiesLogTabPanel.this.performAction("refresh");
            }
        });
    }

    private JPanel getTariffLogPanel() {
        this.tableModel = new TariffTableModel(TariffTableModel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                RunTelContractTariff runTelContractTariff = (RunTelContractTariff)ServicePropertiesLogTabPanel.this.tableModel.getSelectedRow();
                if (runTelContractTariff != null && mouseEvent.getClickCount() == 2) {
                    ServicePropertiesLogTabPanel.this.parentPanel.showRunTelContractTariff(runTelContractTariff);
                }
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private RunTelService getRunTelService() {
        return (RunTelService)((ClientContext)this.getContext()).getWebService(RunTelService.class, ((ClientContext)this.getContext()).getModuleId());
    }

    protected void initAction(AbstractBGUPanel.DefaultAction result, String command, KeyStroke stroke) {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.tableModel.tariffs.clear();
            this.getRunTelService().searchRunTelTariff().getList().forEach(t -> this.tableModel.tariffs.put(t.getId(), (RunTelTariff)t));
            SearchResult searchResult = this.getRunTelService().searchContractRunTelTariff(((ClientContext)this.getContext()).getContractId(), new PeriodWithTime());
            this.tableModel.setData(searchResult.getList());
        });
    }

    class TariffTableModel
    extends BGTableModel<RunTelContractTariff> {
        Map<Integer, RunTelTariff> tariffs;

        public TariffTableModel(String name) {
            super(name);
            this.tariffs = new HashMap<Integer, RunTelTariff>();
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true);
            this.addColumn("\u0422\u0430\u0440\u0438\u0444", 100, 100, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RunTelContractTariff val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                RunTelTariff runTelTariff = this.tariffs.get(val.getTariffId());
                return runTelTariff != null ? runTelTariff.getTitle() : "[" + val.getTariffId() + "] ???";
            }
            return super.getValue((Object)val, column);
        }
    }
}

