/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.dialup;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Session
extends BGJasperReport {
    public Report_Session() {
        this.id = "dialup_session";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        BGReportFilter filter = this.createBGReportFilter();
        try {
            Calendar date1 = TimeUtils.parseCalendar((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy");
            Calendar date2 = TimeUtils.parseCalendar((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy");
            int hour1 = Utils.parseInt((String)filter.getStringParam("hour1"), (int)0);
            int hour2 = Utils.parseInt((String)filter.getStringParam("hour2"), (int)23);
            date1.set(11, hour1);
            date2.set(11, hour2);
            date2.set(12, 59);
            date2.set(13, 59);
            date2.set(14, 999);
            String ip = filter.getStringParam("ip");
            String phone = filter.getStringParam("phone");
            boolean activeSession = Boolean.valueOf(filter.getStringParam("activeSession"));
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            if (date1 != null && mid > 0) {
                String tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)mid);
                BGDataSource data = new BGDataSource();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("addInfo", " \u0433\u043e\u0434: " + date1.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date1.get(2)]);
                if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT contract.title, session.login_name, session.session_start, session.session_stop, session.session_time, session.session_cost, session.from_number, session.to_number, session.input_octets, session.output_octets FROM ");
                    query.append(tableName);
                    query.append(" AS session ");
                    query.append(" LEFT JOIN user_login_");
                    query.append(mid);
                    query.append(" AS login ON session.lid=login.id ");
                    query.append(" LEFT JOIN contract ON login.cid=contract.id ");
                    query.append(" WHERE session.session_start>=? AND session.session_start<=? ");
                    if (!Utils.isEmptyString((String)ip)) {
                        query.append(" AND session.ipaddr=");
                        query.append(String.valueOf(IPUtils.convertStringIPtoLong((String)ip)));
                        query.append("");
                    }
                    if (!Utils.isEmptyString((String)phone)) {
                        query.append(" AND session.from_number='");
                        query.append(phone);
                        query.append("'");
                    }
                    if (activeSession) {
                        query.append(" AND session.status=0");
                    }
                    query.append("  ORDER BY contract.title ASC, session.login_name ASC, session.session_start ASC");
                    PreparedStatement ps = this.con.prepareStatement(query.toString());
                    ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)date1));
                    ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)date2));
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("contract", rs.getString(1));
                        row.put("login", rs.getString("login_name"));
                        row.put("start", TimeUtils.formatTimestamp((Timestamp)rs.getTimestamp("session_start"), (String)"dd.MM.yyyy HH:mm:ss"));
                        row.put("end", TimeUtils.formatTimestamp((Timestamp)rs.getTimestamp("session_stop"), (String)"dd.MM.yyyy HH:mm:ss"));
                        row.put("time", Utils.formatSessionTime((int)rs.getInt("session_time")));
                        row.put("cost", Utils.formatSessionCost((float)rs.getFloat("session_cost")));
                        row.put("from_number", rs.getString("from_number"));
                        row.put("to_number", rs.getString("to_number"));
                        row.put("input", rs.getString("input_octets"));
                        row.put("output", rs.getString("output_octets"));
                        data.addRow(row);
                    }
                    rs.close();
                    ps.close();
                }
                this.fillReportToStream("dialup_session", out, params, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

