/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.modules.kernel;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.bgbilling.modules.reports.client.include.BGHidingPanel;
import ru.bitel.bgbilling.modules.reports.client.include.RFAddress;
import ru.bitel.bgbilling.modules.reports.client.include.RFCashcheckKkmList;
import ru.bitel.bgbilling.modules.reports.client.include.RFChargeTypes;
import ru.bitel.bgbilling.modules.reports.client.include.RFCheckbox;
import ru.bitel.bgbilling.modules.reports.client.include.RFCheckedList;
import ru.bitel.bgbilling.modules.reports.client.include.RFCombo;
import ru.bitel.bgbilling.modules.reports.client.include.RFContract;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractLabels;
import ru.bitel.bgbilling.modules.reports.client.include.RFContractStatuses;
import ru.bitel.bgbilling.modules.reports.client.include.RFDate;
import ru.bitel.bgbilling.modules.reports.client.include.RFDealers;
import ru.bitel.bgbilling.modules.reports.client.include.RFHours;
import ru.bitel.bgbilling.modules.reports.client.include.RFInetDevices;
import ru.bitel.bgbilling.modules.reports.client.include.RFList;
import ru.bitel.bgbilling.modules.reports.client.include.RFListParams;
import ru.bitel.bgbilling.modules.reports.client.include.RFModule;
import ru.bitel.bgbilling.modules.reports.client.include.RFMonth;
import ru.bitel.bgbilling.modules.reports.client.include.RFMonthAndDays;
import ru.bitel.bgbilling.modules.reports.client.include.RFNases;
import ru.bitel.bgbilling.modules.reports.client.include.RFPaymentTypes;
import ru.bitel.bgbilling.modules.reports.client.include.RFPeriod;
import ru.bitel.bgbilling.modules.reports.client.include.RFPeriodWithTime;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterCategoryList;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterExecutors;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFRegisterTaskType;
import ru.bitel.bgbilling.modules.reports.client.include.RFServices;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffGroups;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffOptions;
import ru.bitel.bgbilling.modules.reports.client.include.RFTariffPlan;
import ru.bitel.bgbilling.modules.reports.client.include.RFTextField;
import ru.bitel.bgbilling.modules.reports.client.include.RFUsers;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.SetData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ReportParams_Default
extends ReportParams {
    private List<ReportFilter> params = new ArrayList<ReportFilter>();

    @Override
    protected void putReportParams() {
        for (ReportFilter p : this.params) {
            p.putParams(this._reportParams);
        }
    }

    public void setData() {
        for (ReportFilter p : this.params) {
            if (!(p instanceof SetData)) continue;
            SetData s = (SetData)((Object)p);
            s.setData(this);
        }
    }

    public Document getDocument(Request req) {
        return super.getDocument(req);
    }

    public ReportParams_Default() {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void setReportInfo(Element e) throws BGException {
        FilterParserDoc p = new FilterParserDoc();
        p.process(e);
        p.end();
        for (ReportFilter param : this.params) {
            if (!(param instanceof BGPanel)) continue;
            BGPanel panel = (BGPanel)param;
            panel.init(this.module, this.getModuleId());
        }
    }

    public void init(String module, int mid) {
        super.init(module, mid);
    }

    public Iterable<Element> getItemElementsFromSql(String sql) {
        Request request = new Request();
        request.setModule("reports");
        request.setModuleId(this.getModuleId());
        request.setAction("GetListFromSql");
        request.setAttribute("sql", sql);
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            return XMLUtils.selectElements((Node)doc, (String)"/data/items/item");
        }
        return null;
    }

    private int getAnchor(Element a) {
        String anchorString = a.getAttribute("anchor");
        int anchor = 18;
        switch (anchorString.toUpperCase()) {
            case "CENTER": {
                anchor = 10;
                break;
            }
            case "NORTH": {
                anchor = 11;
                break;
            }
            case "NORTHEAST": {
                anchor = 12;
                break;
            }
            case "EAST": {
                anchor = 13;
                break;
            }
            case "SOUTHEAST": {
                anchor = 14;
                break;
            }
            case "SOUTH": {
                anchor = 15;
                break;
            }
            case "SOUTHWEST": {
                anchor = 16;
                break;
            }
            case "WEST": {
                anchor = 17;
                break;
            }
            case "NORTHWEST": {
                anchor = 18;
            }
        }
        return anchor;
    }

    private int getFill(Element a) {
        String resizeString = a.getAttribute("fill");
        int fill = 2;
        switch (resizeString.toUpperCase()) {
            case "BOTH": {
                fill = 1;
                break;
            }
            case "HORIZONTAL": {
                fill = 2;
                break;
            }
            case "VERTICAL": {
                fill = 3;
                break;
            }
            case "NONE": {
                fill = 0;
            }
        }
        return fill;
    }

    private class FilterParserDoc {
        private int lastY = 0;
        private int maxY = 0;
        private int maxWidth = 1;
        private JTabbedPane tabbed = null;
        private Component firstTabPane = null;
        private String firstTabPaneTitle = null;
        private JComponent panel;

        public FilterParserDoc() {
            this.panel = ReportParams_Default.this;
        }

        public void process(Element e) throws BGException {
            NodeList childs = e.getChildNodes();
            if (e.getNodeType() == 1 && "report".equals(e.getNodeName())) {
                this.processReport(e, childs);
            } else {
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (node.getNodeType() != 1 || !"report".equals(node.getNodeName())) continue;
                    Element elem = (Element)node;
                    this.processReport(elem, childs);
                }
            }
        }

        private void processReport(Element elem, NodeList childs) throws BGException {
            boolean scroll = Utils.parseBoolean((String)XMLUtils.getAttribute((Element)elem, (String)"scroll", (String)""), (boolean)false);
            int height = Utils.parseInt((String)XMLUtils.getAttribute((Element)elem, (String)"height", (String)""), (int)400);
            if (scroll) {
                this.panel = new JPanel(new GridBagLayout());
                this.panel.setMaximumSize(new Dimension(ReportParams_Default.this.getWidth(), height));
                this.panel.setPreferredSize(new Dimension(ReportParams_Default.this.getWidth(), height));
                ReportParams_Default.this.add(new JScrollPane(this.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            childs = elem.getChildNodes();
            this.execFilters(childs, this.panel);
        }

        private void execFilters(NodeList childs, JComponent panel) throws BGException {
            for (int j = 0; j < childs.getLength(); ++j) {
                String title;
                ReportFilter text;
                Element it;
                Node n;
                int k;
                DefaultListModel model;
                SetData list;
                Node node = childs.item(j);
                if (node.getNodeType() != 1) continue;
                Element attributes = (Element)node;
                String qName = attributes.getNodeName();
                if ("hide".equals(qName)) {
                    BGHidingPanel hidePanel = new BGHidingPanel(attributes.getAttribute("title"));
                    this.execFilters(attributes.getChildNodes(), hidePanel);
                    panel.add((Component)hidePanel, this.getConstraints(attributes));
                    continue;
                }
                if ("combo".equals(qName)) {
                    RFCombo combo = new RFCombo(attributes.getAttribute("name"), attributes.getAttribute("title"), attributes.getAttribute("textBefore"), attributes.getAttribute("textAfter"), attributes.getAttribute("sql"));
                    ReportParams_Default.this.params.add(combo);
                    panel.add((Component)combo, this.getConstraints(attributes));
                    NodeList items = attributes.getChildNodes();
                    for (int k2 = 0; k2 < items.getLength(); ++k2) {
                        Node n2 = items.item(k2);
                        if (n2.getNodeType() != 1 || !"item".equals(n2.getNodeName())) continue;
                        Element it2 = (Element)n2;
                        ComboBoxItem item = new ComboBoxItem((Object)it2.getAttribute("id"), it2.getAttribute("title"));
                        DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getCombo().getModel();
                        model2.addElement(item);
                    }
                    continue;
                }
                if ("list".equals(qName)) {
                    list = new RFList(attributes.getAttribute("name"), attributes.getAttribute("title"), attributes.getAttribute("sql"));
                    boolean isTabbed = Utils.parseBoolean((String)attributes.getAttribute("tabbed"), (boolean)false);
                    ReportParams_Default.this.params.add((ReportFilter)((Object)list));
                    if (!isTabbed) {
                        panel.add((Component)((Object)list), this.getConstraints(attributes));
                    } else {
                        this.addToTabbed((Component)((Object)list), attributes.getAttribute("title"));
                    }
                    NodeList items = attributes.getChildNodes();
                    model = (DefaultListModel)((RFList)list).getList().getList().getModel();
                    for (k = 0; k < items.getLength(); ++k) {
                        n = items.item(k);
                        if (n.getNodeType() != 1 || !"item".equals(n.getNodeName())) continue;
                        it = (Element)n;
                        model.addElement(new BGUListItem(it.getAttribute("id"), it.getAttribute("title")));
                    }
                    continue;
                }
                if ("checkedList".equals(qName)) {
                    list = new RFCheckedList(attributes.getAttribute("name"), attributes.getAttribute("title"), attributes.getAttribute("sql"));
                    boolean isTabbed = Utils.parseBoolean((String)attributes.getAttribute("tabbed"), (boolean)false);
                    ReportParams_Default.this.params.add((ReportFilter)((Object)list));
                    if (!isTabbed) {
                        panel.add((Component)((Object)list), this.getConstraints(attributes));
                    } else {
                        this.addToTabbed((Component)((Object)list), attributes.getAttribute("title"));
                    }
                    NodeList items = attributes.getChildNodes();
                    model = (DefaultListModel)list.getList().getModel();
                    for (k = 0; k < items.getLength(); ++k) {
                        n = items.item(k);
                        if (n.getNodeType() != 1 || !"item".equals(n.getNodeName())) continue;
                        it = (Element)n;
                        model.addElement(new BGUListItem(it.getAttribute("id"), it.getAttribute("title")));
                    }
                    continue;
                }
                if ("module".equals(qName)) {
                    String folders = XMLUtils.serializeToString((Node)attributes, (boolean)false);
                    RFModule list2 = new RFModule(ReportParams_Default.this.getModuleId(), attributes.getAttribute("name"), attributes.getAttribute("title"), folders);
                    ReportParams_Default.this.params.add(list2);
                    this.addToTabbed(list2, attributes.getAttribute("title"));
                    continue;
                }
                if ("listParams".equals(qName)) {
                    list = new RFListParams(attributes.getAttribute("name"), attributes.getAttribute("title"));
                    ReportParams_Default.this.params.add((ReportFilter)((Object)list));
                    this.addToTabbed((Component)((Object)list), attributes.getAttribute("title"));
                    continue;
                }
                if ("textField".equals(qName)) {
                    text = new RFTextField(attributes.getAttribute("name"), attributes.getAttribute("title"), attributes.getAttribute("textBefore"), attributes.getAttribute("textAfter"));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("contracts".equals(qName)) {
                    text = new RFContract(attributes.getAttribute("name"), attributes.getAttribute("title"));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("date".equals(qName)) {
                    text = new RFDate(attributes.getAttribute("name"), attributes.getAttribute("title"), this.getCalendar(attributes.getAttribute("default")));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("hours".equals(qName)) {
                    text = new RFHours(attributes.getAttribute("name1"), attributes.getAttribute("name2"), attributes.getAttribute("title"));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("month".equals(qName)) {
                    text = new RFMonth(attributes.getAttribute("name"), attributes.getAttribute("title"));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("monthAndDays".equals(qName)) {
                    text = new RFMonthAndDays(attributes.getAttribute("name1"), attributes.getAttribute("name2"), attributes.getAttribute("title"));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("period".equals(qName)) {
                    text = new RFPeriod(attributes.getAttribute("title"), attributes.getAttribute("name1"), attributes.getAttribute("name2"), this.getCalendar(attributes.getAttribute("default1")), this.getCalendar(attributes.getAttribute("default2")));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("periodWithTime".equals(qName)) {
                    text = new RFPeriodWithTime(attributes.getAttribute("title"), attributes.getAttribute("name1"), attributes.getAttribute("name2"), this.getCalendar(attributes.getAttribute("default1")), this.getCalendar(attributes.getAttribute("default2")));
                    ReportParams_Default.this.params.add(text);
                    panel.add((Component)((Object)text), this.getConstraints(attributes));
                    continue;
                }
                if ("contractGroups".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFContractGroups text2 = new RFContractGroups(attributes.getAttribute("name"), attributes.getAttribute("select_name"), title);
                    ReportParams_Default.this.params.add(text2);
                    this.addToTabbed(text2, title);
                    continue;
                }
                if ("contractLabels".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFContractLabels text3 = new RFContractLabels(attributes.getAttribute("name"), title, Boolean.parseBoolean(attributes.getAttribute("showBorder")));
                    ReportParams_Default.this.params.add(text3);
                    this.addToTabbed(text3, title);
                    continue;
                }
                if ("services".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFServices text4 = new RFServices(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid, Boolean.parseBoolean(attributes.getAttribute("showBorder")));
                    ReportParams_Default.this.params.add(text4);
                    this.addToTabbed((Component)((Object)text4), title);
                    continue;
                }
                if ("nases".equals(qName)) {
                    title = attributes.getAttribute("title");
                    int moduleId = ReportParams_Default.this.reportMid;
                    if (moduleId <= 0) {
                        moduleId = Utils.parseInt((String)attributes.getAttribute("mid"), (int)0);
                    }
                    RFNases text5 = new RFNases(attributes.getAttribute("name"), title, moduleId);
                    ReportParams_Default.this.params.add(text5);
                    this.addToTabbed((Component)((Object)text5), title);
                    continue;
                }
                if ("dealers".equals(qName)) {
                    title = attributes.getAttribute("title");
                    int moduleId = ReportParams_Default.this.reportMid;
                    if (moduleId <= 0) {
                        moduleId = Utils.parseInt((String)attributes.getAttribute("mid"), (int)0);
                    }
                    RFDealers text6 = new RFDealers(attributes.getAttribute("name"), title, moduleId);
                    ReportParams_Default.this.params.add(text6);
                    this.addToTabbed((Component)((Object)text6), title);
                    continue;
                }
                if ("paymentTypes".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFPaymentTypes text7 = new RFPaymentTypes(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text7);
                    this.addToTabbed(text7, title);
                    continue;
                }
                if ("chargeTypes".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFChargeTypes text8 = new RFChargeTypes(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text8);
                    this.addToTabbed(text8, title);
                    continue;
                }
                if ("tariffs".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFTariffPlan text9 = new RFTariffPlan(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text9);
                    this.addToTabbed((Component)((Object)text9), title);
                    continue;
                }
                if ("tariffOptions".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFTariffOptions text10 = new RFTariffOptions(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text10);
                    this.addToTabbed((Component)((Object)text10), title);
                    continue;
                }
                if ("tariffGroups".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFTariffGroups text11 = new RFTariffGroups(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text11);
                    this.addToTabbed((Component)((Object)text11), title);
                    continue;
                }
                if ("registerCategories".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFRegisterCategoryList text12 = new RFRegisterCategoryList(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text12);
                    this.addToTabbed((Component)((Object)text12), title);
                    continue;
                }
                if ("registerExecutors".equals(qName)) {
                    title = attributes.getAttribute("title");
                    boolean needBlank = "1".equals(attributes.getAttribute("blank"));
                    RFRegisterExecutors text13 = new RFRegisterExecutors(attributes.getAttribute("name"), title, needBlank, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text13);
                    this.addToTabbed((Component)((Object)text13), title);
                    continue;
                }
                if ("registerTaskType".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFRegisterTaskType text14 = new RFRegisterTaskType(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text14);
                    this.addToTabbed((Component)((Object)text14), title);
                    continue;
                }
                if ("registerGroups".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFRegisterGroups text15 = new RFRegisterGroups(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text15);
                    this.addToTabbed((Component)((Object)text15), title);
                    continue;
                }
                if ("users".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFUsers text16 = new RFUsers(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text16);
                    this.addToTabbed(text16, title);
                    continue;
                }
                if ("address".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFAddress part = new RFAddress(title, attributes.getAttribute("cityName"), attributes.getAttribute("streetName"), attributes.getAttribute("areaName"), attributes.getAttribute("quarterName"), attributes.getAttribute("houseName"));
                    panel.add((Component)part, this.getConstraints(attributes));
                    ReportParams_Default.this.params.add(part);
                    continue;
                }
                if ("cashcheckKKM".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFCashcheckKkmList text17 = new RFCashcheckKkmList(attributes.getAttribute("name"), title, ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(text17);
                    panel.add((Component)((Object)text17), this.getConstraints(attributes));
                    continue;
                }
                if ("inetDevices".equals(qName)) {
                    title = attributes.getAttribute("title");
                    int inetMid = Utils.parseInt((String)attributes.getAttribute("mid"), (int)-1);
                    RFInetDevices devices = new RFInetDevices(attributes.getAttribute("name"), title, inetMid > 0 ? inetMid : ReportParams_Default.this.reportMid);
                    ReportParams_Default.this.params.add(devices);
                    this.addToTabbed((Component)((Object)devices), title);
                    continue;
                }
                if ("contractStatuses".equals(qName) || "contractStatus".equals(qName)) {
                    title = attributes.getAttribute("title");
                    RFContractStatuses statuses = new RFContractStatuses(attributes.getAttribute("name"), title);
                    ReportParams_Default.this.params.add(statuses);
                    this.addToTabbed((Component)((Object)statuses), title);
                    continue;
                }
                if (!"checkbox".equals(qName)) continue;
                RFCheckbox cb = new RFCheckbox(attributes.getAttribute("name"), attributes.getAttribute("title"), Utils.parseBoolean((String)attributes.getAttribute("default")));
                ReportParams_Default.this.params.add(cb);
                panel.add((Component)cb, this.getConstraints(attributes));
            }
        }

        private Calendar getCalendar(String macros) {
            GregorianCalendar dateCalendar = new GregorianCalendar();
            if (macros.equals("today")) {
                return dateCalendar;
            }
            if (macros.equals("yesterday")) {
                ((Calendar)dateCalendar).add(5, -1);
                return dateCalendar;
            }
            if (macros.equals("tommorrow")) {
                ((Calendar)dateCalendar).add(5, 1);
                return dateCalendar;
            }
            if (macros.equals("first_day_of_month")) {
                dateCalendar.set(5, ((Calendar)dateCalendar).getActualMinimum(5));
                return dateCalendar;
            }
            if (macros.equals("last_day_of_month")) {
                dateCalendar.set(5, ((Calendar)dateCalendar).getActualMaximum(5));
                return dateCalendar;
            }
            return null;
        }

        private void addToTabbed(Component c, String title) {
            if (this.firstTabPane == null) {
                this.firstTabPane = c;
                this.firstTabPaneTitle = title;
            } else {
                if (this.tabbed == null) {
                    this.tabbed = new JTabbedPane();
                    this.tabbed.addTab(this.firstTabPaneTitle, this.firstTabPane);
                }
                this.tabbed.addTab(title, c);
            }
        }

        private GridBagConstraints getConstraints(Element a) {
            int x = Utils.parseInt((String)a.getAttribute("x"), (int)0);
            int y = Utils.parseInt((String)a.getAttribute("y"), (int)-1);
            if (y < 0) {
                y = this.lastY;
            }
            this.lastY = y + 1;
            this.maxY = Math.max(this.maxY, this.lastY);
            int width = Utils.parseInt((String)a.getAttribute("width"), (int)1);
            int height = Utils.parseInt((String)a.getAttribute("height"), (int)1);
            float xweight = Utils.parseFloat((String)a.getAttribute("xweight"), (float)1.0f);
            float yweight = Utils.parseFloat((String)a.getAttribute("yweight"), (float)0.0f);
            this.maxWidth = Math.max(this.maxWidth, x + width);
            int fill = ReportParams_Default.this.getFill(a);
            int anchor = ReportParams_Default.this.getAnchor(a);
            return new GridBagConstraints(x, y, width, height, xweight, yweight, anchor, fill, new Insets(2, 2, 2, 2), 0, 0);
        }

        public void end() {
            if (this.tabbed != null) {
                this.panel.add((Component)this.tabbed, new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else if (this.firstTabPane != null) {
                this.panel.add(this.firstTabPane, new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.maxY, this.maxWidth, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }
}

