/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.bean;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatusRest;
import ru.bitel.bgbilling.modules.qiwi.server.bean.AbstractQiwiProtocol;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public class QiwiRest
extends AbstractQiwiProtocol {
    private static final Logger logger = LogManager.getLogger();
    private ObjectMapper json = new ObjectMapper();

    public QiwiRest(Connection con, int mid, ModuleSetup moduleSetup) {
        super(con, mid, moduleSetup);
    }

    @Override
    public String beginTransaction(int contractId, String phone, BigDecimal sum, String successUrl, String failUrl) throws BGException {
        String redirectUrl;
        block33: {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 %d \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 %s \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 %s", contractId, Utils.maskPhoneNumber((String)phone, (int)2, (int)2), Utils.formatBigDecimalSumm((BigDecimal)sum)));
            }
            redirectUrl = null;
            String projectId = this.moduleSetup.get("qiwi.shop.id", null);
            if (Utils.isBlankString((String)projectId)) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 qiwi.shop.id");
            }
            try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
                Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setCreateDate(new Date())).setStatus(TransactionStatusRest.WAITING.getCode())).setSum(sum)).build();
                int identifyKeyParameterId = this.moduleSetup.getInt("qiwi.additional.identify.key.pid", 0);
                if (identifyKeyParameterId > 0) {
                    try (ContractDao contractDao = new ContractDao(this.connection, 0);){
                        transaction.setAdditionalKey((String)contractDao.getContractParameterTextAsString(contractId, identifyKeyParameterId).orElse(null));
                    }
                }
                manager.addTransaction(transaction);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c %s", transaction.getTransactionId(), transaction.getStatus()));
                }
                try {
                    String billId = String.valueOf(transaction.getTransactionId());
                    CloseableHttpClient client = HttpClientBuilder.create().build();
                    HttpPut putRequest = new HttpPut("https://api.qiwi.com/api/v2/prv/" + projectId + "/bills/" + billId);
                    putRequest.setHeader("Accept", "application/json");
                    String auth = "Basic " + Base64.encode((String)(this.moduleSetup.get("qiwi.login") + ":" + this.moduleSetup.get("qiwi.password")), (String)"UTF-8");
                    putRequest.setHeader("Authorization", auth);
                    ArrayList<BasicNameValuePair> valuePairs = new ArrayList<BasicNameValuePair>(6);
                    valuePairs.add(new BasicNameValuePair("user", "tel:+" + phone));
                    valuePairs.add(new BasicNameValuePair("amount", Utils.formatBigDecimalSumm((BigDecimal)sum)));
                    valuePairs.add(new BasicNameValuePair("ccy", "RUB"));
                    String comment = this.moduleSetup.get("qiwi.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", this.contractManager.getContractById(contractId).getTitle());
                    valuePairs.add(new BasicNameValuePair("comment", comment));
                    Calendar now = Calendar.getInstance();
                    now.add(5, 45);
                    valuePairs.add(new BasicNameValuePair("lifetime", TimeUtils.format((Calendar)now, (String)"yyyy-MM-dd'T'HH:mm:ss")));
                    String providerName = this.moduleSetup.get("qiwi.provider.name");
                    if (Utils.notBlankString((String)providerName)) {
                        valuePairs.add(new BasicNameValuePair("prv_name", providerName));
                    }
                    putRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(valuePairs, "UTF-8"));
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: user=tel:+%s, amount=%s, ccy=RUB, comment=%s, lifetime=%s, prv_name=%s", Utils.maskPhoneNumber((String)phone, (int)2, (int)2), Utils.formatBigDecimalSumm((BigDecimal)sum), comment, TimeUtils.format((Calendar)now, (String)"yyyy-MM-dd'T'HH:mm:ss"), providerName));
                    }
                    HttpResponse response = client.execute((HttpUriRequest)putRequest);
                    try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                         BufferedReader rd = new BufferedReader(inputStreamReader);){
                        JsonNode root;
                        JsonNode responseNode;
                        JsonNode resultCodeNode;
                        int resultCode;
                        StringBuffer result = new StringBuffer();
                        String line = "";
                        while ((line = rd.readLine()) != null) {
                            result.append(line);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: %s", result));
                        }
                        if ((resultCode = ((Integer)this.json.convertValue((Object)(resultCodeNode = (responseNode = (root = this.json.readTree(result.toString())).path("response")).path("result_code")), Integer.class)).intValue()) == 0) {
                            redirectUrl = "https://bill.qiwi.com/order/external/main.action?shop=" + projectId + "&transaction=" + billId + "&successUrl=" + successUrl + "&failUrl=" + failUrl;
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("", "https://bill.qiwi.com/order/external/main.action?shop=" + Utils.maskConfidential((String)projectId) + "&transaction=" + billId + "&successUrl=" + successUrl + "&failUrl=" + failUrl));
                            }
                            break block33;
                        }
                        AbstractQiwiProtocol.QiwiResultCode qiwiResultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(resultCode);
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + qiwiResultCode.getCode() + " ): " + qiwiResultCode.getTitle());
                    }
                }
                catch (IOException e) {
                    throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0443: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return redirectUrl;
    }

    @Override
    public void checkTransaction(Transaction transaction) throws BGException {
        block26: {
            String projectId;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c %s", transaction.getId()));
            }
            if (Utils.isBlankString((String)(projectId = this.moduleSetup.get("qiwi.shop.id", null)))) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 qiwi.shop.id");
            }
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet getRequest = new HttpGet("https://api.qiwi.com/api/v2/prv/" + projectId + "/bills/" + String.valueOf(transaction.getId()));
            getRequest.setHeader("Accept", "application/json");
            String auth = "Basic " + Base64.encode((String)(this.moduleSetup.get("qiwi.login") + ":" + this.moduleSetup.get("qiwi.password")), (String)"UTF-8");
            getRequest.setHeader("Authorization", auth);
            try {
                HttpResponse response = client.execute((HttpUriRequest)getRequest);
                try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                     BufferedReader rd = new BufferedReader(inputStreamReader);){
                    JsonNode root;
                    JsonNode responseNode;
                    JsonNode resultCodeNode;
                    int resultCode;
                    StringBuffer result = new StringBuffer();
                    String line = "";
                    while ((line = rd.readLine()) != null) {
                        result.append(line);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: %s", result));
                    }
                    if ((resultCode = ((Integer)this.json.convertValue((Object)(resultCodeNode = (responseNode = (root = this.json.readTree(result.toString())).path("response")).path("result_code")), Integer.class)).intValue()) == 0) {
                        JsonNode billNode = responseNode.path("bill");
                        String newStatus = billNode.path("status").asText(null);
                        if (!Utils.notBlankString((String)newStatus)) break block26;
                        TransactionStatusRest oldBillingStatus = (TransactionStatusRest)TransactionStatusRest.ALL.getStatusByCode(transaction.getStatus());
                        TransactionStatusRest newBillingStatus = (TransactionStatusRest)TransactionStatusRest.ALL.getStatusByCode(newStatus);
                        try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
                            transaction.setStatus(newBillingStatus.getCode());
                            manager.update(transaction);
                            if (!oldBillingStatus.equals((Object)TransactionStatusRest.PAID) && newBillingStatus.equals((Object)TransactionStatusRest.PAID)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u0430, \u0437\u0430\u043d\u043e\u0441\u0438\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0411\u0414");
                                }
                                this.addPayment(transaction, manager);
                            }
                            break block26;
                        }
                        catch (SQLException e) {
                            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    AbstractQiwiProtocol.QiwiResultCode qiwiResultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(resultCode);
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + qiwiResultCode.getCode() + " ): " + qiwiResultCode.getTitle());
                }
            }
            catch (IOException e) {
                throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void cancelTransaction(Transaction transaction) throws BGException {
        block23: {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u0443 \u0435\u0449\u0435 \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0439 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c %d", transaction.getId()));
            }
            if (transaction.getStatus().equals(TransactionStatusRest.PAID.getCode())) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e. \u0412\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435\u0441\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u043c!");
            }
            String projectId = this.moduleSetup.get("qiwi.shop.id", null);
            if (Utils.isBlankString((String)projectId)) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 qiwi.shop.id");
            }
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPatch patchRequest = new HttpPatch("https://api.qiwi.com/api/v2/prv/" + projectId + "/bills/" + String.valueOf(transaction.getId()));
            patchRequest.setHeader("Accept", "application/json");
            String auth = "Basic " + Base64.encode((String)(this.moduleSetup.get("qiwi.login") + ":" + this.moduleSetup.get("qiwi.password")), (String)"UTF-8");
            patchRequest.setHeader("Authorization", auth);
            try {
                ArrayList<BasicNameValuePair> valuePairs = new ArrayList<BasicNameValuePair>(6);
                valuePairs.add(new BasicNameValuePair("status", "rejected"));
                patchRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(valuePairs));
                HttpResponse response = client.execute((HttpUriRequest)patchRequest);
                try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                     BufferedReader rd = new BufferedReader(inputStreamReader);){
                    JsonNode root;
                    JsonNode responseNode;
                    JsonNode resultCodeNode;
                    int resultCode;
                    StringBuffer result = new StringBuffer();
                    String line = "";
                    while ((line = rd.readLine()) != null) {
                        result.append(line);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: %s", result));
                    }
                    if ((resultCode = ((Integer)this.json.convertValue((Object)(resultCodeNode = (responseNode = (root = this.json.readTree(result.toString())).path("response")).path("result_code")), Integer.class)).intValue()) == 0) {
                        JsonNode billNode = responseNode.path("bill");
                        String status = billNode.path("status").asText(null);
                        if (!"rejected".equals(status)) break block23;
                        try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
                            transaction.setStatus(status);
                            manager.update(transaction);
                            break block23;
                        }
                    }
                    AbstractQiwiProtocol.QiwiResultCode qiwiResultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(resultCode);
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u043c\u0435\u043d\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + qiwiResultCode.getCode() + " ): " + qiwiResultCode.getTitle());
                }
            }
            catch (IOException e) {
                throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0449\u0435 \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void refundTransaction(Transaction transaction) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0439 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c %d", transaction.getId()));
        }
        if (!transaction.getStatus().equals(TransactionStatusRest.PAID.getCode())) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043f\u043e \u0435\u0449\u0435 \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0439 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438.");
        }
        String projectId = this.moduleSetup.get("qiwi.shop.id", null);
        if (Utils.isBlankString((String)projectId)) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 qiwi.shop.id");
        }
        String refundId = PswdGen.generatePassword((int)9, (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMOPQRSTUVWXYZ0123456789");
        try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
            transaction.setRefundId(refundId);
            transaction.setStatus(TransactionStatusRest.REFUND_REQUEST.getCode());
            manager.update(transaction);
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPut putRequest = new HttpPut("https://api.qiwi.com/api/v2/prv/" + projectId + "/bills/" + String.valueOf(transaction.getId()) + "/refund/" + refundId);
        putRequest.setHeader("Accept", "application/json");
        String auth = "Basic " + Base64.encode((String)(this.moduleSetup.get("qiwi.login") + ":" + this.moduleSetup.get("qiwi.password")), (String)"UTF-8");
        putRequest.setHeader("Authorization", auth);
        try {
            ArrayList<BasicNameValuePair> valuePairs = new ArrayList<BasicNameValuePair>(6);
            valuePairs.add(new BasicNameValuePair("amount", "rejected"));
            putRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(valuePairs));
            HttpResponse response = client.execute((HttpUriRequest)putRequest);
            try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                 BufferedReader rd = new BufferedReader(inputStreamReader);){
                JsonNode root;
                JsonNode responseNode;
                JsonNode resultCodeNode;
                int resultCode;
                StringBuffer result = new StringBuffer();
                String line = "";
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: %s", result));
                }
                if ((resultCode = ((Integer)this.json.convertValue((Object)(resultCodeNode = (responseNode = (root = this.json.readTree(result.toString())).path("response")).path("result_code")), Integer.class)).intValue()) != 0) {
                    AbstractQiwiProtocol.QiwiResultCode qiwiResultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(resultCode);
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + qiwiResultCode.getCode() + " ): " + qiwiResultCode.getTitle());
                }
            }
        }
        catch (IOException e) {
            throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0438\u0442\u044c \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void checkRefundStatus(Transaction transaction) throws BGException {
        block23: {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c %d", transaction.getId()));
            }
            if (!transaction.getStatus().equals(TransactionStatusRest.REFUND_REQUEST.getCode())) {
                throw new BGMessageException(String.format("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c %d \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0434\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430.", transaction.getId()));
            }
            String projectId = this.moduleSetup.get("qiwi.shop.id", null);
            if (Utils.isBlankString((String)projectId)) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 qiwi.shop.id");
            }
            String refundId = transaction.getRefundId();
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPut getRequest = new HttpPut("https://api.qiwi.com/api/v2/prv/" + projectId + "/bills/" + String.valueOf(transaction.getId()) + "/refund/" + refundId);
            getRequest.setHeader("Accept", "application/json");
            String auth = "Basic " + Base64.encode((String)(this.moduleSetup.get("qiwi.login") + ":" + this.moduleSetup.get("qiwi.password")), (String)"UTF-8");
            getRequest.setHeader("Authorization", auth);
            try {
                HttpResponse response = client.execute((HttpUriRequest)getRequest);
                try (InputStreamReader inputStreamReader = new InputStreamReader(response.getEntity().getContent());
                     BufferedReader rd = new BufferedReader(inputStreamReader);){
                    JsonNode root;
                    JsonNode responseNode;
                    JsonNode resultCodeNode;
                    int resultCode;
                    StringBuffer result = new StringBuffer();
                    String line = "";
                    while ((line = rd.readLine()) != null) {
                        result.append(line);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: %s", result));
                    }
                    if ((resultCode = ((Integer)this.json.convertValue((Object)(resultCodeNode = (responseNode = (root = this.json.readTree(result.toString())).path("response")).path("result_code")), Integer.class)).intValue()) == 0) {
                        JsonNode refundNode = responseNode.path("refund");
                        String status = refundNode.path("status").asText(null);
                        if (!"success".equals(status)) break block23;
                        try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
                            transaction.setStatus(status);
                            manager.update(transaction);
                            break block23;
                        }
                    }
                    AbstractQiwiProtocol.QiwiResultCode qiwiResultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(resultCode);
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + qiwiResultCode.getCode() + " ): " + qiwiResultCode.getTitle());
                }
            }
            catch (IOException e) {
                throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

