/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.modules.payonline.common.bean.RebillTransaction;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.RebillTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RebillWorker
extends Thread {
    private final Logger log = LogManager.getLogger();
    private Connection con;
    private int mid = -1;
    private String rebillUrl = null;
    private String merchantId = null;
    private String privateSecKey = null;
    private List<Rebill> payOnlineRebills = null;
    private RebillManager rebillManager = null;
    private String currency = null;
    private static final char POST_DELIM = '&';
    public static final String CURRENCY = "RUB";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.con = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("run");
            }
            this.con = Setup.getSetup().getDBConnectionFromPool();
            this.rebillManager = new RebillManager(this.con, this.mid);
            for (Rebill rebill : this.payOnlineRebills) {
                try {
                    this.rebillPay(rebill);
                }
                catch (Exception e) {
                    this.log.error("Error rebill id=>" + rebill.getId(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("Rebil error: " + e.getLocalizedMessage(), (Throwable)e);
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                if (!(ex instanceof InterruptedException)) continue;
                this.log.error("thread was interrupted!!!!!!!!");
                this.interrupt();
            }
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    public void init(int mid, String rebillUrl, String merchantId, String privateSecKey, List<Rebill> rebillTransactionList) {
        this.mid = mid;
        this.payOnlineRebills = rebillTransactionList;
        this.rebillUrl = rebillUrl;
        this.merchantId = merchantId;
        this.privateSecKey = privateSecKey;
    }

    public void rebillPay(Rebill payOnlineRebill) throws BGException {
        if (!RebillWorker.checkDate(payOnlineRebill.getActivateDate(), new Date())) {
            this.log.info("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c #" + payOnlineRebill.getId() + " \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043c\u0435\u0441\u044f\u0446\u0435 [RebillActivateDate = " + TimeUtils.format((Date)payOnlineRebill.getActivateDate(), (String)"dd.MM.yyyy") + "]");
            return;
        }
        try {
            StringBuilder urlStr = new StringBuilder(150);
            urlStr.append(this.rebillUrl);
            urlStr.append("?");
            StringBuilder sb = new StringBuilder(100);
            sb.append("MerchantId=");
            sb.append(this.merchantId);
            sb.append('&');
            sb.append("RebillAnchor=");
            sb.append(payOnlineRebill.getRebillAnchor());
            sb.append('&');
            sb.append("OrderId=");
            String[] mas = payOnlineRebill.getOrderId().split("_");
            if (mas.length == 2 || mas.length == 3 && mas[2].length() > 1) {
                payOnlineRebill.setOrderId(payOnlineRebill.getOrderId() + "_1");
                this.rebillManager.update(payOnlineRebill);
            }
            if ((mas = payOnlineRebill.getOrderId().split("_")).length == 3) {
                payOnlineRebill.setOrderId(mas[0] + "_" + System.currentTimeMillis() + "_" + mas[2]);
            } else if (mas.length == 4) {
                payOnlineRebill.setOrderId(mas[0] + "_" + mas[1] + "_" + System.currentTimeMillis() + "_" + mas[3]);
            } else {
                throw new RuntimeException("error order_id=" + payOnlineRebill.getOrderId());
            }
            this.rebillManager.update(payOnlineRebill);
            sb.append(payOnlineRebill.getOrderId());
            sb.append('&');
            sb.append("Amount=");
            sb.append(Utils.formatBigDecimal((BigDecimal)payOnlineRebill.getSumma(), (int)2));
            sb.append('&');
            sb.append("Currency=");
            if (Utils.notBlankString((String)this.currency)) {
                sb.append(this.currency);
            } else {
                sb.append(CURRENCY);
            }
            sb.append('&');
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] digest = md5.digest((sb.toString() + "PrivateSecurityKey=" + this.privateSecKey).getBytes());
            sb.append("SecurityKey=");
            sb.append(Utils.bytesToHexString((byte[])digest).toLowerCase());
            urlStr.append(sb.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u0421\u0442\u0440\u043e\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 - " + urlStr.toString());
                this.log.debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430 ...");
            }
            try {
                URL url = new URL(urlStr.toString());
                HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
                httpUrlConnection.setRequestMethod("GET");
                httpUrlConnection.connect();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("\u0421\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c \u043e\u0442\u0432\u0435\u0442.....");
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    stringBuilder.append(line);
                    stringBuilder.append("\n");
                    line = br.readLine();
                }
                httpUrlConnection.disconnect();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 :");
                    this.log.debug(stringBuilder.toString());
                    this.log.debug("\u0420\u0430\u0437\u0431\u043e\u0440 \u043e\u0442\u0432\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430.");
                }
                Preferences answ = new Preferences(stringBuilder.toString(), "&");
                String resultParam = answ.get("Result", null);
                RebillTransaction transaction = new RebillTransaction();
                transaction.setErrorCode(0);
                if (resultParam.equals("Error")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("\u041e\u0448\u0438\u0431\u043a\u0430!!!");
                    }
                    int errorCodeParam = answ.getInt("errorCode", -1);
                    transaction.setErrorCode(errorCodeParam);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(" \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 payonline: " + errorCodeParam);
                    }
                    this.rebillManager.delete(payOnlineRebill.getId());
                }
                transaction.setId(-1);
                transaction.setCode(answ.getInt("Code", -1));
                transaction.setContractId(payOnlineRebill.getContractId());
                transaction.setDate(new Date());
                transaction.setResult(resultParam);
                transaction.setStatus(answ.get("Status", null));
                long transactionId = Utils.parseLong((String)answ.get("Id", null), (long)-1L);
                transaction.setTransactionId(transactionId);
                RebillTransactionManager rebillTransacionManager = new RebillTransactionManager(this.con, this.mid);
                rebillTransacionManager.update(transaction);
                rebillTransacionManager.close();
                if (this.log.isDebugEnabled()) {
                    this.log.info("\u041a\u043e\u043d\u0435\u0446 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430.");
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error(e.getMessage());
        }
    }

    private static boolean checkDate(Date from, Date pay) {
        Calendar cfrom = TimeUtils.convertDateToCalendar((Date)from);
        Calendar cpay = TimeUtils.convertDateToCalendar((Date)pay);
        int fmm = cfrom.get(2);
        int fyy = cfrom.get(1);
        int pmm = cpay.get(2);
        int pyy = cpay.get(1);
        return pmm > fmm && pyy >= fyy || pmm <= fmm && pyy > fyy;
    }
}

