/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.action.web;

import bitel.billing.server.ActionResultContentType;
import jakarta.annotation.Resource;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paymaster.common.service.PayMasterService;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.Constants;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="PayMaster")
public class ActionDoTransaction
extends AbstractPaymentAction {
    @Resource
    private PayMasterService payMasterService;

    public ActionDoTransaction() {
        super("paymaster");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1"});
            transactionManager.searchTransactionList((SearchResult<Transaction>)searchResult, 0, this.contractId, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void failure() throws BGException {
        this.execute();
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
    }

    public void success() throws BGException {
        this.execute();
        throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        try {
            Holder mode = new Holder();
            Holder redirectUrl = new Holder();
            Holder params = new Holder((Object)new MapHolder());
            if (!Utils.isBlankString((String)this.customerAddress)) {
                ((MapHolder)params.value).getMap().put(this.customerAddress.contains("@") ? "email" : "phone", this.customerAddress);
            }
            this.payMasterService.beginTransaction(this.contractId, this.sum, redirectUrl, mode, params);
            this.setResultParam("contentType", ActionResultContentType.binary);
            this.context.getResponse().sendRedirect((String)redirectUrl.value);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        super.autopayment();
        BigDecimal sum = BigDecimal.ZERO;
        boolean createToken = false;
        boolean autopaymentEnable = this.moduleSetup.getBoolean("paymaster.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = Autopayment.builder().setContractId(this.contractId).build();
            }
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                this.autopaymentWeek("PAYMASTER", modeDataMap, autopayment, Constants.class);
                createToken = true;
                sum = autopayment.getSum();
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                this.autopaymentMonth("PAYMASTER", modeDataMap, autopayment, Constants.class);
                createToken = true;
                sum = autopayment.getSum();
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                this.autopaymentAuto("PAYMASTER", modeDataMap, autopayment, Constants.class);
                createToken = true;
                sum = autopayment.getSum();
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
        }
        if (createToken) {
            try {
                Holder redirectUrl = new Holder();
                Holder mode2 = new Holder();
                MapHolder paramMap = new MapHolder();
                Holder params = new Holder((Object)paramMap);
                paramMap.getMap().put("LMI_CREATE_TOKEN", "True");
                paramMap.getMap().put("LMI_PAYMENT_METHOD", this.moduleSetup.get("paymaster.payment.method", "503"));
                this.payMasterService.beginTransaction(this.contractId, sum, redirectUrl, mode2, params);
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect((String)redirectUrl.value);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        } else {
            this.execute();
        }
    }
}

