/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.amount;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ModuleAmountManager {
    private List<ModuleAmount> moduleAmountList = new ArrayList<ModuleAmount>();
    private Map<Integer, ModuleAmount> moduleAmountMap = new HashMap<Integer, ModuleAmount>();

    public ModuleAmountManager(Preferences moduleSetup) throws BGException {
        ParameterMap values = moduleSetup.sub("module.amount.");
        for (Map.Entry entry : values.entrySet()) {
            String value = (String)entry.getValue();
            String[] number_param = ((String)entry.getKey()).split("\\.");
            if (number_param.length != 2 || !number_param[1].equals("title")) continue;
            int id = Utils.parseInt((String)number_param[0], (int)0);
            String title = value;
            String className = values.get(id + ".class", null);
            int moduleId = Utils.parseInt((String)values.get(id + ".mid", null), (int)0);
            String sids = values.get(id + ".sids", null);
            ModuleAmount moduleAmount = (ModuleAmount)Utils.newInstance((String)className, ModuleAmount.class);
            if (moduleAmount == null || !Utils.notBlankString((String)title) || moduleId <= 0) continue;
            moduleAmount.setId(id);
            moduleAmount.setModleId(moduleId);
            moduleAmount.setTitle(title);
            moduleAmount.setSids(sids);
            this.moduleAmountList.add(moduleAmount);
            this.moduleAmountMap.put(moduleAmount.getId(), moduleAmount);
        }
        Collections.sort(this.moduleAmountList, new Comparator<ModuleAmount>(){

            @Override
            public int compare(ModuleAmount o1, ModuleAmount o2) {
                return o1.getId() - o2.getId();
            }
        });
    }

    public List<ModuleAmount> getModuleAmountList() {
        return this.moduleAmountList;
    }

    public Map<Integer, ModuleAmount> getModuleAmountMap() {
        return this.moduleAmountMap;
    }
}

