/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public final class OptimaPlusTransactionManager
extends MPSTransactionManager {
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(.+)\\t(\\d+)\\t([\\d+: -T]+)\\t(\\d+\\.*\\d*)\\t(\\d+)$", 8);

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest req = null;
        try {
            req = new MPSRequest(con, moduleId, mpsId, request, system);
            String xml = request.getParameter("XML");
            Document doc = this.documentBuilder.parse(new InputSource(new StringReader(xml)));
            String data = xml.substring(xml.indexOf("<data>"), xml.indexOf("</data>") + 7);
            String reqHash = XMLUtils.selectText((Node)doc, (String)"/root/sign/text()", null);
            try {
                Signature sign = Signature.getInstance("MD5withRSA");
                sign.initVerify(system.publicKey);
                sign.update(data.getBytes("UTF-8"));
                byte[] b = Utils.stringToBytes((String)reqHash, null);
                if (!sign.verify(b)) {
                    throw new MPSException(10);
                }
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
                throw new MPSException(-1);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new MPSException(-1);
            }
            String type = XMLUtils.selectText((Node)doc, (String)"/root/data/type/text()");
            if (type.equals("request")) {
                req.setAction(1);
                req.setNumber(XMLUtils.selectText((Node)doc, (String)"/root/data/number/text()", (String)""));
            } else if (type.equals("payment")) {
                req.setAction(2);
                req.setNumber(XMLUtils.selectText((Node)doc, (String)"/root/data/number/text()", (String)""));
                req.setTransId(XMLUtils.selectText((Node)doc, (String)"/root/data/id/text()"));
                req.setRawNumber(req.getNumber());
                req.setSum(Utils.parseBigDecimal((String)XMLUtils.selectText((Node)doc, (String)"/root/data/summ/text()"), (BigDecimal)BigDecimal.ZERO));
            }
            req.setTime(TimeUtils.parseDate((String)XMLUtils.selectText((Node)doc, (String)"/root/data/date/text()", (String)""), (String)"dd.MM.yyyy HH:mm:ss"));
            req.setType(Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/root/data/usluga/text()"), (int)0));
        }
        catch (Exception e) {
            throw new MPSException(-1);
        }
        return req;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
        mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            mpsRequest = this.parseRequest(con, moduleId, mpsId, system, httpRequest);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            switch (mpsRequest.getAction()) {
                case 1: {
                    contract = this.actionCheck(mpsRequest);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    mpsResponse.setLocalTime(new Date());
                    bu = new BalanceUtils(con);
                    mpsResponse.setSum(bu.getBalance(LocalDate.now(), contract.getId()));
                    bu.close();
                    break;
                }
                case 2: {
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null) ** GOTO lbl27
                    contract = this.actionCheck(mpsRequest);
                    this.checkTime(mpsRequest);
                    transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    ** GOTO lbl36
lbl27:
                    // 1 sources

                    contractManager = new ContractManager(con);
                    try {
                        contract = contractManager.getContractById(transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    finally {
                        contractManager.close();
                    }
lbl36:
                    // 2 sources

                    mpsResponse.setId(transaction.getId());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        String hash;
        StringBuilder xml = new StringBuilder();
        StringBuilder data = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<root>");
        data.append("<data>");
        data.append("<result>");
        data.append(String.valueOf(response.getResult()));
        data.append("</result>");
        data.append("<addition>");
        data.append(String.valueOf(response.getMessage()));
        data.append("</addition>");
        if (response.getAction() == 1) {
            data.append("<balance>");
            data.append(String.valueOf(response.getSum()));
            data.append("</balance>");
        }
        data.append("</data>");
        try {
            PrivateKey privateKey = system.getPrivateKey();
            Signature sign = Signature.getInstance("MD5withRSA");
            sign.initSign(privateKey);
            sign.update(data.toString().getBytes(this.getEncoding()));
            hash = Utils.bytesToHexString((byte[])sign.sign());
        }
        catch (GeneralSecurityException e) {
            hash = "";
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            hash = "";
            e.printStackTrace();
        }
        xml.append(data.toString());
        xml.append("<sign>");
        xml.append(hash);
        xml.append("</sign>");
        xml.append("</root>");
        byte[] b = null;
        try {
            b = xml.toString().getBytes(this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return b;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case -1: 
            case 2: 
            case 6: {
                response.setResult(4);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(2);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(3);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case 10: {
                response.setResult(1);
                response.setMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u042d\u0426\u041f");
                break;
            }
            case 9: {
                response.setResult(5);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        super.checkValid(system, req, con);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    private class ErrorCode {
        private static final int ANSWER_SUCCESS = 0;
        private static final int ANSWER_ERR_HASH = 1;
        private static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 2;
        private static final int ANSWER_ERR_SUMM = 3;
        private static final int ANSWER_ERR_REQUEST = 4;
        private static final int ANSWER_ERR_BLOCK = 5;

        private ErrorCode() {
        }
    }
}

