/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class MegafonContractProductDao
extends AbstractIdDao<MegafonContractProduct> {
    public MegafonContractProductDao(Connection con, int moduleId) {
        super(con, moduleId, "megafon_contract_product");
    }

    public Result<MegafonContractProduct> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        return super.list(page, filter, orderBy, params);
    }

    protected MegafonContractProduct getFromRS(ResultSet rs) throws SQLException {
        MegafonContractProduct contractProduct = new MegafonContractProduct();
        contractProduct.setId(rs.getInt("id"));
        contractProduct.setContractId(rs.getInt("contract_id"));
        contractProduct.setProductId(rs.getInt("product_id"));
        contractProduct.setStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("status")));
        contractProduct.setMsisdn(rs.getString("msisdn"));
        contractProduct.setAdditionalMsisdn(rs.getString("additional_msisdn"));
        contractProduct.setStartTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("start_time")));
        contractProduct.setEndTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("end_time")));
        contractProduct.setOrderId(rs.getLong("order_id"));
        contractProduct.setMnpOrderComment(rs.getString("mnp_comment"));
        contractProduct.setTariffId(rs.getInt("tariff_id"));
        return contractProduct;
    }

    protected void updateImpl(MegafonContractProduct contractProduct) throws SQLException {
        boolean isUpdate = contractProduct.getId() > 0;
        String query = (isUpdate ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET product_id=?, status=?, msisdn=?, additional_msisdn=?, start_time=?, end_time=?, contract_id=?, mnp_comment=?, tariff_id=?, order_id=?" + (isUpdate ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractProduct.getProductId());
            ps.setInt(index++, contractProduct.getStatus() != null ? contractProduct.getStatus().ordinal() : -1);
            ps.setString(index++, contractProduct.getMsisdn());
            ps.setString(index++, contractProduct.getAdditionalMsisdn());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractProduct.getStartTime()));
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractProduct.getEndTime()));
            ps.setInt(index++, contractProduct.getContractId());
            ps.setString(index++, contractProduct.getMnpOrderComment());
            ps.setInt(index++, contractProduct.getTariffId());
            ps.setLong(index, contractProduct.getOrderId());
            ps.executeUpdate();
        }
    }
}

