/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.xml.JAXBUtils;

public class ContractProductCopiesPanel
extends ServicePanel {
    private BGTableModel<Copy> model;
    private BGUTable tableCopies;
    private CopyEditor editor;
    private static final Logger log = LogManager.getLogger();

    public ContractProductCopiesPanel() {
        this.tableCopies = new BGUTable(this.model);
        this.editor = new CopyEditor();
        try {
            this.model = new BGTableModel<Copy>("\u041a\u043e\u043f\u0438\u0438"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", 200, 200, 200, "productTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
                    this.addColumn("\u0412\u0435\u0440\u0441\u0438\u044f", 100, 100, 100, "productVersion", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                    this.addColumn("\u0414\u0430\u0442\u0430", 180, 180, 180, "date", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                    this.addColumn("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442", 200, 300, 400, "licenseeName", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
                }
            };
            this.tableCopies.setModel(this.model);
            this.jbInit();
        }
        catch (Exception e) {
            log.error("ContractProductCopiesPanel()", (Throwable)e);
        }
    }

    public void setModuleData(String module, int moduleId, int contractId) {
        if (Utils.isEmptyString((String)this.module) || this.getModuleId() == -1 || this.getContractId() == -1) {
            this.module = module;
            this.setModuleId(moduleId);
            this.setContractId(contractId);
        }
    }

    public void jbInit() {
        this.setLayout(new BorderLayout());
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.tableCopies), (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), "Center");
        this.add(BGSwingUtilites.wrapBorder((JPanel)this.editor, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), "South");
        this.editor.setVisible(false);
        this.tableCopies.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractProductCopiesPanel.this.editItem();
                }
            }
        });
    }

    private void stopEdit(boolean save) {
        if (save) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("UpdateCopy");
            request.setAttribute("copy_id", this.editor.currentId);
            request.setAttribute("product_id", this.editor.availableProducts.getSelectedId());
            request.setAttribute("licensee_name", this.editor.licenseeName.getText());
            request.setAttribute("comment", this.editor.comment.getText());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.editor.setVisible(false);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    public void newItem() {
        this.editor.currentId = -1;
        this.editor.licenseeName.setText("");
        this.editor.comment.setText("");
        this.setAvailableProducts();
        this.editor.availableProducts.setEnabled(true);
        this.editor.setVisible(true);
    }

    public void editItem() {
        int row = this.tableCopies.getSelectedRow();
        if (row >= 0) {
            int copyId = ((Copy)this.model.getSelectedRow()).getId();
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("GetCopy");
            request.setAttribute("copy_id", copyId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Copy copy = (Copy)JAXBUtils.unmarshal((Node)doc, (String)"/data/copy", Copy.class);
                this.editor.currentId = copyId;
                this.editor.licenseeName.setText(copy.getLicenseeName());
                this.editor.comment.setText(copy.getComment());
                this.setAvailableProducts();
                this.editor.availableProducts.setSelectedId(String.valueOf(copy.getProductId()));
                this.editor.availableProducts.setEnabled(false);
                this.editor.setVisible(true);
            }
        }
    }

    public void setData() {
        try {
            this.model.setData(((LicenseService)this.getContext().getPort(LicenseService.class, this.getModuleId())).copyList(this.getContractId()));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.editor.setVisible(false);
    }

    private void setAvailableProducts() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAttribute("cid", this.getContractId());
        request.setAction("GetProducts");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.editor.availableProducts.removeAllItems();
            Iterable productElements = XMLUtils.selectElements((Node)doc, (String)"data/table/data/row");
            for (Element p : productElements) {
                Integer productId = Integer.valueOf(XMLUtils.getAttribute((Element)p, (String)"id"));
                String productTitle = XMLUtils.getAttribute((Element)p, (String)"title") + " " + XMLUtils.getAttribute((Element)p, (String)"version");
                this.editor.availableProducts.addItem((Object)new ComboBoxItem((Object)productId, productTitle));
            }
        }
    }

    class CopyEditor
    extends JPanel {
        private int currentId;
        private BGComboBox<ComboBoxItem> availableProducts;
        private BGTextField licenseeName;
        private BGTextField comment;
        private BGButtonPanelOkCancel okCancelPanel;

        public CopyEditor() {
            super(new GridBagLayout());
            this.availableProducts = new BGComboBox();
            this.licenseeName = new BGTextField();
            this.comment = new BGTextField();
            this.okCancelPanel = new BGButtonPanelOkCancel();
            int index = 0;
            this.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.availableProducts, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.licenseeName, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.comment, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.okCancelPanel, new GridBagConstraints(0, index++, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.okCancelPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContractProductCopiesPanel.this.stopEdit(e.getActionCommand().equals("ok"));
                }
            });
        }
    }
}

