/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.admin;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ComponentCategory;
import ru.bitel.bgbilling.modules.license.common.bean.Product;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.xml.JAXBUtils;

public class ServiceConfigProducts
extends ServiceConfigTabbedPanel {
    private static Logger log = LogManager.getLogger();
    private BGTabbedPane tabbedPane = new BGTabbedPane();
    private BGControlPanelListSelect selectList = new BGControlPanelListSelect();
    private BGControlPanelListSelect availableList = new BGControlPanelListSelect();
    private BGTitleBorder selectComponentListBorder = new BGTitleBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
    private BGTitleBorder availableComponentListBorder = new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
    private BGTitleBorder selectProductListBorder = new BGTitleBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
    private BGTitleBorder availableProductListBorder = new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
    private ProductsTableModel productsTableModel = new ProductsTableModel();
    private ComponentsTableModel componentsTableModel = new ComponentsTableModel();
    private LicenseService licenseService = null;

    public ServiceConfigProducts() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.error("ServiceConfigProducts", (Throwable)e);
        }
    }

    private void jbInit() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ServiceConfigProducts.this.editItem();
                }
                ServiceConfigProducts.this.setLists();
            }
        };
        this.tabbedPane.add("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b", (java.awt.Component)this.getProductsPanel(mouseAdapter));
        this.tabbedPane.add("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", (java.awt.Component)this.getProductItemsPanel(mouseAdapter));
        this.tabbedPane.addChangeListener(event -> {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.selectList.setBorder((Border)this.selectComponentListBorder);
                this.availableList.setBorder((Border)this.availableComponentListBorder);
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.selectList.setBorder((Border)this.selectProductListBorder);
                this.availableList.setBorder((Border)this.availableProductListBorder);
            }
            this.setData();
        });
        this.setLayout(new GridBagLayout());
        this.add((java.awt.Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getLinksPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
    }

    private JPanel getProductsPanel(MouseAdapter mouseAdapter) {
        BGUTable productsTable = new BGUTable((TableModel)((Object)this.productsTableModel));
        productsTable.addMouseListener((MouseListener)mouseAdapter);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((java.awt.Component)new JScrollPane((java.awt.Component)productsTable), "Center");
        return panel;
    }

    private JPanel getProductItemsPanel(MouseAdapter mouseAdapter) {
        BGUTable productItemsTable = new BGUTable((TableModel)((Object)this.componentsTableModel));
        productItemsTable.addMouseListener((MouseListener)mouseAdapter);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((java.awt.Component)new JScrollPane((java.awt.Component)productItemsTable), "Center");
        return panel;
    }

    private JPanel getLinksPanel() {
        this.selectList.setBorder((Border)this.selectComponentListBorder);
        this.availableList.setBorder((Border)this.availableComponentListBorder);
        BGButton addButton = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435");
        addButton.addActionListener(e -> this.setListItemsSelected(true));
        BGButton delButton = new BGButton("\u0423\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445");
        delButton.addActionListener(e -> this.setListItemsSelected(false));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((java.awt.Component)addButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((java.awt.Component)delButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(500, 300);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((java.awt.Component)this.selectList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((java.awt.Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((java.awt.Component)this.availableList, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setLists() {
        this.selectList.getListModel().clear();
        this.availableList.getListModel().clear();
        try {
            Component component;
            JSONArray links = null;
            if (this.tabbedPane.getSelectedIndex() == 0) {
                Element rowElement = (Element)this.productsTableModel.getSelectedRow();
                if (rowElement != null) {
                    links = new JSONArray(this.getLicenseService().getProductLinks(Utils.parseInt((String)rowElement.getAttribute("id"))));
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1 && (component = (Component)this.componentsTableModel.getSelectedRow()) != null) {
                links = new JSONArray(this.getLicenseService().getProductItemLinks(component.getId()));
            }
            if (links != null) {
                ArrayList<IdTitle> selList = new ArrayList<IdTitle>();
                ArrayList avaList = new ArrayList();
                int len = links.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject itemJson = links.getJSONObject(index);
                    IdTitle item = new IdTitle(itemJson.getInt("id"), itemJson.getString("title"));
                    (itemJson.getBoolean("select") ? selList : avaList).add(item);
                }
                ClientUtils.buildList((JList)this.selectList.getList(), selList);
                ClientUtils.buildList((JList)this.availableList.getList(), avaList);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setListItemsSelected(boolean select) {
        String selectIds;
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        if (select) {
            request.setAction("ProductItemLinkToProduct");
            selectIds = this.availableList.getListValues();
        } else {
            request.setAction("ProductItemUnlinkFromProduct");
            selectIds = this.selectList.getListValues();
        }
        request.setAttribute("ids", selectIds);
        try {
            if (Utils.notBlankString((String)selectIds)) {
                Component component;
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    Element rowElement = (Element)this.productsTableModel.getSelectedRow();
                    if (rowElement != null) {
                        request.setAttribute("product_id", rowElement.getAttribute("id"));
                    }
                } else if (this.tabbedPane.getSelectedIndex() == 1 && (component = (Component)this.componentsTableModel.getSelectedRow()) != null) {
                    request.setAttribute("product_item_id", component.getId());
                }
                ClientUtils.checkStatus((Document)this.getDocument(request));
                this.setLists();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void deleteItem() {
        Component component;
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        Request delRequest = new Request();
        delRequest.setModule(this.module);
        delRequest.setModuleId(this.getModuleId());
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Element row = (Element)this.productsTableModel.getSelectedRow();
            if (row != null) {
                String id = row.getAttribute("id");
                request.setAction("CheckProductUsing");
                request.setAttribute("product_id", id);
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element tableRow = XMLUtils.selectElement((Node)doc, (String)"/data/table/data/row");
                    if (tableRow.getAttribute("inUse").equals("true")) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
                    } else if (tableRow.getAttribute("inUse").equals("false") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0432\u0441\u0435\u0445 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0432 \u043d\u0435\u0433\u043e \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u0445?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", 0) == 0) {
                        delRequest.setAction("DeleteProduct");
                        delRequest.setAttribute("id", id);
                        doc = this.getDocument(delRequest);
                        if (ClientUtils.checkStatus((Document)doc)) {
                            this.setData();
                        }
                    }
                }
            }
        } else if (this.tabbedPane.getSelectedIndex() == 1 && (component = (Component)this.componentsTableModel.getSelectedRow()) != null) {
            int id = component.getId();
            request.setAction("CheckProductItemUsing");
            request.setAttribute("product_item_id", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element tableRow = XMLUtils.selectElement((Node)doc, (String)"/data/table/data/row");
                if (tableRow.getAttribute("inUse").equals("true")) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
                } else if (tableRow.getAttribute("inUse").equals("false") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0438\u0437 \u0432\u0441\u0435\u0445 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430", 0) == 0) {
                    delRequest.setAction("DeleteProductItem");
                    delRequest.setAttribute("id", id);
                    doc = this.getDocument(delRequest);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        this.setData();
                    }
                }
            }
        }
    }

    public void newItem() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            new ProductEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", new Product()).open();
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            new ProductItemEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442", new Component()).open();
        }
    }

    public void editItem() {
        Component component;
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Element row = (Element)this.productsTableModel.getSelectedRow();
            if (row != null) {
                String id = row.getAttribute("id");
                request.setAction("GetProduct");
                request.setAttribute("id", id);
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Product product = (Product)JAXBUtils.unmarshal((Node)doc, (String)"/data/product", Product.class);
                    new ProductEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", product).open();
                }
            }
        } else if (this.tabbedPane.getSelectedIndex() == 1 && (component = (Component)this.componentsTableModel.getSelectedRow()) != null) {
            int id = component.getId();
            request.setAction("GetProductItem");
            request.setAttribute("id", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                component = (Component)JAXBUtils.unmarshal((Node)doc, (String)"/data/component", Component.class);
                new ProductItemEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442", component).open();
            }
        }
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        if (this.tabbedPane.getSelectedIndex() == 0) {
            request.setAction("GetProducts");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ArrayList<Element> rowData = new ArrayList<Element>();
                for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"//data/table/data/row")) {
                    rowData.add(rowElement);
                }
                this.productsTableModel.setData(rowData);
            }
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            try {
                this.componentsTableModel.setData(this.getLicenseService().getProductItems());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.setLists();
    }

    private LicenseService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = (LicenseService)this.getContext().getPort(LicenseService.class);
        }
        return this.licenseService;
    }

    class ProductsTableModel
    extends BGTableModel<Element> {
        public ProductsTableModel() {
            super(ProductsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0435\u0440\u0441\u0438\u044f", 100, 100, 100, "version", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class ComponentsTableModel
    extends BGTableModel<Component> {
        private static final String COLUMN_CATEGORY = "category";
        private static final String COLUMN_HIDDEN = "hidden";
        private static final String COLUMN_UNLIMITED = "unlimited";
        private static final String COLUMN_AVAILABLE_ON_WEB = "availableOnWeb";

        public ComponentsTableModel() {
            super(ComponentsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", 100, -1, -1, COLUMN_CATEGORY, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0435\u043e\u0433\u0440.", Boolean.class, 70, 70, 70, COLUMN_UNLIMITED, true);
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", Boolean.class, 70, 70, 70, COLUMN_HIDDEN, true);
            this.addColumn("\u041b\u041a", Boolean.class, 70, 70, 70, COLUMN_AVAILABLE_ON_WEB, true);
        }

        public Object getValue(Component val, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "hidden": {
                    return val.getType() == 1;
                }
                case "category": {
                    return val.getCategory().getTitle().toLowerCase();
                }
                case "unlimited": {
                    return val.getUnlimited() == 1;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class ProductEditor
    extends BGEditorDialog<Product> {
        private BGTextField title;
        private BGTextField version;

        public ProductEditor(String title, Product data) {
            super(title, (Object)data);
            this.title = new BGTextField(30);
            this.version = new BGTextField(5);
        }

        public void doDialogPanel() {
            this.panel.add((java.awt.Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((java.awt.Component)new JLabel("\u0412\u0435\u0440\u0441\u0438\u044f:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.version, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.title.setText(((Product)this.data).getTitle());
            this.version.setText(((Product)this.data).getVersion());
        }

        public boolean doApply() throws Exception {
            Request request = new Request();
            request.setModule(ServiceConfigProducts.this.module);
            request.setModuleId(ServiceConfigProducts.this.getModuleId());
            request.setAction("UpdateProduct");
            request.setAttribute("id", ((Product)this.data).getId());
            request.setAttribute("title", this.title.getText());
            request.setAttribute("version", this.version.getText());
            Document doc = ServiceConfigProducts.this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ServiceConfigProducts.this.setData();
                return true;
            }
            return false;
        }
    }

    class ProductItemEditor
    extends BGEditorDialog<Component> {
        private BGTextField title;
        private BGTextField name;
        private BGTextField comment;
        private BGUComboBox<IdTitle> category;
        private JCheckBox hidden;
        private JCheckBox unlimited;
        private JCheckBox availableOnWeb;

        public ProductItemEditor(String title, Component data) {
            super(title, (Object)data);
            this.title = new BGTextField();
            this.name = new BGTextField();
            this.comment = new BGTextField();
            this.category = new BGUComboBox();
            this.hidden = new JCheckBox("\u0441\u043a\u0440\u044b\u0442\u044b\u0439");
            this.unlimited = new JCheckBox("\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d");
            this.availableOnWeb = new JCheckBox("\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0432 \u041b\u041a");
        }

        public void doDialogPanel() {
            this.panel.add((java.awt.Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.name, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.category, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((java.awt.Component)this.getFlagPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
            ArrayList categoryItems = new ArrayList();
            Stream.of(ComponentCategory.values()).forEach(a -> categoryItems.add(new IdTitle(a.getCode(), a.getTitle())));
            this.category.setData(categoryItems);
            this.name.setEnabled(((Component)this.data).getId() < 1);
            this.name.setText(((Component)this.data).getName());
            this.title.setText(((Component)this.data).getTitle());
            this.comment.setText(((Component)this.data).getComment());
            this.hidden.setSelected(((Component)this.data).getType() == 1);
            this.unlimited.setSelected(((Component)this.data).getUnlimited() == 1);
            this.availableOnWeb.setSelected(((Component)this.data).isAvailableOnWeb());
            this.category.setSelectedItem(categoryItems.stream().filter(a -> a.getId() == ((Component)this.data).getCategory().getCode()).findFirst());
        }

        public boolean doApply() throws Exception {
            Component productItem;
            Request request = new Request();
            request.setModule(ServiceConfigProducts.this.module);
            request.setModuleId(ServiceConfigProducts.this.getModuleId());
            request.setAction("GetProductItemByName");
            request.setAttribute("name", this.name.getText());
            Document doc = ServiceConfigProducts.this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc) && (productItem = (Component)JAXBUtils.unmarshal((Node)doc, (String)"/data/component", Component.class)).getId() > 0 && productItem.getId() != ((Component)this.data).getId()) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c.");
                return false;
            }
            request.setModule(ServiceConfigProducts.this.module);
            request.setModuleId(ServiceConfigProducts.this.getModuleId());
            request.setAction("UpdateProductItem");
            request.setAttribute("id", ((Component)this.data).getId());
            request.setAttribute("title", this.title.getText());
            request.setAttribute("name", this.name.getText());
            request.setAttribute("comment", this.comment.getText());
            request.setAttribute("type", this.hidden.isSelected());
            request.setAttribute("unlimited", this.unlimited.isSelected());
            request.setAttribute("availableOnWeb", this.availableOnWeb.isSelected());
            request.setAttribute("category", ((IdTitle)this.category.getSelectedItem()).getId());
            doc = ServiceConfigProducts.this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ServiceConfigProducts.this.setData();
                return true;
            }
            return false;
        }

        private JPanel getFlagPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((java.awt.Component)this.unlimited, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((java.awt.Component)this.hidden, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 5), 0, 0));
            panel.add((java.awt.Component)this.availableOnWeb, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 5), 0, 0));
            return panel;
        }
    }
}

