/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.client.ViewMode;
import ru.bitel.bgbilling.modules.license.client.contract.AdditionalAgreementPanel;
import ru.bitel.bgbilling.modules.license.client.contract.ComponentsPanel;
import ru.bitel.bgbilling.modules.license.client.contract.ContractProductCopiesPanel;
import ru.bitel.bgbilling.modules.license.client.contract.LicensesPanel;
import ru.bitel.bgbilling.modules.license.client.contract.OrdersPanel;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.client.BGUComboBox;

public class ServicePropertiesPanel
extends ServicePanel {
    private JLabel productsLabel = new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:");
    private BGUComboBox<Copy> contractProducts = new BGUComboBox(true);
    private BGButton editProductsButton = new BGButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a");
    private ViewMode mode = ViewMode.ProductCopySettings;
    private CardLayout cardLayout = new CardLayout();
    private JPanel panel = new JPanel(this.cardLayout);
    private BGTabbedPane tabbedPane = new BGTabbedPane();
    private ComponentsPanel copyItemsPanel = new ComponentsPanel(this);
    private LicensesPanel packagesPanel = new LicensesPanel();
    private OrdersPanel ordersPanel = new OrdersPanel();
    private AdditionalAgreementPanel additionalAgreementPanel = new AdditionalAgreementPanel();
    private ContractProductCopiesPanel copiesPanel = new ContractProductCopiesPanel();
    private static Logger log = LogManager.getLogger();

    public ServicePropertiesPanel() {
        try {
            this.copiesPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
            this.jbInit();
        }
        catch (Exception e) {
            log.error("ServicePropertiesPanel", (Throwable)e);
        }
    }

    public void jbInit() {
        this.setLayout(new GridBagLayout());
        this.tabbedPane.add("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", (Component)((Object)this.copyItemsPanel));
        this.tabbedPane.add("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", (Component)((Object)this.packagesPanel));
        this.tabbedPane.add("\u0417\u0430\u043a\u0430\u0437\u044b", (Component)((Object)this.ordersPanel));
        this.tabbedPane.add("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b", (Component)((Object)this.additionalAgreementPanel));
        this.panel.add((Component)this.tabbedPane, "tabs");
        this.panel.add((Component)((Object)this.copiesPanel), "copies");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServicePropertiesPanel.this.setData();
            }
        });
        this.editProductsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ServicePropertiesPanel.this.mode == ViewMode.ProductCopySettings) {
                    ServicePropertiesPanel.this.changeMode(ViewMode.ProductCopies);
                } else if (ServicePropertiesPanel.this.mode == ViewMode.ProductCopies) {
                    ServicePropertiesPanel.this.changeMode(ViewMode.ProductCopySettings);
                }
            }
        });
        this.contractProducts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ServicePropertiesPanel.this.contractProducts.getItemCount() > 0) {
                    ServicePropertiesPanel.this.setData();
                }
            }
        });
        this.add(this.productsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.contractProducts, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editProductsButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.panel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void changeMode(ViewMode newMode) {
        this.mode = newMode;
        if (newMode == ViewMode.ProductCopySettings) {
            this.setComboBoxData();
            this.cardLayout.show(this.panel, "tabs");
            this.contractProducts.setEnabled(true);
            this.editProductsButton.setText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a");
        } else if (newMode == ViewMode.ProductCopies) {
            this.cardLayout.show(this.panel, "copies");
            this.contractProducts.setEnabled(false);
            this.editProductsButton.setText("\u041d\u0430\u0437\u0430\u0434");
        }
        this.setData();
    }

    public void newItem() {
        if (this.mode == ViewMode.ProductCopies) {
            this.copiesPanel.newItem();
        } else {
            int copyId = ((Copy)this.contractProducts.getSelectedItem()).getId();
            if (copyId > 0) {
                if (this.tabbedPane.getSelectedIndex() == 2) {
                    this.ordersPanel.setCopyId(copyId);
                    this.ordersPanel.newItem.perform();
                } else if (this.tabbedPane.getSelectedIndex() == 3) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0413\u0435\u043d\u0438\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430(\u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f) \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0438\u0436\u0435.");
                }
            }
        }
    }

    public void editItem() {
        if (this.mode == ViewMode.ProductCopies) {
            this.copiesPanel.editItem();
        } else {
            int copyId = ((Copy)this.contractProducts.getSelectedItem()).getId();
            if (copyId > 0 && this.tabbedPane.getSelectedIndex() != 2 && this.tabbedPane.getSelectedIndex() == 3) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430(\u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f) \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
            }
        }
    }

    public void deleteItem() {
        if (this.mode == ViewMode.ProductCopies) {
            this.copiesPanel.deleteItem();
        } else if (this.tabbedPane.getSelectedIndex() == 0) {
            this.copyItemsPanel.deleteItem();
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            this.packagesPanel.deleteItem();
        } else if (this.tabbedPane.getSelectedIndex() == 2) {
            this.ordersPanel.deleteItem.perform();
        } else if (this.tabbedPane.getSelectedIndex() == 3) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430(\u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f) \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0438\u0436\u0435.");
        }
    }

    public void setData() {
        if (this.contractProducts.getItemCount() == 0) {
            this.setComboBoxData();
        }
        if (this.mode == ViewMode.ProductCopies) {
            this.copiesPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
            this.copiesPanel.setData();
        } else if (this.mode == ViewMode.ProductCopySettings) {
            if (this.contractProducts.getSelectedItem() == null) {
                return;
            }
            int copyId = ((Copy)this.contractProducts.getSelectedItem()).getId();
            if (copyId > 0) {
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    this.copyItemsPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
                    this.copyItemsPanel.setCopyId(copyId);
                    this.copyItemsPanel.setData();
                } else if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.packagesPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
                    this.packagesPanel.setCopyId(copyId);
                    this.packagesPanel.setData();
                } else if (this.tabbedPane.getSelectedIndex() == 2) {
                    this.ordersPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
                    this.ordersPanel.setCopyId(copyId);
                    this.ordersPanel.refresh.perform();
                } else if (this.tabbedPane.getSelectedIndex() == 3) {
                    this.additionalAgreementPanel.setCopyId(copyId);
                    this.additionalAgreementPanel.setModuleData(this.module, this.getModuleId(), this.getContractId());
                    this.additionalAgreementPanel.performAction("refresh");
                }
            }
        }
    }

    public void switchToPackagePane(int newPackageId) {
        this.tabbedPane.setSelectedIndex(1);
        this.packagesPanel.setNewPackageSelected(newPackageId);
    }

    private void setComboBoxData() {
        try {
            this.contractProducts.setData(((LicenseService)this.getContext().getPort(LicenseService.class)).copyList(this.getContractId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

