/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import bitel.billing.server.contract.bean.ContractUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionComponents;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.mail.MailGenerateLicense;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionGenerateLicense
extends ActionComponents {
    @Override
    public void doAction() throws BGException {
        int selectedCopyId = this.req.getInt("copy", -1);
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        String selectedItemIds = this.getSelectedItemIds();
        if (!Utils.isBlankString((String)selectedItemIds)) {
            int[] ids = this.convertToIntArray(selectedItemIds);
            if (!this.checkComponentsConcurrence()) {
                this.setResultParam("error", "\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b.");
            } else if (!this.checkComponentsOrderStatus(ids, licenseManager)) {
                this.setResultParam("error", "\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0445 \u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.");
            } else {
                String receiverEmail;
                this.createLicense(ids, selectedCopyId, licenseManager);
                if ("true".equals(this.moduleSetup.get("license.create.email.send", "false")) && Utils.notBlankString((String)(receiverEmail = this.moduleSetup.get("license.bills.email.to", "")))) {
                    ContractUtils cu = new ContractUtils(this.con);
                    try {
                        MailGenerateLicense mailData = new MailGenerateLicense();
                        mailData.setModuleId(this.moduleId);
                        mailData.setRecipients(receiverEmail);
                        mailData.setSubject("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
                        mailData.addTextPart("text", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(this.contractId, false) + " \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.");
                        new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
                    }
                    catch (Exception ex) {
                        LogManager.getLogger().error((Object)ex);
                    }
                }
                this.setResultParam("licenseCreatedMessage", "\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u0414\u043b\u044f \u0435\u0435 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u0440\u0430\u0437\u0434\u0435\u043b \"\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f\".");
            }
        } else {
            this.setResultParam("error", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u044b \u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.");
        }
        super.doAction();
        this.setResultParam("action", "Components");
    }

    private String getSelectedItemIds() {
        StringBuilder selectedIdsBuilder = new StringBuilder();
        int itemsCount = this.req.getInt("itemsCount", -1);
        for (int i = 1; i <= itemsCount; ++i) {
            String itemIds = this.req.get("chbx_" + i, "");
            if (!Utils.notEmptyString((String)itemIds)) continue;
            if (selectedIdsBuilder.length() > 0) {
                selectedIdsBuilder.append(",");
            }
            selectedIdsBuilder.append(itemIds);
        }
        return selectedIdsBuilder.toString();
    }

    private boolean checkComponentsConcurrence() {
        int itemsCount = this.req.getInt("itemsCount", -1);
        ArrayList<String> productItemIds = new ArrayList<String>();
        boolean checkResult = true;
        for (int i = 1; i <= itemsCount; ++i) {
            String checkBoxValue = this.req.get("chbx_" + i, "");
            String productItemId = this.req.get("product_item_id_" + i, "");
            if (!Utils.notEmptyString((String)checkBoxValue) || !Utils.notEmptyString((String)productItemId)) continue;
            if (productItemIds.contains(productItemId)) {
                checkResult = false;
            }
            productItemIds.add(productItemId);
        }
        return checkResult;
    }

    private boolean checkComponentsOrderStatus(int[] copyItemIds, LicenseManager licenseManager) {
        boolean checkStatus = true;
        for (int id : copyItemIds) {
            if (licenseManager.checkCopyItemStatus(id)) continue;
            checkStatus = false;
        }
        return checkStatus;
    }

    private int[] convertToIntArray(String s) {
        List selectedIds = Utils.toList((String)s);
        int[] array = new int[selectedIds.size()];
        int i = 0;
        for (String id : selectedIds) {
            int copyItemId = Utils.parseInt((String)id, (int)-1);
            if (copyItemId <= 0) continue;
            array[i++] = copyItemId;
        }
        return array;
    }

    private int createLicense(int[] componentIds, int copyId, LicenseManager licenseManager) throws BGException {
        License p = new License();
        p.setCopyId(copyId);
        p.setUserId(0);
        p.setCopyItemIds(componentIds);
        p.setData("");
        p.setOriginalData("");
        int licenseId = licenseManager.createLicense(p);
        Copy copy = licenseManager.getCopy(copyId);
        List<ConfirmedOrder> licenseItems = licenseManager.getLicenseItems(p.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, licenseManager, this.contractId, (Preferences)this.moduleSetup, copy);
        p.setOriginalData(licText);
        try {
            p.setData(LicenseUtils.encryptLicenseText(licText, (Preferences)this.moduleSetup));
        }
        catch (IOException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        licenseManager.updateLicenseData(p);
        return licenseId;
    }
}

