/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import ru.bitel.bgbilling.modules.ipn.server.DlinkGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Profile;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Rule;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class EthernetProfile
extends Profile {
    private String OID;
    private String OID_FILTER_TYPE;
    public static final int FILTER_TYPE_OTHER = 1;
    public static final int FILTER_TYPE_SRC_MAC = 3;
    private String OID_SRC_MASK;
    private String OID_DST_MASK;
    private String OID_ETHERNET_TYPE;
    public static final int ETHERNET_TYPE_ENABLE = 1;
    public static final int ETHERNET_TYPE_DISABLE = 2;
    private String OID_MANAGE;
    public static final int MANAGE_DELETE = 6;
    public static final int MANAGE_CREATE = 4;
    public static final String ZERO_MAC_MASK = "00 00 00 00 00 00";
    private int filterType;
    private String srcMask;
    private String dstMask;
    private int useTypeFiler;

    public static final String getOid(int model) {
        String OID = null;
        switch (model) {
            case 1: {
                OID = "1.3.6.1.4.1.171.12.9.1.1.1";
                break;
            }
            case 2: {
                OID = "1.3.6.1.4.1.171.12.9.2.1.1";
            }
        }
        return OID;
    }

    public EthernetProfile(int model) {
        this.OID = EthernetProfile.getOid(model);
        this.OID_FILTER_TYPE = this.OID + ".3";
        this.OID_SRC_MASK = this.OID + ".4";
        this.OID_DST_MASK = this.OID + ".5";
        this.OID_ETHERNET_TYPE = this.OID + ".7";
        this.OID_MANAGE = this.OID + ".8";
    }

    public EthernetProfile(int model, int id, int filterType, String srcMask, String dstMask, int typeFilter) {
        this(model);
        this.id = id;
        this.filterType = filterType;
        this.srcMask = srcMask;
        this.dstMask = dstMask;
        this.useTypeFiler = typeFilter;
    }

    public String getDstMask() {
        return this.dstMask;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public String getSrcMask() {
        return this.srcMask;
    }

    public int getUseTypeFiler() {
        return this.useTypeFiler;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof EthernetProfile;
        if (result) {
            EthernetProfile cmp = (EthernetProfile)obj;
            result = result && cmp.getSrcMask().equals(this.srcMask);
            result = result && cmp.getDstMask().equals(this.dstMask);
            result = result && cmp.getUseTypeFiler() == this.useTypeFiler;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EthernetProfile src_mask: ");
        result.append(this.srcMask);
        result.append("; dst_mask: ");
        result.append(this.dstMask);
        result.append("; type_filter: ");
        result.append(this.useTypeFiler);
        result.append("\nRules:\n");
        for (Rule rule : this.getRuleMap().values()) {
            result.append(rule.toString());
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        if (oid.startsWith(this.OID_SRC_MASK)) {
            this.srcMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_DST_MASK)) {
            this.dstMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_ETHERNET_TYPE)) {
            this.useTypeFiler = this.getInt(var);
        }
    }

    @Override
    public void create(DlinkGateWorker gateWorker) throws Exception {
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        String oid = null;
        oid = this.OID_FILTER_TYPE + "." + this.id;
        pairs.add(new Object[]{oid, new AsnInteger(this.filterType)});
        if (this.filterType != 1) {
            oid = this.OID_SRC_MASK + "." + this.id;
            pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.srcMask))});
        }
        oid = this.OID_ETHERNET_TYPE + "." + this.id;
        pairs.add(new Object[]{oid, new AsnInteger(this.useTypeFiler)});
        oid = this.OID_MANAGE + "." + this.id;
        pairs.add(new Object[]{oid, new AsnInteger(4)});
        gateWorker.sendSetPdu(pairs);
    }

    @Override
    public void delete(DlinkGateWorker gateWorker) throws Exception {
        String oid = this.OID_MANAGE + "." + this.id;
        gateWorker.sendSetPdu(oid, (AsnObject)new AsnInteger(6));
    }
}

