/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.collector;

import bitel.billing.server.load.bean.Source;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowRecord;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorkerContext;
import ru.bitel.common.model.Idable;
import ru.bitel.common.worker.WorkerTask;

class FlowListenerWorker
extends WorkerTask<FlowListenerWorkerContext> {
    private static final Logger log = LogManager.getLogger();
    protected final List<FlowPacket> packetList;

    public FlowListenerWorker(List<FlowPacket> packetList) {
        this.packetList = packetList;
    }

    protected void runImpl() {
        int size = this.packetList.size();
        for (int i = 0; i < size; ++i) {
            FlowPacket packet = this.packetList.get(i);
            byte[] address = ((InetSocketAddress)packet.address).getAddress().getAddress();
            long hostAddress = address[3] & 0xFF;
            hostAddress |= (long)(address[2] << 8 & 0xFF00);
            hostAddress |= (long)(address[1] << 16 & 0xFF0000);
            hostAddress |= (long)(address[0] << 24 & 0xFF000000);
            Source source = ((FlowListenerWorkerContext)this.context).ss.getAddressSource(hostAddress &= 0xFFFFFFFFL);
            if (source != null) {
                this.process(source, packet);
                continue;
            }
            log.debug("Source not found for " + IPUtils.convertLongIpToString((long)hostAddress));
        }
    }

    protected void process(Source source, FlowPacket packet) {
        long currentHour;
        long now = System.currentTimeMillis();
        switch (source.getType()) {
            case 3: {
                NetFlowArray netFlowArray = ((FlowListenerWorkerContext)this.context).netFlowArray;
                if (!netFlowArray.parsePacket(packet.data, now)) {
                    return;
                }
                if (((FlowListenerWorkerContext)this.context).realtime) {
                    NetFlowRecord rec = ((NetFlowRecord[])netFlowArray.array)[0];
                    long millis = rec.getMilliseconds();
                    currentHour = millis / 3600000L * 3600000L;
                    break;
                }
                currentHour = now / 3600000L * 3600000L;
                break;
            }
            case 4: {
                SFlowArray sFlowArray = ((FlowListenerWorkerContext)this.context).sFlowArray;
                if (!sFlowArray.parsePacket(packet.data, now)) {
                    return;
                }
                currentHour = now / 3600000L * 3600000L;
                break;
            }
            default: {
                log.error("Error source type " + source.getType() + " for source " + source.getId());
                return;
            }
        }
        if (currentHour != ((FlowListenerWorkerContext)this.context).hour) {
            ((FlowListenerWorkerContext)this.context).hourEntryMap = ((FlowListenerWorkerContext)this.context).dataLogger.getForHourPart(Long.valueOf(currentHour));
            ((FlowListenerWorkerContext)this.context).hour = currentHour;
        }
        IPDataLogWriter writer = (IPDataLogWriter)((FlowListenerWorkerContext)this.context).dataLogger.getWriter(((FlowListenerWorkerContext)this.context).hourEntryMap, ((FlowListenerWorkerContext)this.context).writerMap, currentHour, (Idable)source);
        try {
            writer.writeRecord(packet.data, now);
        }
        catch (Exception e) {
            log.error("IOException", (Throwable)e);
        }
    }
}

