/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.common.TimeUtils;

@ActionConType(value=2)
public class ActionGetAddressesList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Date dateFrom;
        Date dateTo;
        int year = this.getIntParameter("year", 0);
        int month = this.getIntParameter("month", 0);
        int day = this.getIntParameter("day", 0);
        if (year == 0) {
            dateTo = null;
            dateFrom = null;
        } else if (month == 0) {
            dateFrom = TimeUtils.convertStringToDate((String)("01.01." + year));
            dateTo = TimeUtils.convertStringToDate((String)("31.12." + year));
        } else if (day == 0) {
            dateFrom = TimeUtils.convertStringToDate((String)("01." + month + "." + year));
            dateTo = TimeUtils.getEndMonth((Date)dateFrom);
        } else {
            dateFrom = dateTo = TimeUtils.convertStringToDate((String)(day + "." + month + "." + year));
        }
        Element listAddr = this.createElement(this.rootNode, "listAddress");
        AddressRangeManager man = new AddressRangeManager(this.con, this.mid);
        for (AddressRange ar : man.getContractAddressRange(this.cid, dateFrom, dateTo)) {
            Element adrEl = this.addListItem(listAddr, ar.getId(), ar.toString(man.getSourceIface(ar)));
            StringBuilder sb = new StringBuilder();
            sb.append(IPUtils.convertLongIpToString((long)ar.getAddr1()));
            if (ar.getAddr1() != ar.getAddr2()) {
                sb.append("-");
                sb.append(IPUtils.convertLongIpToString((long)ar.getAddr2()));
            }
            adrEl.setAttribute("ip", sb.toString());
        }
        Element fileTemplateEl = this.createElement(this.rootNode, "file_template");
        fileTemplateEl.setAttribute("file_template", this.moduleSetup.get("file.detail.template", ""));
        ContractUtils cu = new ContractUtils(this.con);
        fileTemplateEl.setAttribute("contract_title", cu.getContractTitle(this.cid, false, ""));
        User user = (User)new UserManager(this.con).get(this.userId.intValue());
        fileTemplateEl.setAttribute("user_name", user != null ? user.getLogin() : "");
    }
}

