/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class SourceSelector
extends Thread {
    private Calendar lastTime = new GregorianCalendar();
    private Logger logger = LogManager.getLogger((String)"collector");
    private NetFlowSetup setup;
    private volatile Map<Long, Source> addressSourceMap;
    private volatile List<Source> sourceList;
    private String sources;
    private final int[] types;

    public SourceSelector(NetFlowSetup setup, String sources, int ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setup = setup;
        this.types = types;
        this.sources = sources;
        this.loadSources();
    }

    public Map<Long, Source> getAddressSourceMap() {
        return this.addressSourceMap;
    }

    public Source getAddressSource(Long address) {
        return this.addressSourceMap.get(address);
    }

    public List<Source> getSourceList() {
        return this.sourceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSources() {
        this.logger.info("Reload source list [types: " + Utils.toString(Arrays.asList(new int[][]{this.types})) + "; sourceIds: " + this.sources + "]");
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            HashMap<Long, Source> resultMap = new HashMap<Long, Source>();
            ArrayList<Source> resultList = new ArrayList<Source>();
            SourceManager sm = new SourceManager(con);
            GregorianCalendar now = new GregorianCalendar();
            for (int type : this.types) {
                List sourceList = sm.getSourceList(this.setup.getModuleId(), type, (Calendar)now, this.sources);
                this.putAll(resultMap, resultList, sourceList);
            }
            this.addressSourceMap = resultMap;
            this.sourceList = resultList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void putAll(Map<Long, Source> resultMap, List<Source> resultList, List<Source> sourceList) {
        for (Source source : sourceList) {
            long ip = IPUtils.convertStringIPtoLong((String)source.getHostOrDir(), (long)0L);
            if (ip >= 0L) {
                this.logger.info("IP: " + source.getHostOrDir() + " => " + source.getId());
                resultMap.put(ip, source);
                resultList.add(source);
                continue;
            }
            this.logger.error("Wrong ip:" + source.getHostOrDir());
        }
    }

    @Override
    public void run() {
        GregorianCalendar now = null;
        while (true) {
            if ((now = new GregorianCalendar()).get(6) != this.lastTime.get(6)) {
                this.loadSources();
            }
            this.lastTime = now;
            try {
                SourceSelector.sleep(60000L);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

