/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;

public class RangeIfacePanel
extends BGPanel {
    private boolean showDate = true;
    private CheckTree tree;
    private ModTreeNode rootNode;
    private BGControlPanelDateNoB sourceDate = new BGControlPanelDateNoB();

    public RangeIfacePanel() {
        this(true);
    }

    public RangeIfacePanel(boolean showDate) {
        this.rootNode = new ModTreeNode();
        this.rootNode.setAttribute("id", (Object)"0");
        this.rootNode.setAttribute("type", (Object)"1");
        this.rootNode.setText("\u0412\u0441\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438");
        this.rootNode.setIcon("closed");
        this.tree = new CheckTree(this.rootNode);
        this.sourceDate.setLocalDate(LocalDate.now());
        this.showDate = showDate;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        if (this.showDate) {
            this.add(new JLabel("\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u043d\u0430 \u0434\u0430\u0442\u0443: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.sourceDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        JScrollPane treeScroll = new JScrollPane();
        treeScroll.setViewportView((Component)this.tree);
        this.add(treeScroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.sourceDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ifaces = RangeIfacePanel.this.tree.getCodes();
                RangeIfacePanel.this.setData();
                RangeIfacePanel.this.tree.setCodes(ifaces);
                RangeIfacePanel.this.tree.updateUI();
            }
        });
    }

    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("IfaceTree");
        req.setModuleId(this.getModuleId());
        req.setAttribute("date", this.showDate ? this.sourceDate.getDateString() : TimeUtils.formatDate((Date)new Date()));
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.buildTree(doc);
        }
        this.tree.expandPath(new TreePath(this.rootNode.getPath()));
    }

    private void buildTree(Document doc) {
        this.rootNode.removeAllChildren();
        NodeList sourceList = doc.getElementsByTagName("source");
        int size = sourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Element source = (Element)sourceList.item(i);
            String id = source.getAttribute("id");
            String title = source.getAttribute("title");
            ModTreeNode sourceNode = new ModTreeNode();
            sourceNode.setAttribute("id", (Object)"0");
            sourceNode.setText(title);
            sourceNode.setIcon("closed");
            this.rootNode.add((MutableTreeNode)sourceNode);
            NodeList ifaceList = source.getElementsByTagName("iface");
            int ifaceSize = ifaceList.getLength();
            for (int j = 0; j < ifaceSize; ++j) {
                Element iface = (Element)ifaceList.item(j);
                ModTreeNode ifaceNode = new ModTreeNode();
                ifaceNode.setAttribute("id", (Object)(id + "_" + iface.getAttribute("id")));
                ifaceNode.setText(iface.getAttribute("title"));
                ifaceNode.setIcon("leaf");
                sourceNode.add((MutableTreeNode)ifaceNode);
            }
        }
    }

    public void setIfaces(String ifaces) {
        this.tree.setCodes(ifaces);
    }

    public String getIfaces() {
        return this.tree.getCodes();
    }
}

