/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import javax.swing.Icon;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class GateTreeTableNode
extends TreeNode<GateTreeTableNode> {
    protected static final Icon folderIcon = ClientUtils.getIcon((String)"folder2");
    protected static final Icon serverIcon = ClientUtils.getIcon((String)"server");
    protected static final Icon leafIcon = ClientUtils.getIcon((String)"server_connect");
    private String host;
    private String port;
    private String comment;
    private int typeId;
    private String type;
    private String typeName;
    private boolean isUsed = false;
    private String address = "";

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public Object getValueAt(int column) {
        Object value = null;
        switch (column) {
            case 0: {
                if (this.typeId != 0) {
                    value = String.valueOf(this.host) + ":" + String.valueOf(this.port);
                    break;
                }
                value = String.valueOf(this.host);
                break;
            }
            case 1: {
                value = this.type;
                break;
            }
            case 2: {
                value = this.address;
                break;
            }
            case 3: {
                value = this.comment;
            }
        }
        if (value != null && this.isUsed) {
            value = "<html><span style=\"color: #CCCCCC; text-decoration: line-through;\">" + (String)value + "</span></html>";
        }
        return value;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public Icon getIcon() {
        if (this.typeId == 0) {
            return folderIcon;
        }
        if (Utils.isEmptyString((String)this.typeName)) {
            return serverIcon;
        }
        return leafIcon;
    }

    public void removeFromParent() {
        GateTreeTableNode parent = (GateTreeTableNode)this.getParent();
        if (parent != null) {
            int i = parent.removeChild(this);
            if (this.child != null) {
                parent.insertChilds(i, this.child);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreeNode) {
            return this.id == ((TreeNode)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final void setPort(String port) {
        this.port = port;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setIsUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

