/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.edo.common.bean.Document;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class DocumentDao
extends AbstractIdDao<Document> {
    public DocumentDao(Connection con) {
        super(con, 0, "edo_document");
    }

    public List<Document> getListAll() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected Document getFromRS(ResultSet rs) throws SQLException, BGException {
        Document document = new Document();
        document.setId(rs.getInt(this.tableName + ".id"));
        document.setTitle(rs.getString(this.tableName + ".title"));
        document.setClazz(rs.getString(this.tableName + ".class"));
        document.setConfig(rs.getString(this.tableName + ".config"));
        String signatory_ids = rs.getString(this.tableName + ".signatory_ids");
        document.setSignatoryIds(Utils.notBlankString((String)signatory_ids) ? Utils.toIntegerList((String)signatory_ids) : null);
        return document;
    }

    protected void updateImpl(Document b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title, class, config, signatory_ids) VALUES (?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, class=?, config=?, signatory_ids=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getClazz());
        ps.setString(3, b.getConfig());
        if (Utils.notEmptyCollection((Collection)b.getSignatoryIds())) {
            ps.setString(4, Utils.toString((Iterable)b.getSignatoryIds()));
        } else {
            ps.setNull(4, 12);
        }
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }
}

