/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.client.ServiceConfigChannels;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.ChannelService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ChannelEditor
extends BGUPanel {
    private ServiceConfigChannels channelsPanel;
    private ChannelMapping mappingCurrent = null;
    private BGUTable table;
    private BGTableModel<ChannelMapping> model;
    private JTextField titleTF = new BGTextField();
    private JPanel editorPanel = new JPanel();
    private BGTextField channelTF = new BGTextField();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JTextArea commentTA = new JTextArea();
    private BGUComboBox<IdTitle> servers = new BGUComboBox();
    private BGDialogToolBar propertyToolBar = new BGDialogToolBar();
    private int channelId;
    private boolean init = false;

    public ChannelEditor() {
        this.model = new BGTableModel<ChannelMapping>("ChannelMapping"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, 150, 150, -1, "period", false);
                this.addColumn("\u041a\u0430\u043d\u0430\u043b CerberCrypt", 150, 150, -1, "channelCode", false);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false);
                this.addColumn("\u0421\u0435\u0440\u0432\u0435\u0440 CerberCrypt", 150, 150, -1, "serverTitle", false);
            }

            public Object getValue(ChannelMapping val, int column) throws BGException {
                if (column == 1) {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.setLayout(new GridBagLayout());
        this.setSize(600, 300);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.titleTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JButton okButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        topPanel.add((Component)okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.setBorder((Border)new BGTitleBorder(" \u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u0430\u043d\u0430\u043b\u044b CerberCrypt "));
        JScrollPane tableScroll = new JScrollPane();
        tableScroll.setViewportView((Component)this.table);
        tablePanel.add((Component)tableScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(tablePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.setLayout(new GridBagLayout());
        JPanel leftEditorPanel = new JPanel();
        leftEditorPanel.setLayout(new GridBagLayout());
        leftEditorPanel.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        leftEditorPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        leftEditorPanel.add((Component)new JLabel("\u041a\u043e\u0434 \u043a\u0430\u043d\u0430\u043b\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.channelTF.setHorizontalAlignment(0);
        leftEditorPanel.add((Component)this.channelTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        leftEditorPanel.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0435\u0440:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.servers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)leftEditorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel rightEditorPanel = new JPanel();
        rightEditorPanel.setLayout(new GridBagLayout());
        rightEditorPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        JScrollPane commentScroll = new JScrollPane();
        commentScroll.setViewportView(this.commentTA);
        this.commentTA.setWrapStyleWord(true);
        this.commentTA.setLineWrap(true);
        rightEditorPanel.add((Component)commentScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)rightEditorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel yesNoPanel = new BGButtonPanelOkCancel();
        this.editorPanel.add((Component)yesNoPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        yesNoPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("ok")) {
                    ChannelEditor.this.performAction("stopMappingEdit_Save");
                } else {
                    ChannelEditor.this.editorPanel.setVisible(false);
                }
            }
        });
        this.add(this.editorPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelEditor.this.performAction("updateChannel");
            }
        });
        this.buildPropertyToolBar();
        this.add((Component)this.propertyToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        ClientUtils.addOpenAction((Component)this.table, (AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                ChannelEditor.this.mappingCurrent = (ChannelMapping)ChannelEditor.this.model.getSelectedRow();
                if (ChannelEditor.this.mappingCurrent != null) {
                    ChannelEditor.this.performAction("startMappingEdit");
                }
            }
        });
        this.editorPanel.setVisible(false);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ChannelEditor.this.performAction("refresh");
            }
        });
        this.editorPanel.setMinimumSize(new Dimension(100, 200));
        this.editorPanel.setPreferredSize(new Dimension(100, 200));
    }

    protected void jbInit() throws Exception {
    }

    private void buildPropertyToolBar() {
        this.propertyToolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("newItem")) {
                    ChannelEditor.this.mappingCurrent = null;
                    ChannelEditor.this.performAction("startMappingEdit");
                } else if (command.equals("editItem")) {
                    ChannelEditor.this.mappingCurrent = (ChannelMapping)ChannelEditor.this.model.getSelectedRow();
                    if (ChannelEditor.this.mappingCurrent != null) {
                        ChannelEditor.this.performAction("startMappingEdit");
                    }
                } else if (command.equals("deleteItem")) {
                    ChannelEditor.this.mappingCurrent = (ChannelMapping)ChannelEditor.this.model.getSelectedRow();
                    if (ChannelEditor.this.mappingCurrent != null) {
                        ChannelEditor.this.performAction("deleteMapping");
                    }
                } else if (command.equals("refresh")) {
                    ChannelEditor.this.performAction("refresh");
                }
            }
        });
        this.propertyToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "separator", "refresh"});
        this.propertyToolBar.setFloatable(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.titleTF.setText(((ChannelService)((ClientContext)this.getContext()).getPort(ChannelService.class)).getChannel(this.channelId).getTitle());
            if (!this.init) {
                List serversList = ((ChannelService)((ClientContext)this.getContext()).getPort(ChannelService.class)).getServers();
                this.servers.setData(serversList);
                this.init = true;
            }
            this.model.setData(((ChannelService)((ClientContext)this.getContext()).getPort(ChannelService.class)).channelMappingTable(this.channelId));
        });
        new AbstractBGUPanel.DefaultAction("updateChannel", "updateChannel"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isEmptyString((String)ChannelEditor.this.titleTF.getText().trim())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043d\u0430\u043b\u0430!");
                    return;
                }
                Channel channel = new Channel();
                channel.setId(ChannelEditor.this.channelId);
                channel.setTitle(ChannelEditor.this.titleTF.getText());
                ((ChannelService)((ClientContext)ChannelEditor.this.getContext()).getPort(ChannelService.class)).updateChannel(channel);
                ChannelEditor.this.channelsPanel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("startMappingEdit", "startMappingEdit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (ChannelEditor.this.mappingCurrent == null) {
                    ChannelEditor.this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
                    ChannelEditor.this.periodPanel.setDateString2("");
                    ChannelEditor.this.channelTF.setText("0");
                    ChannelEditor.this.commentTA.setText("");
                    ChannelEditor.this.editorPanel.setVisible(true);
                } else {
                    ChannelMapping channelMapping = ((ChannelService)((ClientContext)ChannelEditor.this.getContext()).getPort(ChannelService.class)).getChannelMapping(ChannelEditor.this.mappingCurrent.getId());
                    ChannelEditor.this.periodPanel.setDateFrom(channelMapping.getDateFrom());
                    ChannelEditor.this.periodPanel.setDateTo(channelMapping.getDateTo());
                    ChannelEditor.this.channelTF.setText(channelMapping.getChannelCode());
                    ChannelEditor.this.commentTA.setText(channelMapping.getComment());
                    ChannelEditor.this.servers.setSelectedItem((Object)channelMapping.getServerCode());
                    ChannelEditor.this.editorPanel.setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("stopMappingEdit_Save", "stopMappingEdit_Save"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isEmptyString((String)ChannelEditor.this.channelTF.getText().trim())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u043d\u0430\u043b\u0430!");
                    return;
                }
                if (Utils.isEmptyString((String)ChannelEditor.this.periodPanel.getDateString1())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                    return;
                }
                ChannelMapping cm = new ChannelMapping();
                cm.setId(ChannelEditor.this.mappingCurrent != null ? ChannelEditor.this.mappingCurrent.getId() : 0);
                cm.setChannelId(ChannelEditor.this.channelId);
                cm.setDateFrom(ChannelEditor.this.periodPanel.getDateFrom());
                cm.setDateTo(ChannelEditor.this.periodPanel.getDateTo());
                cm.setChannelCode(ChannelEditor.this.channelTF.getText());
                cm.setComment(ChannelEditor.this.commentTA.getText());
                IdTitle item = (IdTitle)ChannelEditor.this.servers.getSelectedItem();
                if (item != null) {
                    cm.setServerCode(item.getId());
                }
                ((ChannelService)((ClientContext)ChannelEditor.this.getContext()).getPort(ChannelService.class)).updateChannelMapping(cm);
                ChannelEditor.this.editorPanel.setVisible(false);
                ChannelEditor.this.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteMapping", "deleteMapping"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (ChannelEditor.this.mappingCurrent != null && ClientUtils.confirmDelete((Object)"\u0441\u0442\u0440\u043e\u043a\u0443")) {
                    ((ChannelService)((ClientContext)ChannelEditor.this.getContext()).getPort(ChannelService.class)).deleteChannelMapping(ChannelEditor.this.mappingCurrent.getId());
                    ChannelEditor.this.performAction("refresh");
                }
            }
        };
    }

    public void setChannelsPanel(ServiceConfigChannels channelsPanel) {
        this.channelsPanel = channelsPanel;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }
}

