/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.AutoprintProcessor;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.common.TimeUtils;

public class AutoprintDelayed
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
    private int delayPaymentBackDays = -1;
    private long delayPaymentTimeoutMs = 10L;

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 delay-\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439";
    }

    protected boolean initTask() {
        this.delayPaymentBackDays = this.plugin.getSetup().getInt("delay.payment.back.days", this.delayPaymentBackDays);
        this.delayPaymentTimeoutMs = this.plugin.getSetup().getLong("delay.payment.timeout.ms", this.delayPaymentTimeoutMs);
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.processQueue(con, conSlave);
        }
        catch (Exception e) {
            this.getLogger().error("error AutoprintDelayed task", (Throwable)e);
            this.error = e;
        }
    }

    private void processQueue(Connection con, Connection conSlave) throws BGException {
        try (PaymentDao pm = new PaymentDao(con);){
            Date date1 = this.delayPaymentBackDays != -1 ? TimeUtils.nowPlusPeriod((int)5, (int)(-this.delayPaymentBackDays)) : null;
            Date date2 = null;
            List<Payment> queue = CashCheckUtils.getQueue(con, date1, date2, null);
            this.getLogger().info("cashcheck autoprint: print delayed: queue from " + (date1 != null ? TimeUtils.formatDate((Date)date1) : "all") + " to " + (date2 != null ? TimeUtils.formatDate(date2) : "now") + ", size (for all modes): " + queue.size() + "...");
            for (Payment p : queue) {
                ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment bgpayment = (ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment)pm.get(p.getPaymentId());
                AutoprintProcessor.processNewPayment(PrinterManager.PaymentPrintMode.delay, bgpayment, this.setup, con, conSlave);
                try {
                    Thread.sleep(this.delayPaymentTimeoutMs);
                }
                catch (InterruptedException e) {
                    pm.close();
                    return;
                }
            }
        }
    }
}

