/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.common.TimeUtils;

public class ActionInvoicePositionList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        boolean parsed = this.getParameter("parsed") != null;
        Calendar month = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("month", null));
        if (month == null) {
            parsed = false;
        }
        Element positions = this.createElement(this.rootNode, "positions");
        Element positionsCB = this.createElement(positions, "positionsCB");
        List<Position> positionList = new PositionDao(this.con, this.mid, DocumentType.INVOICE).getPositonList();
        if (parsed) {
            for (Position pos : positionList) {
                this.addListItem(positionsCB, pos.getId(), BillUtil.parsePositionName(pos.getName(), month));
            }
        } else {
            for (Position pos : positionList) {
                this.addListItem(positionsCB, pos.getId(), pos.getTitle());
            }
        }
        for (Position position : positionList) {
            Element pos = this.createElement(positions, "pos");
            position.toXmlElement(pos);
        }
    }
}

