/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"bitel.billing.server.bill"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int moduleId, Event event) throws Exception {
        super.moduleAction(ctx, moduleId, event);
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            Connection con = ctx.getConnection();
            if (!cdEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("bill_data_" + moduleId), (String)"cid", (String)cidStr, (String)"id");
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("bill_invoice_data_" + moduleId), (String)"cid", (String)cidStr, (String)"id");
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("bill_attribute_" + moduleId), (String)"cid", (String)cidStr, (String)"id");
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("bill_contract_doc_type_" + moduleId), (String)"cid", (String)cidStr, (String)"id");
                ((BillService)ctx.getService(BillService.class, moduleId)).setBankAccount(event.getContractId(), 0);
            }
        } else if (event instanceof ContractCreateEvent) {
            Document dataDoc;
            ContractCreateEvent ccEvent = (ContractCreateEvent)event;
            Connection con = ctx.getConnection();
            if (!ccEvent.isCheck() && (dataDoc = ccEvent.getPattern().getData()) != null) {
                Element billElement;
                Element addDocuments = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/bill[@mid=" + moduleId + "]/addDocuments[@enable=1]"));
                if (addDocuments != null) {
                    ContractDocTypeManager cdtm = new ContractDocTypeManager(con, moduleId);
                    NodeList nodes = addDocuments.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (!"addDocumentType".equals(n.getNodeName())) continue;
                        Element addDocumentType = (Element)n;
                        for (Integer docType : Utils.toIntegerList((String)addDocumentType.getAttribute("docTypes"))) {
                            ContractDocType contractDocType = new ContractDocType();
                            contractDocType.setDocTypeId(docType);
                            contractDocType.setContractId(ccEvent.getContractId());
                            cdtm.addContractType(contractDocType);
                        }
                    }
                }
                if ((billElement = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/bill[@mid=" + moduleId + "]"))) != null) {
                    int bankAccountId = Utils.parseInt((String)billElement.getAttribute("bankAccountId"), (int)0);
                    ((BillService)ctx.getService(BillService.class, moduleId)).setBankAccount(ccEvent.getContractId(), bankAccountId);
                }
                try (AttributeDao attributeDao = new AttributeDao(con, moduleId);){
                    XMLUtils.selectElements((Node)dataDoc, (String)("data/modules/bill[@mid=" + moduleId + "]/rekvisits/item")).forEach(a -> {
                        Attribute attribute = new Attribute(0).setContractId(ccEvent.getContractId()).setName(a.getAttribute("name")).setContractParamPrefId("1".equals(a.getAttribute("type")) ? -1 : Utils.parseInt((String)a.getAttribute("value"))).setValue("1".equals(a.getAttribute("type")) ? a.getAttribute("value") : "");
                        try {
                            attributeDao.update(attribute);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex.getMessage());
                        }
                    });
                }
            }
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = ctx.getConnection();
            if (!cwEvent.isCheck()) {
                TableCopier copier = new TableCopier(con);
                HashMap<String, ColumnValue> valuesMap = new HashMap<String, ColumnValue>(1);
                valuesMap.put("cid", new ColumnValue(true, (Object)cwEvent.getToContractId()));
                copier.copyRecord("bill_contract_doc_type_" + moduleId, "cid=" + cwEvent.getContractId(), valuesMap);
            }
        }
    }

    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(contractId);
        if (!onlyCurrent) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("bill_data_" + moduleId), (String)"cid", (String)cidStr, (String)"id", (boolean)false, null, null);
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("bill_invoice_data_" + moduleId), (String)"cid", (String)cidStr, (String)"id", (boolean)false, null, null);
        }
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("bill_attribute_" + moduleId), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("bill_contract_doc_type_" + moduleId), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
    }
}

