/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class XMLTreePanel
extends JPanel {
    private JTree tree;
    private XMLTreeModel model;
    BGButton saveXmlButton;

    public XMLTreePanel(BGButton saveXmlButton) {
        this.setLayout(new GridBagLayout());
        this.saveXmlButton = saveXmlButton;
        saveXmlButton.setEnabled(false);
        this.model = new XMLTreeModel();
        this.tree = new JTree();
        this.tree.setModel(this.model);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.add((Component)new JScrollPane(this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)saveXmlButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    TreePath treePath = XMLTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (treePath == null) {
                        return;
                    }
                    Object lpc = treePath.getLastPathComponent();
                    if (lpc instanceof XMLTreeNode) {
                        NodeEditorPanel nodeEditorPanel = new NodeEditorPanel(((XMLTreeNode)lpc).getElement().getAttributes());
                        nodeEditorPanel.setVisible(true);
                    }
                }
            }
        });
    }

    public void setDocument(Document document) {
        this.model.setDocument(document);
    }

    public Document getDocument() {
        return this.model.getDocument();
    }

    public class XMLTreeModel
    implements TreeModel {
        private Document document;
        Vector<TreeModelListener> listeners = new Vector();

        public Document getDocument() {
            return this.document;
        }

        public void setDocument(Document document) {
            this.document = document;
            TreeModelEvent evt = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(evt);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof XMLTreeNode) {
                Vector<Element> elements = this.getChildElements(((XMLTreeNode)parent).getElement());
                return new XMLTreeNode(elements.get(index));
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof XMLTreeNode) {
                Vector<Element> elements = this.getChildElements(((XMLTreeNode)parent).getElement());
                return elements.size();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof XMLTreeNode && child instanceof XMLTreeNode) {
                Element pElement = ((XMLTreeNode)parent).getElement();
                Element cElement = ((XMLTreeNode)child).getElement();
                if (cElement.getParentNode() != pElement) {
                    return -1;
                }
                Vector<Element> elements = this.getChildElements(pElement);
                return elements.indexOf(cElement);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            if (this.document == null) {
                return null;
            }
            Vector<Element> elements = this.getChildElements(this.document);
            if (elements.size() > 0) {
                return new XMLTreeNode(elements.get(0));
            }
            return null;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof XMLTreeNode) {
                Element element = ((XMLTreeNode)node).getElement();
                Vector<Element> elements = this.getChildElements(element);
                return elements.size() == 0;
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }

        private Vector<Element> getChildElements(Node node) {
            Vector<Element> elements = new Vector<Element>();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                elements.add((Element)list.item(i));
            }
            return elements;
        }
    }

    public class KeyValueAttribute {
        private String key;
        private String value;

        public KeyValueAttribute(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class XMLTreeNode {
        Element element;

        public XMLTreeNode(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        public String toString() {
            Object val = this.element.getNodeName();
            for (String name : new String[]{"title", "name", "tariff_plan"}) {
                Node node = this.element.getAttributes().getNamedItem(name);
                if (node == null) continue;
                val = (String)val + " [" + node.getNodeValue() + "]";
                break;
            }
            return val;
        }

        public String getText() {
            NodeList list = this.element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Text)) continue;
                return ((Text)list.item(i)).getTextContent() + "1";
            }
            return "";
        }
    }

    private class NodeEditorPanel
    extends BGDialog {
        private BGButtonPanelRestoreOkCancelHelp okPanel = new BGButtonPanelRestoreOkCancelHelp();
        private List<KeyValueAttribute> list;
        private NamedNodeMap nodeMap;
        BGTableModel<KeyValueAttribute> model = null;
        BGUTable table = new BGUTable(this.model);

        public NodeEditorPanel(NamedNodeMap map) {
            this.nodeMap = map;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setModal(true);
            this.model = new BGTableModel<KeyValueAttribute>("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b"){

                protected void initColumns() {
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, 40, 130, 250, "key", true, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 40, 120, -1, "value", true, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                }
            };
            this.table.setSelectionMode(0);
            this.table.setModel(this.model);
            this.setData();
            this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.okPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.okPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getActionCommand()) {
                        case "reset": {
                            NodeEditorPanel.this.setData();
                            break;
                        }
                        case "ok": {
                            NodeEditorPanel.this.saveData();
                        }
                        case "cancel": {
                            NodeEditorPanel.this.dispose();
                        }
                    }
                }
            });
            this.pack();
            this.setSize(600, 350);
            this.moveWindowToCenterScreen();
        }

        public void setData() {
            this.list = new ArrayList<KeyValueAttribute>();
            if (this.nodeMap == null) {
                return;
            }
            for (int i = 0; i < this.nodeMap.getLength(); ++i) {
                Node n = this.nodeMap.item(i);
                this.list.add(new KeyValueAttribute(n.getNodeName(), n.getNodeValue()));
            }
            this.model.setData(this.list);
        }

        private void saveData() {
            if (this.nodeMap == null) {
                return;
            }
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            for (KeyValueAttribute kv : this.list) {
                Node n = this.nodeMap.getNamedItem(kv.getKey());
                if (kv.getValue().equals(n.getNodeValue())) continue;
                n.setNodeValue(kv.getValue());
                XMLTreePanel.this.saveXmlButton.setEnabled(true);
            }
        }
    }
}

