/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action.web;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.assist.server.bean.Constants;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Assist")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("assist");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("assist.gate.url", "https://payments.paysecure.ru/pay/order.cfm"));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            searchResult.setList(searchResult.getList());
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.registerOrder(this.contractId, this.sum, this.getResult(), false, false);
        }
        this.setResultParam("gateUrl", this.moduleSetup.get("assist.gate.url", "https://payments.paysecure.ru/pay/order.cfm"));
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        super.autopayment();
        try (AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);){
            this.autopaymentImpl("assist", autopaymentManager, Constants.class);
        }
    }

    protected void registerOrder(BigDecimal sum, String customerAddress) throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.registerOrder(this.contractId, sum, this.getResult(), false, true);
        }
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (!redirect) {
            this.execute();
        }
    }
}

