/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.client;

import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    static final String COLUMN_CARD = "card";
    static final String COLUMN_ERROR = "error";
    static final String COLUMN_ORDER_ID = "orderId";
    static final String COLUMN_AUTH_CODE = "authCode";
    static final String COLUMN_APPROVAL_CODE = "approvalCode";
    static final String COLUMN_CARDHOLDER_NAME = "cardholderName";
    static final String COLUMN_TITLE_CARD = "\u041a\u0430\u0440\u0442\u0430";
    static final String COLUMN_TITLE_ERROR = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438";
    static final String COLUMN_TITLE_ORDER_ID = "OrderId";
    static final String COLUMN_TITLE_AUTH_CODE = "AuthCode";
    static final String COLUMN_TITLE_APPROVAL_CODE = "ApprovalCode";
    static final String COLUMN_TITLE_CARDHOLDER_NAME = "\u0418\u043c\u044f \u0434\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044f \u043a\u0430\u0440\u0442\u044b";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    protected Object getStatusValue(Transaction value, int column) throws BGException {
        AbstractTransactionStatus result = TransactionStatus.ALL.getStatusByCode(value.getStatus());
        return result == null ? value.getStatus() : result.getTitle();
    }

    public Object getValue(Transaction value, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if (COLUMN_CARD.equals(identifier)) {
            return this.getParameter(value.getParameters(), "Pan");
        }
        if (COLUMN_ORDER_ID.equals(identifier)) {
            return this.getParameter(value.getParameters(), COLUMN_ORDER_ID);
        }
        if (COLUMN_CARDHOLDER_NAME.equals(identifier)) {
            return this.getParameter(value.getParameters(), COLUMN_CARDHOLDER_NAME);
        }
        if (COLUMN_ERROR.equals(identifier)) {
            String errorCodeKey = "errorCode";
            String errorMessageKey = "errorMessage";
            String actionCodeDescription = "";
            if (value.getTransactionType() == BGTransactionType.QR_SBP) {
                errorCodeKey = "error_code";
                errorMessageKey = "error_message";
            } else if (value.getTransactionType() == BGTransactionType.CARD) {
                actionCodeDescription = this.getParameter(value.getParameters(), "actionCodeDescription");
            }
            String errorCode = this.getParameter(value.getParameters(), errorCodeKey);
            String errorMessage = this.getParameter(value.getParameters(), errorMessageKey);
            return (String)(errorCode == null ? "" : "[#" + errorCode + "] ") + errorMessage + (String)(actionCodeDescription.isEmpty() ? "" : " (" + actionCodeDescription + ")");
        }
        if (COLUMN_APPROVAL_CODE.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), "cardAuthInfo.approvalCode");
            if (Utils.isBlankString((String)paramValue)) {
                paramValue = this.getParameter(value.getParameters(), COLUMN_APPROVAL_CODE);
            }
            return paramValue;
        }
        return super.getValue((Object)value, column);
    }
}

