/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="AlfabankExecutor", urlPatterns={"/alfabank/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_MD_ORDER = "mdOrder";
    private static final String PARAM_ORDER_NUMBER = "orderNumber";
    private static final Logger log = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                String orderNumber = request.getParameter(PARAM_ORDER_NUMBER);
                String transactionId = request.getParameter(PARAM_MD_ORDER);
                Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderNumber));
                if (transaction == null) {
                    log.error("Not found transaction for ID = {}", (Object)orderNumber);
                    return;
                }
                if (!transaction.getTransactionId().equals(transactionId)) {
                    log.error("Transaction for ID = {} ( {} != {} )", (Object)orderNumber, (Object)transaction.getTransactionId(), (Object)transactionId);
                    return;
                }
                EventProcessor.getInstance().publish((Event)new AlfabankCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
                return;
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

