/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import java.io.IOException;
import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.bean.Constants;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u0410\u043b\u044c\u0444\u0430\u0431\u0430\u043d\u043a")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("alfabank");
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 + \u0438\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void check() throws Exception {
        EventProcessor.getInstance().publish((Event)new AlfabankCheckEvent(this.moduleId, this.contractId, false));
        this.execute();
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult.Builder().setPage(this.getPage()).setSort(new String[]{"transactionDatetime:1"}).build();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.searchTransaction(searchResult, SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build());
        }
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            boolean sbp;
            transactionManager.registerOrder(this.contractId, ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle(), this.customerAddress, this.sum, this.getResult(), false, false, null);
            boolean bl = sbp = this.moduleSetup.getBoolean("alfabank.sbp.enable", false) && this.req.getBoolean("sbp", false);
            if (sbp) {
                // empty if block
            }
        }
        this.doRedirect();
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        super.autopayment();
        try (AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);){
            this.autopaymentImpl("alfabank", autopaymentManager, Constants.class);
        }
    }

    protected void registerOrder(BigDecimal sum, String customerAddress) throws Exception {
        String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, sum, this.getResult(), false, true, null);
        }
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (redirect) {
            this.doRedirect();
        } else {
            this.execute();
        }
    }

    protected void doRedirect() throws BGException {
        Object formUrl = this.getResultParam("formUrl");
        if (formUrl != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(formUrl));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.getLogger().error(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
        this.execute();
        throw new BGMessageException(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
    }
}

