/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public final class CostTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TariffContext, TreeContext, TvTariffWorkerContext> {
    private final int periodMode;
    private int periodAmount;
    private final boolean periodAlign;
    private final boolean periodProportional;
    private final boolean ignoreBalance;
    private final boolean costFromProduct;
    private BigDecimal cost;
    private int costPeriod;
    private final JSONObject trialPeriodParameters;

    public CostTariffTreeNode(int id, ParameterMap params) {
        super(id, params);
        this.periodMode = params.getInt("periodMode", 0);
        this.periodAmount = params.getInt("periodAmount", 0);
        this.periodAlign = params.getInt("periodAlign", 0) > 0;
        this.periodProportional = params.getInt("periodProportional", 0) > 0;
        this.ignoreBalance = params.getInt("ignoreBalance", 0) > 0;
        this.costFromProduct = params.getInt("costFromProduct", 0) > 0;
        this.cost = this.periodAmount >= 0 ? params.getBigDecimal("cost", BigDecimal.ZERO) : null;
        this.costPeriod = params.getInt("costPeriod", 0);
        this.trialPeriodParameters = new JSONObject(params.get("trialPeriod", "{}"));
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest tvTariffRequest, TariffContext tariffContext, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        Objects.requireNonNull(tvTariffRequest, "tvTariffRequest must be not null");
        if (this.trialPeriodParameters.optString("enableTrialPeriod").equals("1")) {
            int trialPeriodCount;
            int trialPeriodType = this.trialPeriodParameters.optString("trialPeriodType").equals("3") ? 3 : 5;
            TvServiceCost tvServiceCost = (TvServiceCost)tvTariffRequest.serviceCost;
            LocalDateTime productActivationTime = tvServiceCost == null ? LocalDateTime.now() : TimeUtils.convertDateToLocalDateTime((Date)tvServiceCost.getProductItem().productPeriodActivationTime);
            LocalDateTime endTrialPeriod = productActivationTime.plus(trialPeriodCount = this.trialPeriodParameters.optInt("trialPeriodCount"), trialPeriodType == 3 ? ChronoUnit.DAYS : ChronoUnit.MONTHS);
            if (endTrialPeriod.isAfter(LocalDateTime.now())) {
                String cost = this.trialPeriodParameters.optString("trialPeriodCost");
                BigDecimal trialPeriodCost = Utils.notBlankString((String)cost) ? new BigDecimal(cost) : BigDecimal.ZERO;
                int trialCostCount = this.trialPeriodParameters.optInt("trialCostCount");
                int trialCostType = this.trialPeriodParameters.optString("trialCostType").equals("3") ? 3 : 5;
                this.cost = trialPeriodCost;
                this.costPeriod = trialCostType;
                this.periodAmount = trialCostCount;
            }
        }
        if (this.cost != null && tvTariffRequest.serviceCost != null) {
            BigDecimal outCost;
            if (this.costPeriod == 3 && this.periodMode == 5) {
                ((TvServiceCost)tvTariffRequest.serviceCost).dayToEndMonth = true;
            }
            BigDecimal inCost = this.cost;
            if (this.costFromProduct) {
                inCost = new JSONObject(((TvServiceCost)tvTariffRequest.serviceCost).getProductSpecRuntime().productSpec.getData()).optBigDecimal("cost", BigDecimal.ZERO);
            }
            ((TvServiceCost)tvTariffRequest.serviceCost).periodProportional = this.periodProportional;
            ((TvServiceCost)tvTariffRequest.serviceCost).ignoreBalance = this.ignoreBalance;
            if (this.costPeriod == 5 && this.periodMode == 3) {
                int daysCount = tvTariffRequest.getTime().getActualMaximum(5);
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = this.periodMode;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = this.periodAmount;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = this.periodAlign;
                outCost = inCost.divide(BigDecimal.valueOf(daysCount), tariffContext.mc);
            } else if (this.costPeriod == 3 && this.periodMode == 5) {
                ZonedDateTime productTimeFrom;
                int day = tvTariffRequest.getTime().get(5);
                int daysCount = tvTariffRequest.getTime().getActualMaximum(5);
                int days = daysCount - day + 1;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = 3;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = days;
                boolean bl = ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = !this.periodProportional;
                if (((TvServiceCost)tvTariffRequest.serviceCost).periodAlign && ((TvServiceCost)tvTariffRequest.serviceCost).getProductItem() != null && ((productTimeFrom = Instant.ofEpochMilli(((TvServiceCost)tvTariffRequest.serviceCost).getProductItem().productTimeFrom.getTime()).atZone(ZoneId.systemDefault())).getSecond() != 0 || productTimeFrom.getMinute() != 0 || productTimeFrom.getHour() != 0)) {
                    ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = false;
                }
                outCost = inCost.multiply(BigDecimal.valueOf(days), tariffContext.mc).divide(BigDecimal.valueOf(daysCount), tariffContext.mc);
            } else {
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = this.periodMode;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = this.periodAmount;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = this.periodAlign;
                outCost = inCost;
            }
            ((TvServiceCost)tvTariffRequest.serviceCost).setCost(outCost);
        }
        return 1;
    }

    protected int postExecuteImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext, int executeResult) {
        return executeResult;
    }
}

