/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.object.client.ContractObjectEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.table.ObjectParameterTableRow;
import ru.bitel.bgbilling.kernel.contract.object.client.table.TableObjectParameters;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamListEditorDialog;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.CalendarDialog;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class ObjectParamEditor
extends BGPanel {
    private TableObjectParameters tableObjectParameters = new TableObjectParameters();
    private ContractObjectEditor contractObjectEditor;
    private BGUTable historyTable = null;
    private ObjectParamHistoryTableModel historyTableModel = new ObjectParamHistoryTableModel();
    private CardLayout tableLayout = new CardLayout();
    private JPanel tablePanel = null;
    private int selectedPid = -1;
    private int selectedPt = -1;
    private Directory<UserInfo> userDirectory;

    public ObjectParamEditor() {
        this.historyTable = new BGUTable((TableModel)((Object)this.historyTableModel));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        BGSwingUtilites.handleMouseClicked((Component)((Object)this.tableObjectParameters), this::tableObject_mouseClicked);
        this.tableObjectParameters.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doEnterEditing");
        this.tableObjectParameters.getActionMap().put("doEnterEditing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectParamEditor.this.tableObject_enterPressed();
            }
        });
        ((DefaultTableModel)this.tableObjectParameters.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ObjectParameterTableRow row;
                int parameterType;
                if (ObjectParamEditor.this.fl && ObjectParamEditor.this.tableObjectParameters.getRowCount() > 0 && ((parameterType = (row = (ObjectParameterTableRow)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 0)).getParameterType()) == EntitySpecAttrType.TEXT.getCode() || parameterType == EntitySpecAttrType.BOOLEAN.getCode())) {
                    int pid = row.getParameterId();
                    int objectId = ObjectParamEditor.this.id;
                    try {
                        if (parameterType == EntitySpecAttrType.TEXT.getCode()) {
                            EntityAttrText attrText = new EntityAttrText(objectId, pid, (String)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 1));
                            ((ContractObjectService)ObjectParamEditor.this.getContext().getWebService(ContractObjectService.class)).objectParameterTextUpdate(ObjectParamEditor.this.getContractId(), attrText);
                        } else if (parameterType == EntitySpecAttrType.BOOLEAN.getCode()) {
                            EntityAttrBoolean attrBoolean = new EntityAttrBoolean(objectId, pid, ((Boolean)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 1)).booleanValue());
                            ((ContractObjectService)ObjectParamEditor.this.getContext().getWebService(ContractObjectService.class)).objectParameterFlagUpdate(ObjectParamEditor.this.getContractId(), attrBoolean);
                        }
                        ObjectParamEditor.this.refreshPanels();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        JButton deleteHistory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
        deleteHistory.addActionListener(e -> this.clearContractHistory());
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        JPanel historyPanel = new JPanel(new GridBagLayout());
        historyPanel.add((Component)new JScrollPane((Component)this.historyTable), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)deleteHistory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 0), 0, 0));
        historyPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)returnButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 15), 0, 0));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.add((Component)new JScrollPane((Component)((Object)this.tableObjectParameters)), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tablePanel = new JPanel(this.tableLayout);
        this.tablePanel.add((Component)paramPanel, "param");
        this.tablePanel.add((Component)historyPanel, "history");
        this.setLayout(new GridBagLayout());
        this.add(this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setId(int id) {
        super.setId(id);
        if (id == 0) {
            DefaultTableModel tableModel = (DefaultTableModel)this.tableObjectParameters.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
        }
    }

    public void setData() throws Exception {
        if (this.id != 0) {
            this.loadObjectParams();
        }
    }

    public void loadObjectParams() {
        this.fl = false;
        try {
            ContractObjectService contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
            this.tableObjectParameters.setRowsData(contractObjectService.contractObjectParameters(this.getContext().getContractId(), this.id));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.fl = true;
    }

    private void tableObject_enterPressed() {
        int row = this.tableObjectParameters.getSelectedRow();
        if (row > -1) {
            this.openEditor(row);
        }
    }

    private void tableObject_mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        int row = this.tableObjectParameters.getSelectedRow();
        if (e.getClickCount() == 2 && row > -1) {
            this.openEditor(row);
        } else if (e.getClickCount() == 1 && row > -1) {
            ObjectParameterTableRow tr = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
            int col = this.tableObjectParameters.getSelectedColumn();
            if (col == 2) {
                this.tableLayout.show(this.tablePanel, "history");
                this.renewHistoryTable(tr.getParameterId(), tr.getParameterType());
            }
        }
    }

    private void openEditor(int row) {
        ObjectParameterTableRow tableRow = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
        int parameterType = tableRow.getParameterType();
        int parameterId = tableRow.getParameterId();
        ContractParamEditorData data = new ContractParamEditorData().setEntityType(EntityType.OBJECT_PARAMETER).setClientContext(this.getContext()).setContractId(this.getContractId()).setObjectId(this.id).setParameterId(parameterId).setParameterTitle(tableRow.getTitle());
        if (parameterType != -1) {
            if (parameterType == EntitySpecAttrType.ADDRESS.getCode()) {
                new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).open();
                this.refreshPanels();
            } else if (parameterType == EntitySpecAttrType.DATE.getCode()) {
                String dateStr = (String)tableRow.getValue();
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                GregorianCalendar dt = new GregorianCalendar();
                try {
                    dt.setTime(format.parse(dateStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CalendarDialog calendar = new CalendarDialog();
                calendar.setCalendar((Calendar)dt);
                calendar.setModal(true);
                if (calendar.showDialog().equals("ok")) {
                    try {
                        EntityAttrDate attrDate = new EntityAttrDate(this.id, parameterId, calendar.getCalendar() != null ? calendar.getCalendar().getTime() : null);
                        ((ContractObjectService)this.getContext().getWebService(ContractObjectService.class)).objectParameterDateUpdate(this.getContractId(), attrDate);
                        this.refreshPanels();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            } else if (parameterType == EntitySpecAttrType.LIST.getCode()) {
                new ContractParamListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0421\u043f\u0438\u0441\u043e\u043a\"", data).open();
                this.refreshPanels();
            } else if (parameterType == EntitySpecAttrType.TEXT.getCode()) {
                this.tableObjectParameters.editCellAt(row, 1);
            } else if (parameterType == EntitySpecAttrType.BOOLEAN.getCode()) {
                this.tableObjectParameters.setValueAt((Boolean)this.tableObjectParameters.getValueAt(row, 1) != false ? Boolean.FALSE : Boolean.TRUE, row, 1);
            }
        }
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.contractObjectEditor = contractObjectEditor;
    }

    private void refreshPanels() {
        this.trySetData();
        this.contractObjectEditor.setData();
    }

    private void renewHistoryTable(int parameterId, int parameterType) {
        try {
            ContractObjectService contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class);
            this.historyTableModel.setData(contractObjectService.objectParameterHistoryList(this.getContext().getContractId(), this.id, parameterId, parameterType));
            this.selectedPid = parameterId;
            this.selectedPt = parameterType;
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void clearContractHistory() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            try {
                ((ContractObjectService)this.getContext().getWebService(ContractObjectService.class)).objectParameterHistoryClear(this.getContext().getContractId(), this.id, this.selectedPid, this.selectedPt);
                this.renewHistoryTable(this.selectedPid, this.selectedPt);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    class ObjectParamHistoryTableModel
    extends BGTableModel<ParameterHistoryEntry> {
        public ObjectParamHistoryTableModel() {
            super(ObjectParamEditor.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 100, 150, 200, "date", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 10, 500, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", 100, 150, 200, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(ParameterHistoryEntry val, int column) throws Exception {
            switch (column) {
                case 0: {
                    return TimeUtils.formatFullDate((Date)val.getDate());
                }
                case 1: {
                    if (ObjectParamEditor.this.selectedPt == 3) {
                        return val.getValue() == null ? "[\u0423\u0414\u0410\u041b\u0415\u041d\u041e]" : val.getValue();
                    }
                    if (ObjectParamEditor.this.selectedPt == 5) {
                        return "1".equals(val.getValue()) ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e";
                    }
                    return val.getValue();
                }
                case 2: {
                    UserInfo user = ObjectParamEditor.this.userDirectory.get(Utils.parseInt((String)val.getUser(), (int)-2));
                    return user != null ? user.getName() : "\u041d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

