/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class HelpDeskDirectoryManager {
    private static final String TABLE_HELPDESK_PARAM = "helpdesk_param";
    private static final String TABLE_HELPDESK_DIRECTORY_LINK = "helpdesk_directory_link";
    private static final String TABLE_HELPDESK_CATEGORY = "helpdesk_category";
    private static final String TABLE_HELPDESK_GROUP = "helpdesk_group";
    private static final String TABLE_HELPDESK_SUBCATEGORY = "helpdesk_subcategory";
    protected Connection con;
    protected BGPluginServer plugin = null;

    public HelpDeskDirectoryManager(Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public void getGroupList(SearchResult<IdTitle> searchResult) throws Exception {
        this.getList(searchResult, TABLE_HELPDESK_GROUP);
    }

    public void getCategoryList(SearchResult<IdTitle> searchResult) throws Exception {
        this.getList(searchResult, TABLE_HELPDESK_CATEGORY);
    }

    public void getSubCategoryList(SearchResult<IdTitle> searchResult) throws Exception {
        this.getList(searchResult, TABLE_HELPDESK_SUBCATEGORY);
    }

    private void getList(SearchResult<IdTitle> searchResult, String tableName) throws Exception {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.getDBTableName(tableName) + " ORDER BY title" + page.sqlLimit();
            try (Statement st = this.con.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    IdTitle item = new IdTitle();
                    this.setData(rs, item);
                    list.add(item);
                }
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
    }

    public void getCategoryListSelectAndAvailable(SearchResult<IdTitle> searchResultSelect, SearchResult<IdTitle> searchResultAvailable, int groupId) throws Exception {
        if (searchResultSelect != null && searchResultAvailable != null) {
            IdTitle categoryItem;
            ResultSet rs;
            PreparedStatement ps;
            String query;
            if (searchResultSelect != null) {
                List selectList = searchResultSelect.getList();
                query = "SELECT DISTINCT c.id, c.title FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " l LEFT JOIN " + this.getDBTableName(TABLE_HELPDESK_CATEGORY) + " as c ON c.id=l.category WHERE l.group=?";
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, groupId);
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            if (rs.getInt("id") == 0) continue;
                            categoryItem = new IdTitle();
                            this.setData(rs, categoryItem);
                            selectList.add(categoryItem);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            if (searchResultAvailable != null) {
                List availableList = searchResultAvailable.getList();
                query = "SELECT * FROM " + this.getDBTableName(TABLE_HELPDESK_CATEGORY) + " WHERE id NOT IN(SELECT DISTINCT c.id FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " l LEFT JOIN " + this.getDBTableName(TABLE_HELPDESK_CATEGORY) + " as c ON c.id=l.category WHERE l.group=?)";
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, groupId);
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            if (rs.getInt("id") == 0) continue;
                            categoryItem = new IdTitle();
                            this.setData(rs, categoryItem);
                            availableList.add(categoryItem);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
    }

    public Map<Integer, List<Integer>> getSubCategoryIds(int groupId) throws Exception {
        HashMap<Integer, List<Integer>> resultMap = new HashMap<Integer, List<Integer>>();
        String query = "SELECT category, subcategory FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE `group`=" + groupId;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query.toString());){
            while (rs.next()) {
                int categoryId = rs.getInt(1);
                ArrayList<Integer> list = (ArrayList<Integer>)resultMap.get(categoryId);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    resultMap.put(categoryId, list);
                }
                list.add(rs.getInt(2));
            }
        }
        return resultMap;
    }

    public void getSubCategoryListAvailableAndSelect(SearchResult<IdTitle> selectSubCategory, SearchResult<IdTitle> availableSubCategory, int groupId, int categoryId) throws Exception {
        IdTitle subcategoryItem;
        ResultSet rs;
        PreparedStatement ps;
        String query;
        if (selectSubCategory != null) {
            List selectList = selectSubCategory.getList();
            query = "SELECT DISTINCT s.id, s.title FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " l LEFT JOIN " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " as s ON s.id=l.subcategory WHERE l.group=? AND l.category=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, groupId);
                ps.setInt(2, categoryId);
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        if (rs.getInt("id") == 0) continue;
                        subcategoryItem = new IdTitle();
                        this.setData(rs, subcategoryItem);
                        selectList.add(subcategoryItem);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        if (availableSubCategory != null) {
            List availableList = availableSubCategory.getList();
            query = "SELECT * FROM " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " WHERE id NOT IN(SELECT DISTINCT s.id FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " l LEFT JOIN " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " as s ON s.id=l.subcategory WHERE l.group=? AND l.category=?)";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, groupId);
                ps.setInt(2, categoryId);
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        subcategoryItem = new IdTitle();
                        this.setData(rs, subcategoryItem);
                        availableList.add(subcategoryItem);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public void updateGroupTitle(IdTitle idTitle) throws Exception {
        this.updateTitle(idTitle, TABLE_HELPDESK_GROUP);
    }

    public void updateCategoryTitle(IdTitle idTitle) throws Exception {
        this.updateTitle(idTitle, TABLE_HELPDESK_CATEGORY);
    }

    public void updateSubCategoryTitle(IdTitle idTitle) throws Exception {
        this.updateTitle(idTitle, TABLE_HELPDESK_SUBCATEGORY);
    }

    private void updateTitle(IdTitle listItem, String tableName) throws Exception {
        Objects.requireNonNull(listItem);
        boolean update = listItem.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.getDBTableName(tableName) + " SET title=?" + (update ? " WHERE id =?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, listItem.getTitle());
            if (update) {
                ps.setInt(2, listItem.getId());
            }
            ps.executeUpdate();
        }
    }

    public void deleteGroupTitle(int id) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_GROUP) + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " WHERE name=? AND value=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setString(1, "group.id");
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE `group`=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void deleteCategeryTitle(int id) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_CATEGORY) + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE category=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void deleteSubCategeryTitle(int id) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE subcategory=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void setData(ResultSet rs, IdTitle pckg) throws Exception {
        pckg.setId(Utils.parseInt((String)rs.getString("id")));
        pckg.setTitle(rs.getString("title"));
    }

    public void addCategoryToGroup(int groupId, int categoryId) throws Exception {
        String query = "INSERT INTO " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " ( `group`, `category`, `subcategory` ) VALUES ( ?, ?, 0 )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.setInt(2, categoryId);
            ps.executeUpdate();
        }
    }

    public void addSubcategoryToCategory(int groupId, int categoryId, int subCategoryId) throws Exception {
        this.deleteItemToDirectoryLink(groupId, categoryId, subCategoryId);
        String query = "INSERT INTO " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " SET `group`=?, `category`=?, `subcategory`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.setInt(2, categoryId);
            ps.setInt(3, subCategoryId);
            ps.executeUpdate();
        }
    }

    public void deleteCategoryToGroup(int groupId, int categoryId) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE `group`=? AND `category`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, groupId);
            ps.setInt(2, categoryId);
            ps.executeUpdate();
        }
    }

    public void deleteSubcategoryToCategory(int groupId, int categoryId, int subCategoryId) throws Exception {
        this.deleteItemToDirectoryLink(groupId, categoryId, subCategoryId);
    }

    public void updateContractGroup(int contractId, int groupId) throws Exception {
        if (this.hasContractGroup(contractId)) {
            if (groupId == -2) {
                this.deleteGroupIdFromCantractParam(contractId);
                return;
            }
            String query = "UPDATE " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " SET value=? WHERE cid=? AND name=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, groupId);
                ps.setInt(2, contractId);
                ps.setString(3, "group.id");
                ps.executeUpdate();
            }
        }
        String query = "INSERT INTO " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " SET cid=?, name=?, value=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            ps.setString(2, "group.id");
            ps.setInt(3, groupId);
            ps.executeUpdate();
        }
    }

    public void setCategorySubcategory(int categoryId, int subcategoryId, int topicId) throws Exception {
        String query = "UPDATE " + this.getDBTableName("helpdesk_topic") + " SET category_id=?, subcategory_id=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, categoryId);
            ps.setInt(2, subcategoryId);
            ps.setInt(3, topicId);
            ps.executeUpdate();
        }
    }

    public boolean hasContractGroup(int contractId) throws Exception {
        int count = 0;
        String query = "SELECT COUNT(*) FROM " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " WHERE cid=? AND name=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            ps.setString(2, "group.id");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        return count != 0;
    }

    public int getContractGroupId(int contractId) throws Exception {
        int result = -1;
        String query = "SELECT value FROM " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " WHERE name='group.id' AND cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getInt("value");
                }
            }
        }
        return result;
    }

    public String getCategoryTitle(int categoryId) throws Exception {
        String result = "";
        String query = "SELECT title FROM " + this.getDBTableName(TABLE_HELPDESK_CATEGORY) + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, categoryId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getString("title");
                }
            }
        }
        return result;
    }

    public List<IdTitle> getSubcategory(Collection<Integer> subcategoryIds) throws Exception {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if (Utils.isEmptyCollection(subcategoryIds)) {
            return result;
        }
        String query = "SELECT id, title FROM " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " WHERE id IN ( " + Utils.toString(subcategoryIds) + " )";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return result;
    }

    public int inspectionGroupContract(int groupId) throws Exception {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.getDBTableName(TABLE_HELPDESK_PARAM) + "  WHERE name=? AND value=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setString(1, "group.id");
            ps.setInt(2, groupId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public int inspectionCategory(int categoryId) throws Exception {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.getDBTableName("helpdesk_topic") + "  WHERE category_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, categoryId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public int inspectionSubcategory(int subcategoryId) throws Exception {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM " + this.getDBTableName("helpdesk_topic") + "  WHERE subcategory_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, subcategoryId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    private void deleteGroupIdFromCantractParam(int contractId) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_PARAM) + " WHERE cid=? AND name='group.id'";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    private void deleteItemToDirectoryLink(int groupId, int categoryId, int subCategoryId) throws Exception {
        String query = "DELETE FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " WHERE `group`=? AND `category`=? AND `subcategory`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.setInt(2, categoryId);
            ps.setInt(3, subCategoryId);
            ps.executeUpdate();
        }
    }

    public List<IdTitle> getSubCategory(int groupId, int categoryId) throws Exception {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        String query = "SELECT s.* FROM " + this.getDBTableName(TABLE_HELPDESK_DIRECTORY_LINK) + " AS l LEFT JOIN " + this.getDBTableName(TABLE_HELPDESK_SUBCATEGORY) + " AS s ON l.subcategory=s.id WHERE l.`group`=? AND l.`category`=? AND s.`id` IS NOT NULL ORDER BY s.`title`";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.setInt(2, categoryId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(new IdTitle(rs.getInt("id"), rs.getString("title")));
                }
            }
        }
        return list;
    }
}

