/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.NsServer;

public class NsServerManager {
    private Connection con;
    private String tableName;

    public NsServerManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_ns_server_" + mid;
    }

    public NsServer getServer(int id) {
        NsServer result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getServerFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NsServer> getServerList() {
        ArrayList<NsServer> result = new ArrayList<NsServer>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getServerFromRs(rs));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateServer(NsServer server) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            if (server.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, host, addr, port, key, comment) VALUES (?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, host=?, addr=?, port=?, `key`=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
            }
            ps.setString(index++, server.getTitle());
            ps.setString(index++, server.getHost());
            ps.setString(index++, server.getAddr());
            ps.setInt(index++, server.getPort());
            ps.setString(index++, server.getKey());
            ps.setString(index++, server.getComment());
            if (server.getId() > 0) {
                ps.setInt(index++, server.getId());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteServer(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NsServer getServerFromRs(ResultSet rs) throws SQLException {
        NsServer result = new NsServer();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setHost(rs.getString("host"));
        result.setAddr(rs.getString("addr"));
        result.setPort(rs.getInt("port"));
        result.setKey(rs.getString("key"));
        result.setComment(rs.getString("comment"));
        return result;
    }
}

