/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeTypeDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class AttributeDao
extends AbstractIdDao<Attribute> {
    public static final String CONTRACT_PARAM_PREF_MACROS = "$macroContractParamPref:";
    public static final String CONTRACT_PARAM_PREF_MACROS_USE_SUPER = "$useSuper:";

    public AttributeDao(Connection con, int mid) {
        super(con, mid, "bill_attribute");
    }

    public List<Attribute> getAttributeListByCid(int contractId) throws SQLException {
        return this.list("cid=?", null, new Object[]{contractId});
    }

    public List<Attribute> getActiveAttributeList(int contractId) throws SQLException {
        return this.list("cid=? AND (start IS NULL OR TO_DAYS(start)<=TO_DAYS(NOW())) AND (end IS NULL OR TO_DAYS(end)>=TO_DAYS(NOW()))", "name", new Object[]{contractId});
    }

    public List<Attribute> getActiveAttributeList(Set<Integer> contractIds) throws SQLException {
        return this.list("cid IN ( " + Utils.toString(contractIds, (String)",") + " ) AND (start IS NULL OR TO_DAYS(start)<=TO_DAYS(NOW())) AND (end IS NULL OR TO_DAYS(end)>=TO_DAYS(NOW()))", "name", new Object[0]);
    }

    public void clearAttributes(int contractId) throws SQLException {
        this.delete("cid=?", new Object[]{contractId});
    }

    public void clearAllAttributes() throws SQLException {
        this.delete("cid>?", new Object[]{0});
    }

    protected void updateImpl(Attribute attribute) throws SQLException {
        block32: {
            AttributeTypeDao typeDao;
            AttributeType ba;
            Objects.requireNonNull(attribute);
            int id = attribute.getId();
            int cid = attribute.getContractId();
            String name = attribute.getName();
            Object value = attribute.getValue();
            Date start = null;
            Date end = null;
            if (attribute.getPeriod() != null) {
                start = attribute.getPeriod().getDateFrom();
                end = attribute.getPeriod().getDateTo();
            }
            if ((ba = (typeDao = new AttributeTypeDao(this.con, this.moduleId)).getAttributeTypeByName(name)) == null || attribute.getContractParamPrefId() < 1 && !this.canSetValue((String)value, ba.getCheck())) {
                throw new BGRuntimeException("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443!");
            }
            if (attribute.getContractParamPrefId() > 0) {
                value = CONTRACT_PARAM_PREF_MACROS + attribute.getContractParamPrefId() + (attribute.isUseSuperContract() ? ";$useSuper:1" : "");
            }
            String query = "SELECT id FROM " + this.tableName + " WHERE cid=" + cid + " AND id!=" + id + " AND name=?";
            if (start != null || end != null) {
                query = query + " AND ";
            }
            if (start != null) {
                query = query + "(( (start IS NULL OR TO_DAYS(start)<=TO_DAYS(?)) AND (end IS NULL OR TO_DAYS(end)>=TO_DAYS(?)) ) OR (TO_DAYS(start)>=TO_DAYS(?) AND TO_DAYS(end)>TO_DAYS(?)) ";
            }
            if (start != null && end != null) {
                query = query + "OR ";
            } else if (start != null) {
                query = query + ")";
            } else if (end != null) {
                query = query + "(";
            }
            if (end != null) {
                query = query + "((start IS NULL OR TO_DAYS(start)<=TO_DAYS(?)) AND (end IS NULL OR TO_DAYS(end)>=TO_DAYS(?))) OR (TO_DAYS(start)>=TO_DAYS(?) AND TO_DAYS(end)>TO_DAYS(?)))";
            }
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, name);
                if (start != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)start));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)start));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)start));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)start));
                }
                if (end != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)end));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)end));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)end));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)end));
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        query = (id <= 0 ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET cid=?, name=?, value=?, start=?, end=?" + (String)(id > 0 ? " WHERE id=" + id : "");
                        try (PreparedStatement ps1 = this.con.prepareStatement(query);){
                            ps1.setInt(1, cid);
                            ps1.setString(2, name);
                            ps1.setString(3, (String)value);
                            ps1.setDate(4, TimeUtils.convertDateToSqlDate((Date)start));
                            ps1.setDate(5, TimeUtils.convertDateToSqlDate((Date)end));
                            ps1.executeUpdate();
                            break block32;
                        }
                    }
                    throw new BGRuntimeException("\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f!");
                }
            }
        }
    }

    private boolean canSetValue(String value, String check) {
        Pattern pattern = null;
        if (Utils.notBlankString((String)check)) {
            pattern = Pattern.compile("^" + check + "$");
        }
        return pattern == null ? true : pattern.matcher(value).find();
    }

    protected Attribute getFromRS(ResultSet rs) throws SQLException {
        List list;
        Attribute billAttr = new Attribute();
        billAttr.setId(rs.getInt("id"));
        billAttr.setContractId(rs.getInt("cid"));
        billAttr.setName(rs.getString("name"));
        billAttr.setValue(rs.getString("value"));
        billAttr.setPeriod(new Period((Date)rs.getDate("start"), (Date)rs.getDate("end")));
        String val = billAttr.getValue();
        if (val != null && val.length() > CONTRACT_PARAM_PREF_MACROS.length() && val.contains(CONTRACT_PARAM_PREF_MACROS) && (list = Utils.toList((String)val, (String)";")).size() > 0) {
            int prefId = Utils.parseInt((String)((String)list.get(0)).substring(CONTRACT_PARAM_PREF_MACROS.length()), (int)-1);
            billAttr.setContractParamPrefId(prefId);
            if (list.size() > 1 && ((String)list.get(1)).length() > CONTRACT_PARAM_PREF_MACROS_USE_SUPER.length() && ((String)list.get(1)).contains(CONTRACT_PARAM_PREF_MACROS_USE_SUPER)) {
                boolean useSuper = Utils.parseBoolean((String)((String)list.get(1)).substring(CONTRACT_PARAM_PREF_MACROS_USE_SUPER.length()), (boolean)false);
                billAttr.setUseSuperContract(useSuper);
            }
        }
        return billAttr;
    }
}

