/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.action;

import bitel.billing.server.ActionBase;
import java.io.ByteArrayInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.ProcessRegister;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.localize.Localizer;

public class ActionRevisePayments
extends ActionBase {
    public void doAction() throws Exception {
        String param = this.getParameter("param");
        String payments = this.getParameter("payments");
        String mpsId = this.getParameter("system");
        if (this.mid < 0 || mpsId == null) {
            throw new BGIllegalArgumentException();
        }
        if (param != null && payments != null && payments.length() > 0) {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(payments.getBytes("UTF-8"));
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(bis);
                MPSTransactionManager mpsTransactionManager = MPSTransactionManager.getInstance(mpsId, this.setup, this.mid);
                if ("add".equals(param)) {
                    mpsTransactionManager.reviseAddTransactions(this.con, this.mid, mpsId, this.setup, doc);
                } else if ("cancel".equals(param)) {
                    mpsTransactionManager.reviseCancelTransactions(this.con, this.mid, mpsId, doc);
                } else if ("restore".equals(param)) {
                    mpsTransactionManager.reviseRestoreTransactions(this.con, this.mid, mpsId, this.setup, doc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String fileName = this.getParameter("fileName");
            String file = this.getParameter("file");
            Calendar from = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("from"));
            Calendar until = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("until"));
            if (file == null || fileName == null || from == null || until == null) {
                throw new BGIllegalArgumentException();
            }
            try {
                ProcessRegister result = MPSTransactionManager.processRegister(mpsId, file, fileName, from, until, this.setup, this.con, this.mid);
                if (result != null) {
                    this.buildTable("sup_table", result.getList0());
                    this.buildTable("mis_table", result.getList1());
                    this.buildTable("can_table", result.getList2());
                    this.buildTable("dis_table", result.getList3());
                }
            }
            catch (BGException e) {
                throw new BGException(e.getMessage());
            }
        }
    }

    private void buildTable(String nodeName, List<Transaction> paymentList) {
        Element table = this.createElement(this.rootNode, nodeName);
        Element data = this.createElement(table, "data");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
        DecimalFormat df = new DecimalFormat("########0.00##", dfs);
        for (Transaction transaction : paymentList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(transaction.getId()));
            row.setAttribute("cid", String.valueOf(transaction.getContractId()));
            row.setAttribute("trans", transaction.getTransId());
            row.setAttribute("summ", df.format(transaction.getSum()));
            row.setAttribute("pid", String.valueOf(transaction.getPaymentId()));
            row.setAttribute("date", TimeUtils.format((Date)transaction.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("contract", transaction.getContractTitle());
            row.setAttribute("status", transaction.getStatus());
            row.setAttribute("rawNumber", transaction.getRawNumber());
            row.setAttribute("type", String.valueOf(transaction.getType()));
        }
    }
}

