/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class SetCache<E> {
    private final int maxSize;
    private final int maxSetSize;
    private volatile int count = 0;
    private final ConcurrentMap<Set<E>, Set<E>> cache;

    public SetCache(int maxSize) {
        this(maxSize, 4);
    }

    public SetCache(int maxSize, int maxSetSize) {
        this.maxSize = maxSize;
        this.maxSetSize = maxSetSize;
        this.cache = new ConcurrentHashMap<Set<E>, Set<E>>(Math.max(16, maxSize));
    }

    public Set<E> intern(Set<E> set) {
        if (set == null) {
            return set;
        }
        int size = set.size();
        if (set.size() > this.maxSetSize) {
            return set;
        }
        switch (size) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                Set result = (Set)this.cache.get(set);
                if (result != null) {
                    return result;
                }
                if (this.count < this.maxSize) {
                    Set newSet = Collections.singleton(set.stream().findFirst().get());
                    result = this.cache.putIfAbsent(newSet, newSet);
                    if (result == null) {
                        result = newSet;
                    } else {
                        assert (newSet.equals(set));
                        assert (newSet.hashCode() == set.hashCode());
                    }
                    this.count = this.cache.size();
                    return result;
                }
                return set;
            }
        }
        Set<E> result = (Set<E>)this.cache.get(set);
        if (result != null) {
            return result;
        }
        if (this.count < this.maxSize) {
            Set<E> newSet = Collections.unmodifiableSet(new CopyOnWriteArraySet<E>(set));
            result = this.cache.putIfAbsent(newSet, newSet);
            if (result == null) {
                result = newSet;
            } else {
                assert (newSet.equals(set));
                assert (newSet.hashCode() == set.hashCode());
            }
            this.count = this.cache.size();
            return result;
        }
        return set;
    }

    public int size() {
        return this.cache.size();
    }
}

