/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class PatternStringGenerator {
    public static String insertPatternPart(String srcString, String key, String value) {
        if (srcString != null && key != null) {
            String newKey = "${" + key + "}";
            String prefix = "";
            String suffix = "";
            int pos = srcString.indexOf(newKey);
            if (pos > -1) {
                int s = pos;
                while ((s = srcString.lastIndexOf(40, s)) > -1) {
                    if (s == 0 || srcString.charAt(s - 1) != '\\') {
                        prefix = srcString.substring(s, pos);
                        newKey = prefix + newKey;
                        break;
                    }
                    --s;
                }
                s = pos;
                while ((s = srcString.indexOf(41, s)) > -1) {
                    if (s == srcString.length() - 1 || srcString.charAt(s - 1) != '\\') {
                        suffix = srcString.substring(pos + ("${" + key + "}").length(), s + 1);
                        newKey = newKey + suffix;
                        break;
                    }
                    ++s;
                }
            }
            if ((prefix = prefix.replace("\\(", "(")).startsWith("(")) {
                prefix = prefix.substring(1);
            }
            if ((suffix = suffix.replace("\\)", ")")).endsWith(")")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            return srcString.replace(newKey, (CharSequence)(value != null ? prefix + value + suffix : ""));
        }
        return srcString;
    }

    public static String replacePatternPart(String srcString, String key, String value) {
        StringBuilder result = new StringBuilder(srcString.length());
        Pattern p = Pattern.compile("(([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\s\\[\\]\\(\\)\\\\/#]*)\\$\\{" + key + "\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\s\\[\\]\\(\\)\\\\/#]*))");
        Matcher m = p.matcher(srcString);
        if (m.find()) {
            if (Utils.notBlankString(value)) {
                result.append(srcString.substring(0, m.start()));
                String prefix = m.group(1);
                if (prefix.startsWith(",") && result.length() == 0) {
                    prefix = prefix.substring(1);
                }
                result.append(prefix);
                result.append(value);
                result.append(m.group(2));
                result.append(srcString.substring(m.end()));
            } else {
                result.append(srcString.substring(0, m.start()));
                result.append(srcString.substring(m.end()));
            }
        } else {
            result.append(srcString);
        }
        return result.toString();
    }
}

