/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.edo.client.ParamNestEditor;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.plugins.edo.common.service.SignatoryService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class ServiceConfigSignatory
extends BGUPanel {
    private BGUList<Signatory> signatoryList = new BGUList();
    private SignatoryEditor signatoryEditor = new SignatoryEditor();
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();

    public ServiceConfigSignatory() {
        JPanel emptyPanel = new JPanel(new GridBagLayout());
        emptyPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442\u0430"), new GridBagConstraints());
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)((Object)this.signatoryEditor), "editor");
        this.rightPanel.add((Component)emptyPanel, "empty");
        this.cardLayout.show(this.rightPanel, "empty");
        ClientUtils.addOpenAction(this.signatoryList, event -> this.performAction("edit"));
        ClientUtils.addShowCodeListener(this.signatoryList);
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(200);
        mainSplit.setLeftComponent(new JScrollPane((Component)this.signatoryList));
        mainSplit.setRightComponent(this.rightPanel);
        this.setLayout(new BorderLayout());
        this.add(mainSplit, "Center");
    }

    protected void jbInit() {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.signatoryList.setData(((SignatoryService)((ClientContext)this.getContext()).getPort(SignatoryService.class)).getSignatoryList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(0));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Signatory li = (Signatory)this.signatoryList.getSelectedValue();
            if (li != null) {
                this.startEdit(li.getId());
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Signatory li = (Signatory)this.signatoryList.getSelectedValue();
            if (li != null && ClientUtils.confirmDelete((Object)"\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442\u0430")) {
                ((SignatoryService)((ClientContext)this.getContext()).getPort(SignatoryService.class)).deleteSignatory(li.getId());
                this.hideEditor();
            }
        });
    }

    private void startEdit(int id) {
        this.signatoryEditor.setId(id);
        this.cardLayout.show(this.rightPanel, "editor");
        this.signatoryEditor.performAction("refresh");
    }

    public void hideEditor() {
        this.cardLayout.show(this.rightPanel, "empty");
        this.performAction("refresh");
    }

    class SignatoryEditor
    extends BGUPanel {
        private BGTextField fTitle = new BGTextField();
        private ParamNestEditor fConfig = new ParamNestEditor(Signatory.STATIC_FIELDS);
        private int id;

        public SignatoryEditor() {
            this.setLayout(new GridBagLayout());
            JButton okButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
            this.add(new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.fTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(new JScrollPane(this.fConfig), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add(okButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
            okButton.addActionListener(e -> ServiceConfigSignatory.this.performAction("ok"));
        }

        protected void jbInit() {
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                if (this.id > 0) {
                    Signatory signatory = ((SignatoryService)((ClientContext)this.getContext()).getPort(SignatoryService.class)).getSignatory(this.id);
                    this.fTitle.setText(signatory.getTitle());
                    this.fConfig.setConfigText(signatory.getConfig());
                } else {
                    this.fTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0442");
                    this.fConfig.setConfigText(null);
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Utils.isEmptyString((String)SignatoryEditor.this.fTitle.getText().trim())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a!");
                        return;
                    }
                    Signatory signatory = new Signatory();
                    signatory.setId(SignatoryEditor.this.id);
                    signatory.setTitle(SignatoryEditor.this.fTitle.getText());
                    signatory.setConfig(SignatoryEditor.this.fConfig.getConfigText());
                    ((SignatoryService)((ClientContext)SignatoryEditor.this.getContext()).getPort(SignatoryService.class)).updateSignatory(signatory);
                    ServiceConfigSignatory.this.hideEditor();
                }
            };
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

