/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffMasterDataParam;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractTariffMasterDataMode;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.TariffCounterPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVariablePanel;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ContractCommonTariff
extends BGUPanel {
    private int domainId = 0;
    private int tariffGroupId = 0;
    private JTextField tariffGroupTitle = new JTextField();
    private ContractCommonTariffTableModel tableModel = null;
    private TariffCounterPanel tariffCounterPanel = new TariffCounterPanel();
    private TariffVariablePanel tariffVariablePanel = new TariffVariablePanel();

    @Override
    protected void jbInit() throws Exception {
        this.tableModel = new ContractCommonTariffTableModel();
        final BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ContractCommonTariff.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(e) && table.getSelectedRow() == table.rowAtPoint(e.getPoint())) {
                    ContractCommonTariff.this.getPopupMenu().show(table, e.getX(), e.getY());
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ContractCommonTariff.this.tableModel.optSelectedRow().map(a -> a.getId()).filter(a -> a > 0).ifPresent(a -> {
                        ContractCommonTariff.this.tariffVariablePanel.showTariffVariables((int)a);
                        ContractCommonTariff.this.tariffCounterPanel.showTariffCounters((int)a);
                    });
                }
                if (e.getClickCount() == 2) {
                    ContractCommonTariff.this.performAction("edit");
                }
            }
        });
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, new JScrollPane(table), (Component)this.getTariffExtraPanel(), 500L);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTariffGroupPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffExtraPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)this.tariffVariablePanel, "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435");
        tabbedPane.add((Component)this.tariffCounterPanel, "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0438");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getTariffGroupPanel() {
        Font font = this.tariffGroupTitle.getFont();
        Color bgColor = this.tariffGroupTitle.getBackground();
        this.tariffGroupTitle.setEnabled(false);
        this.tariffGroupTitle.setBackground(bgColor);
        this.tariffGroupTitle.setHorizontalAlignment(0);
        this.tariffGroupTitle.setFont(new Font(font.getFamily(), 1, font.getSize()));
        JButton button = new JButton(ClientUtils.getIcon("edit"));
        button.addActionListener(e -> this.performAction("editTariffGroup"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffGroupTitle, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void getPopupMenuItems() {
        this.popupMenu.add("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444").addActionListener(e -> this.copyMenuItem(e));
        this.popupMenu.add("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444").addActionListener(e -> this.changeMenuItem(e));
        this.popupMenu.add("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0430\u0440\u0438\u0444 (\u0441\u0435\u0433\u043e\u0434\u043d\u044f)").addActionListener(e -> this.closeMenuItem(e));
    }

    private void copyMenuItem(ActionEvent e) {
        ContractTariff oldContractTariff = (ContractTariff)this.tableModel.getSelectedRow();
        if (oldContractTariff == null) {
            return;
        }
        this.tryCall(() -> {
            ContractTariffMaster contractTariffMaster = new ContractTariffMaster("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", ContractTariffMasterDataMode.COPY, new IdPeriod(oldContractTariff.getId()));
            contractTariffMaster.open();
            IdPeriod idPeriod = (IdPeriod)contractTariffMaster.getData();
            if (idPeriod.getId() > 0) {
                ContractTariffService contractTariffService = ((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0);
                Period newPeriod = idPeriod.getPeriod();
                if (newPeriod != null) {
                    LocalDate fromDate = newPeriod.getLocalDateFrom();
                    Period oldPeriod = oldContractTariff.getPeriod();
                    if (fromDate != null && (oldPeriod.getLocalDateFrom() == null || oldPeriod.getLocalDateFrom().isBefore(fromDate))) {
                        oldPeriod.setLocalDateTo(fromDate.minusDays(1L));
                        this.tryCall(() -> {
                            contractTariffService.contractTariffUpdate(oldContractTariff);
                            this.performAction("refresh");
                        });
                    }
                }
                for (ContractTariffVar contractTariffVar : contractTariffService.contractTariffVars(oldContractTariff.getId()).stream().filter(a -> a.getValue() != null).toList()) {
                    contractTariffVar.setContractTariffId(idPeriod.getId());
                    contractTariffService.contractTariffVarUpdate(contractTariffVar);
                }
            }
        });
    }

    private void changeMenuItem(ActionEvent e) {
        ContractTariff oldContractTariff = (ContractTariff)this.tableModel.getSelectedRow();
        if (oldContractTariff != null) {
            this.tryCall(() -> {
                Period newPeriod;
                ContractTariffMaster contractTariffMaster = new ContractTariffMaster("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", ContractTariffMasterDataMode.CHANGE, new IdPeriod(oldContractTariff.getId()));
                contractTariffMaster.open();
                IdPeriod idPeriod = (IdPeriod)contractTariffMaster.getData();
                if (idPeriod.getId() > 0 && (newPeriod = idPeriod.getPeriod()) != null) {
                    LocalDate fromDate = newPeriod.getLocalDateFrom();
                    Period oldPeriod = oldContractTariff.getPeriod();
                    if (fromDate != null && (oldPeriod.getLocalDateFrom() == null || oldPeriod.getLocalDateFrom().isBefore(fromDate))) {
                        oldPeriod.setLocalDateTo(fromDate.minusDays(1L));
                        this.tryCall(() -> {
                            ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffUpdate(oldContractTariff);
                            this.performAction("refresh");
                        });
                    }
                }
            });
        }
    }

    private void closeMenuItem(ActionEvent e) {
        Period period;
        ContractTariff contractTariff = (ContractTariff)this.tableModel.getSelectedRow();
        if (contractTariff != null && (period = contractTariff.getPeriod()) != null) {
            LocalDate now = LocalDate.now();
            if (period.getLocalDateFrom() == null || period.getLocalDateFrom().compareTo(now) < 1) {
                period.setLocalDateTo(now);
                this.tryCall(() -> {
                    ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffUpdate(contractTariff);
                    this.performAction("refresh");
                });
            } else {
                ClientUtils.showErrorMessageDialog("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0440\u0430\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u0430!");
            }
        }
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            TariffGroup tariffGroup;
            int contractId = ((ClientContext)this.getContext()).getContractId();
            Contract contract = ((ClientContext)this.getContext()).getWebService(ContractService.class).contractGet(contractId);
            this.domainId = contract != null ? contract.getDomainId() : 0;
            this.tariffGroupId = 0;
            String title = "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
            ContractTariffGroup contractTariffGroup = ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffGroupGet(contractId);
            if (contractTariffGroup != null && (tariffGroup = ((ClientContext)this.getContext()).getDirectory(TariffGroup.class).get(contractTariffGroup.getTariffGroupId())) != null) {
                title = tariffGroup.getTitle();
                this.tariffGroupId = contractTariffGroup.getTariffGroupId();
            }
            this.tariffGroupTitle.setText(title);
            this.tableModel.setData(((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffList(contractId, null, 0, 0));
        }).setIcon(ClientUtils.getIcon("refresh"));
        new AbstractBGUPanel.BGActionNew(e -> new ContractTariffMaster("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", ContractTariffMasterDataMode.NEW, new IdPeriod(0)).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.tableModel.optSelectedRow().ifPresentOrElse(a -> new ContractTariffMaster("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", ContractTariffMasterDataMode.EDIT, new IdPeriod(a.getId())).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            ContractTariff contractTariff = (ContractTariff)this.tableModel.getSelectedRow();
            if (contractTariff != null) {
                if (ClientUtils.confirm("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                    this.tryCall(() -> {
                        ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffDelete(contractTariff.getId());
                        this.tariffVariablePanel.clearContractTariffVars();
                        this.tariffVariablePanel.doFilterTariffVariables();
                        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                    });
                }
                this.performAction("refresh");
            }
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("editTariffGroup", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0442\u0430\u0440\u0438\u0444\u043e\u0432", e -> this.getContractTariffGroupDialog().setVisible(true));
    }

    private JDialog getContractTariffGroupDialog() {
        BGUList tariffGroups = new BGUList();
        tariffGroups.setSelectionMode(0);
        this.tryCall(() -> {
            ArrayList listData = new ArrayList();
            ((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffGroupList(((ClientContext)this.getContext()).getContractId()).stream().filter(t -> t.getId() != -1).filter(t -> t.getDomainId() == 0 || t.getDomainId() == this.domainId).forEach(g -> listData.add(g.toIdTitle()));
            tariffGroups.setData(listData);
            for (IdTitle idTitle : listData) {
                if (idTitle.getId() != this.tariffGroupId) continue;
                tariffGroups.setSelectedValue(idTitle, true);
                break;
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(tariffGroups, 500, 250), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0412\u044b\u0431\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            IdTitle idTitle = (IdTitle)tariffGroups.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0413\u0440\u0443\u043f\u043f\u0443 \u0442\u0430\u0440\u0438\u0444\u043e\u0432\"!");
                return;
            }
            this.tryCall(() -> {
                ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).contractTariffGroupSet(((ClientContext)this.getContext()).getContractId(), idTitle.getId());
                this.tariffGroupId = idTitle.getId();
                this.tariffGroupTitle.setText(idTitle.getTitle());
                dialog.setVisible(false);
                dialog.dispose();
            });
        });
        return dialog;
    }

    class ContractCommonTariffTableModel
    extends BGTableModel<ContractTariff> {
        private Directory<TariffGroup> tariffGroupDirectory;
        private Directory<TariffPlan> tariffPlanDirectory;

        public ContractCommonTariffTableModel() {
            super(ContractCommonTariff.class.getName());
            this.tariffGroupDirectory = null;
            this.tariffPlanDirectory = null;
            ContractCommonTariff.this.tryCall(() -> {
                this.tariffPlanDirectory = ((ClientContext)ContractCommonTariff.this.getContext()).getDirectory(TariffPlan.class);
                this.tariffGroupDirectory = ((ClientContext)ContractCommonTariff.this.getContext()).getDirectory(TariffGroup.class);
            });
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u041f#ID", 0, 50, 50, "tariffPlanId", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u043e\u0437.", 50, 50, 50, "position", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 250, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432", 100, 150, -1, "tariffGroupId", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", 180, 180, 180, "period", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(ContractTariff contractTariff, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                TariffPlan tariffPlan = this.tariffPlanDirectory.get(contractTariff.getTariffPlanId());
                return tariffPlan != null ? tariffPlan.getTitle() : "<\u0422\u0410\u0420\u0418\u0424 \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d>";
            }
            if ("tariffGroupId".equals(identifier)) {
                int tariffGroupId = contractTariff.getTariffGroupId();
                switch (tariffGroupId) {
                    case -1: {
                        return "<\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e>";
                    }
                    case 0: {
                        return "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
                    }
                }
                TariffGroup tariffGroup = this.tariffGroupDirectory.get(tariffGroupId);
                return tariffGroup == null ? "#" + tariffGroupId : tariffGroup.getTitle();
            }
            return super.getValue(contractTariff, column);
        }
    }

    public class ContractTariffMaster
    extends BGEditorDialog<IdPeriod> {
        private ContractTariffMasterData masterData;
        private ContractTariffMasterDataMode masterDataMode;
        private BGUList<IdTitle> tariffPlans;
        private BGTextArea tariffComment;
        private BGUComboBoxRefresh<KeyValue> tariffFilter;
        private ContractTariffMasterTableModel tableModel;
        private RowData tariffGroup;
        private RowData tariffPeriodFrom;
        private RowData tariffPeriodTo;
        private RowData tariffPosition;

        public ContractTariffMaster(String title, ContractTariffMasterDataMode masterDataMode, IdPeriod data) {
            super(title, data);
            this.masterData = null;
            this.tariffPlans = new BGUList();
            this.tariffComment = new BGTextArea(2, 20);
            this.tariffFilter = new BGUComboBoxRefresh();
            this.tableModel = new ContractTariffMasterTableModel();
            this.tariffGroup = new RowData(this, "tariff.group", "\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432");
            this.tariffPeriodFrom = new RowData(this, "tariff.period.from", "\u041f\u0435\u0440\u0438\u043e\u0434 (\u0441)");
            this.tariffPeriodTo = new RowData(this, "tariff.period.to", "\u041f\u0435\u0440\u0438\u043e\u0434 (\u043f\u043e)");
            this.tariffPosition = new RowData(this, "tariff.position", "\u041f\u043e\u0437\u0438\u0446\u0438\u044f");
            this.masterDataMode = masterDataMode;
        }

        @Override
        public void doDialogPanel() {
            final BGUTable table = new BGUTable(this.tableModel);
            table.setSelectionMode(0);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RowData rowData;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (rowData = (RowData)ContractTariffMaster.this.tableModel.getSelectedRow()) != null) {
                        if (rowData == ContractTariffMaster.this.tariffPeriodFrom || rowData == ContractTariffMaster.this.tariffPeriodTo) {
                            ContractTariffMaster.this.showDatePopup(table, rowData, e.getX(), e.getY());
                        } else if (rowData == ContractTariffMaster.this.tariffGroup) {
                            ContractTariffMaster.this.showListPopup(table, rowData, e.getX(), e.getY());
                        } else if (rowData == ContractTariffMaster.this.tariffPosition) {
                            ContractTariffMaster.this.showPositionPopup(table, rowData, e.getX(), e.getY());
                        }
                    }
                }
            });
            this.panel.add((Component)this.getLabelFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.tariffPlans, 700, 200), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 700, 100), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.tariffComment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.setData();
        }

        private void setData() {
            this.tryCall(() -> {
                ContractTariffMasterDataParam param = new ContractTariffMasterDataParam().setContractId(((ClientContext)ContractCommonTariff.this.getContext()).getContractId()).setMode(this.masterDataMode).setFilterKey(this.tariffFilter.getSelectedItem().getKey()).setContractTariffId(((IdPeriod)this.data).getId());
                this.masterData = ((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffMasterDataGet(param);
            });
            this.tariffPlans.setData(this.masterData.getTariffs());
            this.tariffPlans.setSelectedId(this.masterData.getContractTariff().getTariffPlanId(), true);
            this.tariffGroup.setValue(this.masterData.getContractTariff().getTariffGroupId());
            this.tariffPeriodFrom.setValue(this.masterData.getContractTariff().getPeriod().getDateFrom());
            this.tariffPeriodTo.setValue(this.masterData.getContractTariff().getPeriod().getDateTo());
            this.tariffPosition.setValue(this.masterData.getContractTariff().getPosition());
            this.tariffComment.setText(this.masterData.getContractTariff().getComment());
            this.tariffComment.setEditable(this.masterData.isEditComment());
            ArrayList<RowData> rowDatas = new ArrayList<RowData>();
            if (this.masterData.isEditGroup()) {
                rowDatas.add(this.tariffGroup);
            }
            if (this.masterData.isEditPeriodFrom()) {
                rowDatas.add(this.tariffPeriodFrom);
            }
            if (this.masterData.isEditPeriodTo()) {
                rowDatas.add(this.tariffPeriodTo);
            }
            if (this.masterData.isEditPosition()) {
                rowDatas.add(this.tariffPosition);
            }
            this.tableModel.setData(rowDatas);
        }

        private JPanel getLabelFilterPanel() {
            this.tariffFilter.setSupplier(() -> ((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffMasterFilters(null));
            this.tariffFilter.refresh();
            this.tariffFilter.setSelectedIndex(0);
            BGSwingUtilites.comboBoxSelectKeyValue(this.tariffFilter, e -> this.setData());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444\u044b:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.tariffFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void showDatePopup(BGUTable table, RowData rowData, int x, int y) {
            JPopupMenu popup = new JPopupMenu();
            CalendarPanel calendarPanel = new CalendarPanel();
            calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            calendarPanel.setCalendar(TimeUtils.convertDateToCalendar((Date)rowData.getValue()));
            calendarPanel.addPropertyChangeListener(e1 -> {
                String propertyName = e1.getPropertyName();
                if ("updateCalendar".equals(propertyName)) {
                    rowData.setValue(Optional.ofNullable(calendarPanel.getCalendar()).map(a -> a.getTime()).orElse(null));
                    popup.setVisible(false);
                }
            });
            popup.add(calendarPanel);
            popup.show(table, x, y);
        }

        private void showListPopup(BGUTable table, RowData rowData, int x, int y) {
            JPopupMenu popup = new JPopupMenu();
            BGUList<IdTitle> list = new BGUList<IdTitle>();
            list.setSelectionMode(0);
            list.setData(this.masterData.getTariffGroups());
            BGButton buttonOk = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
            buttonOk.addActionListener(e -> {
                list.optSelectedValue().ifPresent(a -> rowData.setValue(a.getId()));
                popup.setVisible(false);
            });
            BGButton buttonCancel = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0430");
            buttonCancel.addActionListener(e -> popup.setVisible(false));
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 10, 0));
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            buttonPanel.add(buttonOk);
            buttonPanel.add(buttonCancel);
            JScrollPane scrollPane = BGSwingUtilites.wrapScrollPane(list, 500, 200);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)scrollPane, "Center");
            panel.add((Component)buttonPanel, "South");
            popup.add(panel);
            popup.show(table, x, y);
        }

        private void showPositionPopup(BGUTable table, RowData rowData, int x, int y) {
            JPopupMenu popup = new JPopupMenu();
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            BGButton buttonCancel = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0430");
            buttonCancel.addActionListener(e -> popup.setVisible(false));
            ActionListener listener = e -> {
                rowData.setValue(Utils.parseInt(e.getActionCommand()));
                popup.setVisible(false);
            };
            for (int i = 0; i < 10; ++i) {
                BGButton button = new BGButton(String.valueOf(i));
                button.setActionCommand(String.valueOf(i));
                button.addActionListener(listener);
                buttonPanel.add(button);
            }
            buttonPanel.add(buttonCancel);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)buttonPanel, "South");
            popup.add(panel);
            popup.show(table, x, y);
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle idTitle = (IdTitle)this.tariffPlans.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444!");
                return false;
            }
            ContractTariff contractTariff = this.masterData.getContractTariff().setTariffPlanId(idTitle.getId()).setTariffGroupId((Integer)this.tariffGroup.getValue()).setPeriod(new Period((Date)this.tariffPeriodFrom.getValue(), (Date)this.tariffPeriodTo.getValue())).setPosition((Integer)this.tariffPosition.getValue()).setComment(this.tariffComment.getText());
            contractTariff.setId(((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffUpdate(contractTariff));
            ((IdPeriod)this.data).setId(contractTariff.getId());
            ((IdPeriod)this.data).setPeriod(contractTariff.getPeriod());
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ContractCommonTariff.this.getContext()).getContractId()));
            ContractCommonTariff.this.performAction("refresh");
            return true;
        }

        class ContractTariffMasterTableModel
        extends BGTableModel<RowData> {
            public ContractTariffMasterTableModel() {
                super(ContractTariffMasterTableModel.class.getName());
            }

            @Override
            protected void initColumns() {
                this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 150, 150, 150, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", false, HorizontalAlignmentTableCellRenderer.LEFT());
            }

            @Override
            public Object getValue(RowData val, int column) throws Exception {
                String identifier = this.getIdentifier(column);
                if ("value".equals(identifier)) {
                    if (val == ContractTariffMaster.this.tariffPeriodFrom || val == ContractTariffMaster.this.tariffPeriodTo) {
                        return TimeUtils.format((Date)val.getValue(), "dd.MM.yyyy");
                    }
                    if (val == ContractTariffMaster.this.tariffGroup) {
                        return ContractTariffMaster.this.masterData.getTariffGroups().stream().filter(a -> a.getId() == ((Integer)ContractTariffMaster.this.tariffGroup.getValue()).intValue()).findFirst().map(a -> a.getTitle()).orElse("??? [#" + (Integer)ContractTariffMaster.this.tariffGroup.getValue() + "]");
                    }
                }
                return super.getValue(val, column);
            }
        }

        public class RowData {
            private String key = null;
            private Object value = null;
            private String title = null;

            public RowData(ContractTariffMaster this$1, String key, String title) {
                this.key = key;
                this.title = title;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object value) {
                this.value = value;
            }

            public String getKey() {
                return this.key;
            }

            public String getTitle() {
                return this.title;
            }
        }
    }

    private static class IdPeriod {
        private int id;
        private Period period;

        IdPeriod(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Period getPeriod() {
            return this.period;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setPeriod(Period period) {
            this.period = period;
        }
    }

    public class ContractTariffDialog
    extends BGEditorDialog<ContractTariff> {
        private BGTextArea tariffComment;
        private JTextField tariffPosition;
        private JCheckBox showUsed;
        private JCheckBox contractFilter;
        private BGUList<IdTitle> filterModules;
        private BGUList<IdTitle> filterTariffGroup;
        private BGUList<IdTitle> tariffPlans;
        private BGUComboBox<IdTitle> tariffGroup;
        private BGControlPanelPeriodNoB periodPanel;

        public ContractTariffDialog(String title, ContractTariff data) {
            super(title, data);
            this.tariffComment = new BGTextArea(7, 20);
            this.tariffPosition = new JTextField(10);
            this.showUsed = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
            this.contractFilter = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
            this.filterModules = new BGUList();
            this.filterTariffGroup = new BGUList();
            this.tariffPlans = new BGUList();
            this.tariffGroup = new BGUComboBox();
            this.periodPanel = new BGControlPanelPeriodNoB();
        }

        @Override
        public void doDialogPanel() {
            int gridy = 0;
            JPanel tariffParamPanel = new JPanel(new GridBagLayout());
            tariffParamPanel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)this.tariffPosition, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)this.periodPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JScrollPane(this.tariffComment), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            int gridx = 0;
            JPanel tariffPanel = new JPanel(new GridBagLayout());
            tariffPanel.add((Component)this.getTariffFilterPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            tariffPanel.add((Component)this.getTariffListPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            tariffPanel.add((Component)tariffParamPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)tariffPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.tariffPosition.setHorizontalAlignment(0);
            this.tariffPosition.setText(String.valueOf(((ContractTariff)this.data).getPosition()));
            this.periodPanel.setPeriod(((ContractTariff)this.data).getPeriod());
            this.tariffComment.setText(((ContractTariff)this.data).getComment());
            for (int index = 0; index < this.tariffGroup.getItemCount(); ++index) {
                if (((IdTitle)this.tariffGroup.getItemAt(index)).getId() != ((ContractTariff)this.data).getTariffGroupId()) continue;
                this.tariffGroup.setSelectedIndex(index);
                break;
            }
            this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
        }

        private JPanel getTariffFilterPanel() {
            this.tariffPlans.setSelectionMode(0);
            this.contractFilter.setSelected(true);
            this.showUsed.setSelected(true);
            ChangeListener changeListener = e -> this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
            this.showUsed.addChangeListener(changeListener);
            this.contractFilter.addChangeListener(changeListener);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)this.getFilterByGroup(), "\u043f\u043e \u0433\u0440\u0443\u043f\u043f\u0435 \u0442\u0430\u0440\u0438\u0444\u043e\u0432");
            tabbedPane.add((Component)this.getFilterByModule(), "\u043f\u043e \u043c\u043e\u0434\u0443\u043b\u044e");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440 \u0442\u0430\u0440\u0438\u0444\u043e\u0432"));
            panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.showUsed, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.contractFilter, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFilterByModule() {
            ArrayList<IdTitle> listData = new ArrayList<IdTitle>();
            listData.add(new IdTitle(-1, "\u041b\u044e\u0431\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c"));
            this.tryCall(() -> {
                ContractTariffService contractTariffService = ((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class, 0);
                listData.addAll(contractTariffService.contractTariffModuleList(((ContractTariff)this.data).getContractId()));
                this.filterModules.setData(listData);
            });
            this.filterModules.setSelectionMode(0);
            this.filterModules.setSelectedIndex(0);
            this.filterModules.addListSelectionListener(e -> this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.filterModules, 270, 150), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFilterByGroup() {
            this.filterTariffGroup.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.filterTariffGroup, 270, 150), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getTariffListPanel() {
            this.tryCall(() -> {
                ArrayList<Object> tariffGroups = new ArrayList<IdTitle>();
                tariffGroups.addAll(((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffGroupList(((ContractTariff)this.data).getContractId()).stream().map(g -> new IdTitle(g.getId(), g.getTitle())).toList());
                this.tariffGroup.setData(tariffGroups);
                tariffGroups = new ArrayList<IdTitle>(tariffGroups.stream().filter(a -> a.getId() > 0).toList());
                tariffGroups.add(0, new IdTitle(0, "<\u0432\u0441\u0435 \u0442\u0430\u0440\u0438\u0444\u044b>"));
                this.filterTariffGroup.setData(tariffGroups);
                if (!((DefaultListModel)this.filterTariffGroup.getModel()).isEmpty()) {
                    ClientUtils.setListSelection(this.filterTariffGroup, ContractCommonTariff.this.tariffGroupId, -1);
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.tariffPlans, 500, 300), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add(this.tariffGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private void setTariffList(int tariffPlanId, JCheckBox showUsed, JCheckBox useFilter) {
            this.tryCall(() -> {
                IdTitle idTitle = (IdTitle)this.filterModules.getSelectedValue();
                int moduleId = idTitle == null ? -1 : idTitle.getId();
                int tariffGroupId = this.filterTariffGroup.optSelectedValue().map(a -> a.getId()).orElse(-2);
                List<IdTitle> items = ((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffListByParam(((ClientContext)ContractCommonTariff.this.getContext()).getContractId(), tariffPlanId, moduleId, showUsed.isSelected(), useFilter.isSelected(), tariffGroupId);
                this.tariffPlans.setData(items);
                for (IdTitle item : items) {
                    if (item.getId() != tariffPlanId) continue;
                    this.tariffPlans.setSelectedValue(item, true);
                    break;
                }
            });
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle idTitle = (IdTitle)this.tariffPlans.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444!");
                return false;
            }
            return this.tryCallBoolean(() -> {
                ((ContractTariff)this.data).setTariffPlanId(idTitle.getId());
                ((ContractTariff)this.data).setTariffGroupId(((IdTitle)this.tariffGroup.getSelectedItem()).getId());
                ((ContractTariff)this.data).setPosition(Utils.parseInt(this.tariffPosition.getText(), 0));
                ((ContractTariff)this.data).setPeriod(this.periodPanel.getPeriod());
                ((ContractTariff)this.data).setComment(this.tariffComment.getText());
                ((ContractTariff)this.data).setId(((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class).contractTariffUpdate((ContractTariff)this.data));
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ContractCommonTariff.this.getContext()).getContractId()));
                ContractCommonTariff.this.performAction("refresh");
            });
        }
    }
}

