/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstactHourLogProccessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.ProcessUtil;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLog;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.RangeListMap;
import ru.bitel.common.util.Ranger;

public class RadiusHourLogProcessor
extends AbstactHourLogProccessor {
    private RangeListMap<String, InetSessionLog, Date> acctSesssionLogMap;
    final long SESSION_DELTA = 600000L;
    protected final Date day;
    List<Date> hours = new ArrayList<Date>();
    private static final Logger logger = LogManager.getLogger();
    private Map<Long, Map<Integer, Long>> zeroTrafficsAmountMap = new HashMap<Long, Map<Integer, Long>>();
    private Map<Long, Map<Integer, Long>> connectionAbsoluteAmountMap = new HashMap<Long, Map<Integer, Long>>();
    private Set<Long> affectedZeroSessions = new HashSet<Long>();
    protected Map<Integer, InetServ> servMap = new HashMap<Integer, InetServ>();
    protected int moduleId;

    public RadiusHourLogProcessor(Date day, Accounting accounting, int deviceId) {
        super(day, accounting, deviceId);
        this.day = day;
        this.moduleId = accounting.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    @Override
    public void init(Connection con) throws BGException {
        try (InetSessionLogDao sessionLogDao = new InetSessionLogDao(con, this.moduleId, this.day);){
            boolean isCurrentDay;
            HashSet<Integer> deviceIds = new HashSet<Integer>();
            deviceIds.add(this.deviceId);
            Date dateFrom = this.day;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.day);
            ((Calendar)cal).add(5, 1);
            Date dateTo = cal.getTime();
            this.sessions = sessionLogDao.list(deviceIds, dateFrom, dateTo);
            InetSessionDao sessionDao = new InetSessionDao(con, this.accounting.moduleId);
            Date now = new Date();
            int daylDelta = TimeUtils.daysDelta((Date)now, (Date)this.day);
            boolean bl = isCurrentDay = daylDelta == 0;
            if (isCurrentDay) {
                try (InetServTypeDao inetServTypeDao = new InetServTypeDao(con, this.accounting.moduleId);){
                    this.currentSessions = sessionDao.listAsLog(inetServTypeDao.list(), deviceIds, null, null, null, dateFrom, dateTo, null, 0, 0, false);
                }
            }
            HashSet<Integer> servIds = new HashSet<Integer>();
            for (InetSessionLog session : this.sessions) {
                servIds.add(session.getServId());
            }
            for (InetSessionLog session : this.currentSessions) {
                servIds.add(session.getServId());
                this.currentSessionSet.add(session.getId());
            }
            try (InetServDao servDao = new InetServDao(con, this.moduleId);){
                List<InetServ> servList = servDao.list(servIds);
                for (InetServ serv : servList) {
                    this.servMap.put(serv.getId(), serv);
                }
            }
            this.acctSesssionLogMap = new RangeListMap((Ranger)new Ranger<InetSessionLog, Date>(this){

                public Date getMinValue(InetSessionLog r) {
                    return r.getSessionStart();
                }

                public Date getMaxValue(InetSessionLog r) {
                    return r.getSessionStop();
                }
            }, 8);
            for (InetSessionLog session : this.sessions) {
                this.acctSesssionLogMap.add((Object)session.getAcctSessionId(), (Object)session);
            }
            for (InetSessionLog session : this.currentSessions) {
                this.acctSesssionLogMap.add((Object)session.getAcctSessionId(), (Object)session);
            }
            this.initZeroTrafficsAmountMap(con);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Override
    public void getAmountsFromLogs(ConnectionSet connectionSet, Date hour) throws BGException {
        try {
            this.sessionHourAmountMap.clear();
            HashMap<Long, Map<Integer, Pair<Long, Long>>> hourFirstPacketTime = new HashMap<Long, Map<Integer, Pair<Long, Long>>>();
            HashMap<Long, Map<Integer, Pair<Long, Long>>> hourLastPacketTime = new HashMap<Long, Map<Integer, Pair<Long, Long>>>();
            this.readDataFromLogs(connectionSet, hour, hourFirstPacketTime, hourLastPacketTime);
            this.processData(connectionSet.getConnection(), hour, hourFirstPacketTime, hourLastPacketTime);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new BGException((Throwable)e);
        }
    }

    protected void processData(Connection con, Date hour, Map<Long, Map<Integer, Pair<Long, Long>>> firstPacketTime, Map<Long, Map<Integer, Pair<Long, Long>>> lastPacketTime) throws SQLException {
        InetSessionLog session;
        Calendar cal = TimeUtils.convertDateToCalendar((Date)hour);
        cal.add(11, 1);
        Date nextHour = cal.getTime();
        Iterator iterator = this.sessions.iterator();
        while (iterator.hasNext() && (session = (InetSessionLog)iterator.next()).getSessionStart().compareTo(nextHour) < 0) {
            this.processSession(con, session, hour, firstPacketTime, lastPacketTime);
        }
        iterator = this.currentSessions.iterator();
        while (iterator.hasNext() && (session = (InetSessionLog)iterator.next()).getSessionStart().compareTo(nextHour) < 0) {
            this.processSession(con, session, hour, firstPacketTime, lastPacketTime);
        }
    }

    private void processSession(Connection con, InetSessionLog session, Date hour, Map<Long, Map<Integer, Pair<Long, Long>>> firstPacketTime, Map<Long, Map<Integer, Pair<Long, Long>>> lastPacketTime) throws SQLException {
        Map<Integer, Pair<Long, Long>> lastPacket;
        HashMap<Integer, Long> hourTraffics;
        long sessionId = session.getId();
        Map<Integer, Long> zeroTraffics = this.zeroTrafficsAmountMap.get(sessionId);
        if (zeroTraffics == null) {
            zeroTraffics = new HashMap<Integer, Long>();
        }
        if ((hourTraffics = (HashMap<Integer, Long>)this.sessionHourAmountMap.get(sessionId)) == null) {
            hourTraffics = new HashMap<Integer, Long>();
            this.sessionHourAmountMap.put(sessionId, hourTraffics);
        }
        long connectionId = session.getConnectionId();
        Map<Integer, Long> connectionTraffics = this.connectionAbsoluteAmountMap.get(connectionId);
        int type = session.getType();
        if ((type & 2) > 0 || (type & 1) > 0) {
            Calendar hourCal = TimeUtils.convertDateToCalendar((Date)hour);
            Calendar startCal = TimeUtils.convertDateToCalendar((Date)session.getSessionStart());
            if (hourCal.get(11) == startCal.get(11)) {
                if ((type & 2) > 0) {
                    if (connectionTraffics != null) {
                        this.flushZeroTraffics(con, sessionId, connectionTraffics);
                    }
                } else if ((type & 1) > 0) {
                    connectionTraffics = new HashMap<Integer, Long>();
                    Map<Integer, Pair<Long, Long>> firstPacket = firstPacketTime.get(sessionId);
                    for (Map.Entry<Integer, Pair<Long, Long>> entry : firstPacket.entrySet()) {
                        int traffTypeId = entry.getKey();
                        long value = (Long)entry.getValue().getSecond();
                        connectionTraffics.put(traffTypeId, value);
                    }
                    this.flushZeroTraffics(con, sessionId, connectionTraffics);
                }
            }
        }
        if (connectionTraffics == null) {
            connectionTraffics = new HashMap<Integer, Long>();
            this.connectionAbsoluteAmountMap.put(connectionId, connectionTraffics);
        }
        if ((lastPacket = lastPacketTime.get(sessionId)) == null) {
            return;
        }
        for (Map.Entry<Integer, Pair<Long, Long>> entry : lastPacket.entrySet()) {
            long oldValue;
            int traffTypeId = entry.getKey();
            long value = (Long)entry.getValue().getSecond();
            if (value == 0L) continue;
            long l = oldValue = connectionTraffics.get(traffTypeId) != null ? connectionTraffics.get(traffTypeId) : 0L;
            if (oldValue == 0L) {
                oldValue = zeroTraffics.get(traffTypeId) != null ? zeroTraffics.get(traffTypeId) : 0L;
            }
            connectionTraffics.put(traffTypeId, value);
            long delta = value - oldValue;
            if (value > 0L && oldValue > 0L && oldValue > value) {
                delta = oldValue;
            }
            hourTraffics.put(traffTypeId, delta);
        }
    }

    protected void flushZeroTraffics(Connection con, long sessionId, Map<Integer, Long> conLocalMap) throws SQLException {
        String sessionDetailLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)this.day, (int)this.moduleId);
        String sessionDetailTableName = ServerUtils.getModuleTableName((String)"inet_session_detail", (int)this.moduleId);
        String insertPattern = "INSERT INTO detailTable SET sessionId = ?, day = 0, hour = 0, trafficTypeId = ?, amount = ?, deviceId = 0  ";
        String deletePattern = "DELETE FROM detailTable  WHERE  sessionId = ? AND day = 0 AND hour = 0 AND trafficTypeId > 0";
        PreparedStatement insertDetailLogPs = con.prepareStatement(insertPattern.replace("detailTable", sessionDetailLogTableName));
        PreparedStatement insertDetailPs = con.prepareStatement(insertPattern.replace("detailTable", sessionDetailTableName));
        PreparedStatement deleteDetailLogPs = con.prepareStatement(deletePattern.replace("detailTable", sessionDetailLogTableName));
        PreparedStatement deleteDetailPs = con.prepareStatement(deletePattern.replace("detailTable", sessionDetailTableName));
        PreparedStatement insertPs = this.currentSessionSet.contains(sessionId) ? insertDetailPs : insertDetailLogPs;
        PreparedStatement deletePs = this.currentSessionSet.contains(sessionId) ? deleteDetailPs : deleteDetailLogPs;
        deletePs.setLong(1, sessionId);
        deletePs.executeUpdate();
        for (Map.Entry<Integer, Long> entry : conLocalMap.entrySet()) {
            int traffTypeId = entry.getKey();
            long amount = entry.getValue();
            insertPs.setLong(1, sessionId);
            insertPs.setLong(2, traffTypeId);
            insertPs.setLong(3, amount);
            insertPs.executeUpdate();
        }
        this.affectedZeroSessions.add(sessionId);
        insertDetailPs.close();
        insertDetailLogPs.close();
        deleteDetailPs.close();
        deleteDetailLogPs.close();
    }

    public void readDataFromLogs(ConnectionSet connectionSet, Date hour, Map<Long, Map<Integer, Pair<Long, Long>>> firstPacketTime, Map<Long, Map<Integer, Pair<Long, Long>>> lastPacketTime) throws BGException {
        try {
            HourlyDataLogger dataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("radiusDataLogger");
            dataLogger.flush(InetUtils.getHour(hour.getTime())).get(3L, TimeUnit.SECONDS);
        }
        catch (Exception dataLogger) {
            // empty catch block
        }
        int zoneDelta = ProcessUtil.getZoneDelta(this.setup, hour, this.accounting.moduleId);
        ArrayList<RadiusHourlyDataLog> logs = new ArrayList<RadiusHourlyDataLog>();
        logs.add(new RadiusHourlyDataLog((DefaultServerSetup)this.setup, this.deviceId, TimeUtils.convertDateToCalendar((Date)hour)));
        String prefix = "datalog.remote.radius.dir.";
        ParameterMap subMap = this.setup.sub(prefix);
        for (Map.Entry entry : subMap.entrySet()) {
            logs.add(new RadiusHourlyDataLog((DefaultServerSetup)this.setup, prefix + (String)entry.getKey(), this.deviceId, TimeUtils.convertDateToCalendar((Date)hour)));
        }
        InetDeviceRuntime deviceRuntime = this.accounting.deviceMap.get(this.deviceId);
        RadiusPacket response = new RadiusPacket(40, 0);
        for (RadiusHourlyDataLog dataLog : logs) {
            try {
                RadiusDataLogReader radiusReader;
                while ((radiusReader = (RadiusDataLogReader)dataLog.nextReader(null, true)) != null) {
                    RadiusPacket packet;
                    long[] millisArr = new long[1];
                    while ((packet = radiusReader.read(millisArr)) != null) {
                        long millis = millisArr[0] + (long)zoneDelta;
                        if (deviceRuntime.protocolHandler != null) {
                            deviceRuntime.protocolHandler.preprocessAccountingRequest(packet, response, connectionSet);
                        }
                        String acctSessionId = packet.getStringAttribute(-1, 44, null);
                        int acctStatusType = packet.getIntAttribute(-1, 40, Integer.valueOf(-10));
                        if (acctStatusType == 1) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("start packet " + acctSessionId + " was ignored");
                            continue;
                        }
                        InetSessionLog session = (InetSessionLog)this.acctSesssionLogMap.get((Object)acctSessionId, (Comparable)new Date(millis));
                        if (session == null) {
                            session = (InetSessionLog)this.acctSesssionLogMap.getLastIntersects((Object)acctSessionId, (Comparable)new Date(millis - 600000L), (Comparable)new Date(millis));
                        }
                        if (session != null) {
                            TrafficTypeLinkRuntime link = this.getLinkForSession(session);
                            if (link != null) {
                                Map<Integer, Pair<Long, Long>> maxMap;
                                String realm = session.getRealm();
                                String acctService = session.getParentConnectionId() > 0L ? session.getUsername() : null;
                                Map<Integer, AccountingTrafficAmount> counterTraffics = InetUtils.getCounterTraffics(link, packet, realm, acctService);
                                Map<Integer, Pair<Long, Long>> minMap = firstPacketTime.get(session.getId());
                                if (minMap == null) {
                                    minMap = new HashMap<Integer, Pair<Long, Long>>();
                                    firstPacketTime.put(session.getId(), minMap);
                                }
                                if ((maxMap = lastPacketTime.get(session.getId())) == null) {
                                    maxMap = new HashMap<Integer, Pair<Long, Long>>();
                                    lastPacketTime.put(session.getId(), maxMap);
                                }
                                for (Map.Entry<Integer, AccountingTrafficAmount> entry : counterTraffics.entrySet()) {
                                    Integer typeId = entry.getKey();
                                    AccountingTrafficAmount amount = entry.getValue();
                                    if (amount.amount == 0L) continue;
                                    Pair pair = minMap.get(typeId);
                                    if (pair == null || millis < (Long)pair.getFirst()) {
                                        pair = new Pair((Object)millis, (Object)amount.amount);
                                        minMap.put(typeId, pair);
                                    }
                                    if ((pair = maxMap.get(typeId)) != null && millis <= (Long)pair.getFirst()) continue;
                                    pair = new Pair((Object)millis, (Object)amount.amount);
                                    maxMap.put(typeId, (Pair<Long, Long>)pair);
                                }
                                continue;
                            }
                            logger.error("TrafficTypeLinkRuntime was not found for session with id = " + session.getId());
                            continue;
                        }
                        logger.error("session was not found for packet with millis = " + String.valueOf(new Date(millis)) + "  in hour " + String.valueOf(hour) + " with acctSessionId = " + acctSessionId);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new BGException((Throwable)ex);
            }
            finally {
                dataLog.close();
            }
        }
    }

    protected Map<Long, Map<Integer, Long>> initZeroTrafficsAmountMap(Connection con) throws SQLException {
        String sessionDetailLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)this.day, (int)this.moduleId);
        String sessionLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)this.day, (int)this.moduleId);
        this.initZeroTrafficsInternal(sessionDetailLogTableName, sessionLogTableName, con);
        String sessionDetailTableName = ServerUtils.getModuleTableName((String)"inet_session_detail", (int)this.moduleId);
        String sessionTableName = ServerUtils.getModuleTableName((String)"inet_session", (int)this.moduleId);
        this.initZeroTrafficsInternal(sessionDetailTableName, sessionTableName, con);
        return this.zeroTrafficsAmountMap;
    }

    private void initZeroTrafficsInternal(String sessionDetailTableName, String sessionTableName, Connection con) throws SQLException {
        String query = " SELECT * FROM " + sessionDetailTableName + " as detail LEFT JOIN " + sessionTableName + " AS session ON session.id = detail.sessionId  WHERE session.sessionStart = ?  AND detail.day = 0 AND detail.hour = 0 AND detail.trafficTypeId > 0";
        PreparedStatement ps = con.prepareStatement(query);
        int idx = 1;
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.day));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            long sessionId = rs.getLong("sessionId");
            int trafficTypeId = rs.getInt("trafficTypeId");
            long amount = rs.getLong("amount");
            Map<Integer, Long> map = this.zeroTrafficsAmountMap.get(sessionId);
            if (map == null) {
                map = new HashMap<Integer, Long>();
                this.zeroTrafficsAmountMap.put(sessionId, map);
            }
            map.put(trafficTypeId, amount);
        }
        rs.close();
        ps.close();
    }

    @Override
    public void dayFinished(ConnectionSet connectionSet, boolean isCurrentDay) throws SQLException {
        Connection con = connectionSet.getConnection();
        Calendar cal = TimeUtils.convertDateToCalendar((Date)this.day);
        cal.add(5, 1);
        Date nextDay = cal.getTime();
        if (!isCurrentDay) {
            this.updateNextDayZeroTraffics(con, nextDay);
        }
        this.deleteDayZeroTraffics(con, nextDay);
    }

    protected void deleteDayZeroTraffics(Connection con, Date nextDay) throws SQLException {
        String sessionCurrDayDetailLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)this.day, (int)this.moduleId);
        String sessionCurrDayDetailTableName = ServerUtils.getModuleTableName((String)"inet_session_detail", (int)this.moduleId);
        String sessionCurrDayLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)this.day, (int)this.moduleId);
        String sessionCurrDayTableName = ServerUtils.getModuleTableName((String)"inet_session", (int)this.moduleId);
        String inetConnectionTableName = ServerUtils.getModuleTableName((String)"inet_connection", (int)this.moduleId);
        if (this.affectedZeroSessions.size() == 0) {
            this.affectedZeroSessions.add(-1L);
        }
        String pattern = "DELETE FROM detail  USING detailTable as detail  LEFT JOIN sessionTable AS session ON session.id = detail.sessionId <JOINS> WHERE session.sessionStart > ?  AND session.sessionStart < ?  AND session.type & 2> 0 AND detail.day = 0 AND detail.hour = 0  AND detail.trafficTypeId > 0  AND session.id NOT IN (" + Utils.toString(this.affectedZeroSessions) + ") AND session.deviceId =  ? ";
        String query = pattern.replaceAll("detailTable", sessionCurrDayDetailLogTableName).replaceAll("sessionTable", sessionCurrDayLogTableName).replaceAll("<JOINS>", "");
        PreparedStatement ps = con.prepareStatement(query);
        int idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)this.day));
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)nextDay));
        ps.setInt(idx++, this.deviceId);
        ps.executeUpdate();
        ps.close();
        query = pattern.replaceAll("detailTable", sessionCurrDayDetailTableName).replaceAll("sessionTable", sessionCurrDayTableName).replaceAll("<JOINS>", "LEFT JOIN " + inetConnectionTableName + " as connection ON connection.id = session.connectionId ").replaceAll("session\\.type", "connection.type").replaceAll("session\\.deviceId", "connection.deviceId");
        ps = con.prepareStatement(query);
        idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)this.day));
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)nextDay));
        ps.setInt(idx++, this.deviceId);
        ps.executeUpdate();
        ps.close();
    }

    public void updateNextDayZeroTraffics(Connection con, Date nextDay) throws SQLException {
        String sessionNextDayDetailLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)nextDay, (int)this.moduleId);
        String sessionNextDayDetailTableName = ServerUtils.getModuleTableName((String)"inet_session_detail", (int)this.moduleId);
        String sessionNextDayLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)nextDay, (int)this.moduleId);
        String sessionNextDayTableName = ServerUtils.getModuleTableName((String)"inet_session", (int)this.moduleId);
        String inetConnectionTableName = ServerUtils.getModuleTableName((String)"inet_connection", (int)this.moduleId);
        String pattern = "DELETE FROM detail  USING detailTable as detail  LEFT JOIN sessionTable AS session ON session.id = detail.sessionId <JOINS> WHERE session.sessionStart = ?  AND session.type & 2> 0 AND detail.day = 0 AND detail.hour = 0  AND detail.trafficTypeId > 0  AND session.deviceId =  ? ";
        String query = pattern.replaceAll("detailTable", sessionNextDayDetailLogTableName).replaceAll("sessionTable", sessionNextDayLogTableName).replaceAll("<JOINS>", "");
        PreparedStatement ps = con.prepareStatement(query);
        int idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)nextDay));
        ps.setInt(idx++, this.deviceId);
        ps.executeUpdate();
        ps.close();
        query = pattern.replaceAll("detailTable", sessionNextDayDetailTableName).replaceAll("sessionTable", sessionNextDayTableName).replaceAll("<JOINS>", "LEFT JOIN " + inetConnectionTableName + " as connection ON connection.id = session.connectionId ").replaceAll("session\\.type", "connection.type").replaceAll("session\\.deviceId", "connection.deviceId");
        ps = con.prepareStatement(query);
        idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)nextDay));
        ps.setInt(idx++, this.deviceId);
        ps.executeUpdate();
        ps.close();
        String typeField = "session.type";
        this.updateNextDayCounts(con, nextDay, sessionNextDayLogTableName, sessionNextDayDetailLogTableName, null, typeField);
        String joins = "LEFT JOIN " + inetConnectionTableName + " as connection ON connection.id = session.connectionId ";
        typeField = "connection.type";
        this.updateNextDayCounts(con, nextDay, sessionNextDayTableName, sessionNextDayDetailTableName, joins, typeField);
    }

    protected void updateNextDayCounts(Connection con, Date nextDay, String sessionNextDayTableName, String sessionNextDayDetailTableName, String joins, String typeField) throws SQLException {
        String pattern = "INSERT INTO  detailTable  SET sessionId = ?, day = 0, hour = 0, trafficTypeId = ?, amount = ?, deviceId =  0 ";
        Object query = pattern.replaceAll("detailTable", sessionNextDayDetailTableName);
        PreparedStatement insertPs = con.prepareStatement((String)query);
        query = " SELECT * FROM " + sessionNextDayTableName + " AS session ";
        if (joins != null) {
            query = (String)query + "<JOINS> ";
        }
        query = (String)query + " WHERE session.sessionStart = ? AND <typeField>  & 2> 0";
        query = ((String)query).replaceAll("<JOINS>", joins).replaceAll("<typeField>", typeField);
        PreparedStatement ps = con.prepareStatement((String)query);
        int idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)nextDay));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            long connectionId = rs.getLong("connectionId");
            long sessionId = rs.getLong("id");
            Map<Integer, Long> map = this.connectionAbsoluteAmountMap.get(connectionId);
            if (map == null) continue;
            for (Map.Entry<Integer, Long> entry : map.entrySet()) {
                int trafficTypeId = entry.getKey();
                long amount = entry.getValue();
                if (amount == 0L) continue;
                insertPs.setLong(1, sessionId);
                insertPs.setInt(2, trafficTypeId);
                insertPs.setLong(3, amount);
                insertPs.executeUpdate();
            }
        }
        rs.close();
        ps.close();
        insertPs.close();
    }

    protected TrafficTypeLinkRuntime getLinkForSession(InetSessionLog session) throws BGException {
        InetServ serv = this.servMap.get(session.getServId());
        if (serv == null) {
            logger.error("service was noy found for sessionId = " + session.getId());
            return null;
        }
        InetServTypeRuntime type = (InetServTypeRuntime)this.accounting.servTypeRuntimeMap.get(serv.getTypeId());
        TrafficTypeLinkRuntime link = null;
        if (type != null) {
            link = type.trafficTypeLinkRuntimeRef.get();
        }
        return link;
    }
}

