var months = ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'];

var popup;
var webexecuter = "webexecuter";

jQuery(document).ready(function() {

	popup = jQuery("<div/>")
		.hide()
		.addClass("popup_menu")
		.css('position', 'absolute')
		.mouseover( function() { popup.show(); } )
		.mouseout( function() { popup.hide(); } )
		.appendTo(jQuery('body')); 
	
    jQuery('div.bgTableWidget').bgTableWidget();
    jQuery('div.bgBalanceInformerWidget').bgBalanceInformerWidget();
});				

(function( $ ) {

	$.fn.bgBalanceInformerWidget = function( method )
	{
		var self = this;
		
		var methods = {
		    init : function() {
				var $this = $(this);
				let jsp = $this.attr( 'jsp' );
				if (jsp === undefined) { jsp = contextPath + '/widget/contract/balanceInformer.jsp'; }
				$this.load( jsp );
				setTimeout( function() { loadData( self ); }, 1000 );
				return $this;
		    },
		    reload : function() {
		    	var $this = $(this);
				loadData( self, true );
				return $this;
		    }
		};

		var loadData = function( div, resetDelay )
		{
			var span = $('span.balanceInformerSum',$(div));
			
			$.get( 
					contextPath + "/" + webexecuter,
					{
						action: 'GetBalanceInformerData',
						module: 'contract',
						mid: 0,
						contractId: contractId, 
						ct: 'json'
					},
					function( data )
					{
						if ( data.sum )
						{
							var delay = Number(span.attr('delay')) || 30;
							if ( resetDelay ) delay = 30;
							span.empty().html( data.sum ); //  + '####&nbsp;&#8381;'
							setTimeout( function() { loadData( div ); }, delay * 1000 );
							span.attr('delay', 2 * delay);
						}
					} 
				);
		};
			 
		if ( methods[method] ) { return this.each( function() { methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ) ); } ); } 
		else if ( typeof method === 'object' || ! method ) { return this.each( function() { methods.init.apply( this, arguments ); } ); } 
		else { $.error( 'Метод ' +  method + ' в jQuery.bgBalanceInformerWidget не существует' ); }   
	};
	
	// *******************
	
	$.fn.bgTableWidget = function( method )
	{
		var methods = {
		    init : function( options ) {
				var $this = $(this);
				var table = $('table',this);

				var trhead = $('<tr/>').appendTo($('<thead/>').appendTo(table));
				$("col",table).each( function() { $("<td/>").append( this.title ).appendTo(trhead); } );

				$("<tbody/>").appendTo(table);
				
				return $this;
		    },
		    reload : function() {
		    	var $this = $(this);
				loadData( $this );
				return $this;
		    }
		};
		
		var loadData = function( div )
		{
			var table = $('table',div);
			var tbody = $("tbody",table).empty();

			$.get( 
					webexecuter,
					{
						action: div.attr('action'),
						module: div.attr('module'),
						mid: div.attr('moduleId'),
						operation: div.attr('operation'),
						contractId: contractId, 
						ct: 'json'
					},
					function( data )
					{
						for ( var i = 0; i < data.rows.length; i++ )
						{
							var tr = $("<tr>").appendTo(tbody);
							$("col",table).each( function() 
							{
								var type = this.getAttribute('type');
								var val = data.rows[i][this.getAttribute('name')];
								if ( type !== undefined )
								{
									if ( type == "boolean" )
									{
										var aa = $("<input type='checkbox' disabled='disabled' />");
										if ( val == true ) aa.attr('checked','checked');
										val = aa;
									}
								}
								$("<td/>").append( val ).appendTo(tr); 
							} );
						}
					} 
				);
		};
			 
		if ( methods[method] ) { return this.each( function() { methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ) ); } ); } 
		else if ( typeof method === 'object' || ! method ) { return this.each( function() { methods.init.apply( this, arguments ); } ); } 
		else { $.error( 'Метод ' +  method + ' в jQuery.bgTableWidget не существует' ); }   
	};
	
})( jQuery );