/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class ContractGroupOperationFactory
implements ContractGroupOperation.ContractGroupOperationFactory {
    public Collection<ContractGroupOperation.ContractGroupOperationItem> getContractGroupOperations(String moduleId, String title) {
        ArrayList<ContractGroupOperation.ContractGroupOperationItem> result = new ArrayList<ContractGroupOperation.ContractGroupOperationItem>(1);
        result.add(new AddFilesToContractOperationItem(title));
        return result;
    }

    private class AddFilesToContractOperationItem
    extends ContractGroupOperation.ContractGroupOperationItem {
        private String pluginTitle;
        private JLabel infoLabel;
        private BGUTable fileTable;
        private BGTableModel<TableFile> fileTableModel;
        private BGTextField documentTitleTextField;
        private BGTextField commentTextField;
        private BGComboBox<DocumentJournal> journalComboBox;
        private BGComboBox<DocumentType> typeComboBox;
        private BGComboBox<DocumentStatus> statusComboBox;
        private JButton selectFileButton;
        private JButton deleteSelectedFileButton;
        private Directory<DocumentJournal> journalDirectory;
        private Directory<DocumentType> typeDirectory;
        private Directory<DocumentStatus> statusDirectory;
        private DocumentsService documentsService;

        public AddFilesToContractOperationItem(String title) {
            super((LayoutManager)new GridBagLayout());
            this.infoLabel = new JLabel("\u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 (-\u043e\u0432) \u043d\u0430 \u043a\u0430\u0436\u0434\u043e\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0431\u0443\u0434\u0443\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d (\u044b) \u0444\u0430\u0439\u043b (\u044b)");
            this.documentTitleTextField = new BGTextField();
            this.commentTextField = new BGTextField();
            this.journalComboBox = new BGComboBox();
            this.typeComboBox = new BGComboBox();
            this.statusComboBox = new BGComboBox();
            this.selectFileButton = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b(\u044b)");
            this.deleteSelectedFileButton = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b(\u044b)");
            this.pluginTitle = title;
        }

        protected void jbInit() throws Exception {
            this.documentsService = (DocumentsService)((ClientContext)this.getContext()).getPort(DocumentsService.class);
            this.journalDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentJournal.class);
            this.typeDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentType.class);
            this.statusDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentStatus.class);
            this.statusComboBox.setModel(new DefaultComboBoxModel<DocumentStatus>(this.statusDirectory.list().toArray(new DocumentStatus[0])));
            this.journalComboBox.setModel(new DefaultComboBoxModel<DocumentJournal>(this.journalDirectory.list().toArray(new DocumentJournal[0])));
            this.typeComboBox.setModel(new DefaultComboBoxModel<DocumentType>(this.typeDirectory.list().toArray(new DocumentType[0])));
            this.fileTableModel = new BGTableModel<TableFile>("files"){

                protected void initColumns() {
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430", -1, -1, -1, "");
                    this.addColumn("\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430, \u0431\u0430\u0439\u0442", -1, -1, -1, "");
                }

                public Object getValue(TableFile val, int column) throws BGException {
                    if (column == 0) {
                        return val.name;
                    }
                    return val.size;
                }
            };
            this.fileTable = new BGUTable(this.fileTableModel);
            this.documentTitleTextField.setPromptText("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442", true, true);
            this.commentTextField.setPromptText("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", true, true);
            JPanel paramsPanel = new JPanel(new GridBagLayout());
            JPanel filesPanel = new JPanel(new GridBagLayout());
            paramsPanel.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"));
            filesPanel.setBorder(BorderFactory.createTitledBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432"));
            paramsPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)this.documentTitleTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            paramsPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)this.commentTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
            paramsPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)this.statusComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            paramsPanel.add((Component)new JLabel("\u0422\u0438\u043f"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)new JLabel("\u0416\u0443\u0440\u043d\u0430\u043b"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            paramsPanel.add((Component)this.journalComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            filesPanel.add((Component)new JScrollPane((Component)this.fileTable), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            filesPanel.add((Component)this.selectFileButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            filesPanel.add((Component)this.deleteSelectedFileButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.add(this.infoLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(7, 7, 7, 7), 0, 0));
            this.add(paramsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            this.add(filesPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.selectFileButton.addActionListener(e -> {
                File[] selectedFiles;
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(true);
                if (chooser.showOpenDialog(JOptionPane.getRootFrame()) == 0 && (selectedFiles = chooser.getSelectedFiles()).length > 0) {
                    ArrayList<TableFile> tableData = new ArrayList<TableFile>(selectedFiles.length);
                    for (File file : selectedFiles) {
                        tableData.add(new TableFile(ContractGroupOperationFactory.this, file));
                    }
                    this.fileTableModel.setData(tableData);
                }
            });
            this.deleteSelectedFileButton.addActionListener(e -> {
                List selectedFiles = this.fileTableModel.getSelectedRows();
                List tableData = this.fileTableModel.getRows();
                ArrayList<TableFile> $resultList = new ArrayList<TableFile>(tableData.size() - selectedFiles.size());
                Iterator tableDataIterator = tableData.iterator();
                Iterator selectedFilesIterator = selectedFiles.iterator();
                while (selectedFilesIterator.hasNext()) {
                    TableFile selectedFile = (TableFile)selectedFilesIterator.next();
                    while (tableDataIterator.hasNext()) {
                        TableFile tableFile = (TableFile)tableDataIterator.next();
                        if (selectedFile.equals(tableFile)) {
                            selectedFilesIterator.remove();
                            tableDataIterator.remove();
                            continue;
                        }
                        $resultList.add(tableFile);
                    }
                }
                this.fileTableModel.setData($resultList, false);
            });
        }

        protected boolean doItemOperation(String cids) {
            String documentTitle = this.documentTitleTextField.getText();
            if (Utils.isBlankString((String)documentTitle)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430!");
                return false;
            }
            List selectedFiles = this.fileTableModel.getRows();
            if (selectedFiles.size() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0444\u0430\u0439\u043b(\u0430)!");
                return false;
            }
            try {
                for (String contractId : cids.split(",")) {
                    Document document = Document.builder().setContractId(Utils.parseInt((String)contractId.trim())).setTitle(documentTitle).setCreateDate(new Date()).setComment(this.commentTextField.getText()).setJournalId(((DocumentJournal)this.journalComboBox.getSelectedItem()).getId()).setTypeId(((DocumentType)this.typeComboBox.getSelectedItem()).getId()).setStatusId(((DocumentStatus)this.statusComboBox.getSelectedItem()).getId()).build();
                    document.setId(this.documentsService.updateDocument(document));
                    DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                    TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                    for (TableFile tableFile : selectedFiles) {
                        BGServerFile serverFile = new BGServerFile();
                        serverFile.setContractId(document.getContractId());
                        serverFile.setOwnerId(document.getId());
                        serverFile.setComment("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
                        serverFile.setSize(tableFile.size);
                        serverFile.setTitle(tableFile.name);
                        serverFile.setDate(new Date());
                        transferData.uploadFile("ru.bitel.bgbilling.plugins.documents/uploadDocumentFile", serverFile, tableFile.file);
                    }
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }

        protected String getOperationTitle() {
            return this.pluginTitle + ": \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c";
        }
    }

    private class TableFile {
        File file;
        String name;
        long size;

        TableFile(ContractGroupOperationFactory contractGroupOperationFactory, File file) {
            this.file = file;
            this.name = file.getName();
            this.size = file.length();
        }

        public boolean equals(Object obj) {
            return ((TableFile)obj).file.equals(this.file);
        }
    }
}

