/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigPeriods
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private BGTextField title = new BGTextField();
    private IntTextField timeCol = new IntTextField();
    private BGComboBox<ComboBoxItem> timeType = new BGComboBox();
    private JRadioButton typeAct = new JRadioButton("\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f");
    private JRadioButton typeProl = new JRadioButton("\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435");
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    public ServiceConfigPeriods() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "periods");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.timeType.addItem((Object)new ComboBoxItem(1, "\u0434\u0435\u043d\u044c"));
        this.timeType.addItem((Object)new ComboBoxItem(2, "\u043c\u0435\u0441\u044f\u0446"));
        this.timeType.addItem((Object)new ComboBoxItem(3, "\u0433\u043e\u0434"));
        this.add(this.editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)this.wrap((Component)this.title, " \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "), new GridBagConstraints(0, 0, 1, 1, 0.6, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel radioPanel = new JPanel();
        this.editPanel.add((Component)this.wrap(radioPanel, " \u0422\u0438\u043f "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.typeAct.setMargin(new Insets(0, 0, 0, 0));
        this.typeProl.setMargin(new Insets(0, 0, 0, 0));
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.typeAct);
        gr.add(this.typeProl);
        radioPanel.add((Component)this.typeAct, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        radioPanel.add((Component)this.typeProl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.wrap((Component)this.timeCol, " \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e "), new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)this.wrap((Component)this.timeType, " \u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f "), new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigPeriods.this.editItem();
                }
            }
        });
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editPanel.setVisible(false);
        this.editPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigPeriods.this.setData();
            }
        });
    }

    public void setData() {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("Period");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    public void startEdit() {
        if (this.id != 0) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("PeriodGet");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element period = XMLUtils.getElement((Document)doc, (String)"period");
                this.title.setText(period.getAttribute("title"));
                this.timeCol.setText(period.getAttribute("timeCol"));
                if ("1".equals(period.getAttribute("type"))) {
                    this.typeAct.setSelected(true);
                } else {
                    this.typeProl.setSelected(true);
                }
                ClientUtils.setComboBoxSelection(this.timeType, (Object)period.getAttribute("timeType"));
            }
        } else {
            this.title.setText("");
            this.timeCol.setText("");
            this.typeAct.setSelected(true);
            ClientUtils.setComboBoxSelection(this.timeType, (Object)"1");
        }
        this.editPanel.setVisible(true);
    }

    public void stopEdit(boolean save) {
        if (save) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("PeriodUpdate");
            req.setAttribute("id", this.id);
            req.setAttribute("title", this.title.getText());
            req.setAttribute("timeCol", this.timeCol.getText());
            ComboBoxItem item = (ComboBoxItem)this.timeType.getSelectedItem();
            if (item != null) {
                req.setAttribute("timeType", item.getObject());
            }
            req.setAttribute("type", this.typeAct.isSelected() ? "1" : "2");
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.editPanel.setVisible(false);
            }
        } else {
            this.editPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0445\u043e\u0441\u0442 \u0441\u0435\u0440\u0432\u0435\u0440?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("HostingServerDelete");
            request.setAttribute("id", this.id);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.id = 0;
        this.startEdit();
    }

    private JPanel wrap(Component comp, String borderTitle) {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder((Border)new BGTitleBorder(borderTitle));
        result.add(comp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        return result;
    }

    public static class TypeColumn
    extends BGTableColumn {
        public Object getValue(String item) {
            if ("1".equals(item)) {
                return "\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f";
            }
            if ("2".equals(item)) {
                return "\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435";
            }
            return item;
        }
    }

    public static class TimeTypeColumn
    extends BGTableColumn {
        public Object getValue(String item) {
            if ("1".equals(item)) {
                return "\u0434\u0435\u043d\u044c";
            }
            if ("2".equals(item)) {
                return "\u043c\u0435\u0441\u044f\u0446";
            }
            if ("3".equals(item)) {
                return "\u0433\u043e\u0434";
            }
            return item;
        }
    }
}

