/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.bean;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PaymentQueueManager;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class AutoprintProcessor {
    private static final Logger log = LogManager.getLogger();

    public static void processNewPayment(PrinterManager.PaymentPrintMode printMode, final Payment bgpayment, Setup setup, Connection con, Connection conSlave) {
        PrinterManager.PaymentMapping paymentMapping = PrinterManager.getPt(bgpayment.getTypeId());
        if (paymentMapping != null) {
            if (paymentMapping.print != printMode) {
                if (log.isTraceEnabled()) {
                    log.trace("cashcheck autoprint (" + printMode.name() + "): payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ") mapped no \"" + printMode.name() + "\"-mode (print-mode: " + String.valueOf((Object)paymentMapping.print) + ")");
                }
                return;
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("cashcheck autoprint (" + printMode.name() + "): payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ") not automatically printed - there are no mapping");
            }
            return;
        }
        int kkmNum = paymentMapping.getRandomFr();
        log.info("cashcheck autoprint (" + printMode.name() + "): payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ") automatically printed on mapped printer #" + kkmNum + "...");
        ru.bitel.bgbilling.plugins.cashcheck.common.Payment ccpayment = null;
        Printer printer = null;
        Check check = null;
        try {
            PaymentQueueManager paymentQueueManager = new PaymentQueueManager(con);
            List<ru.bitel.bgbilling.plugins.cashcheck.common.Payment> ccpayments = paymentQueueManager.getPaymentNotLogList((List<Integer>)new ArrayList<Integer>(){
                {
                    this.add(bgpayment.getId());
                }
            });
            if (1 != ccpayments.size()) {
                throw new BGException("cashcheck autoprint (" + printMode.name() + "): payment #" + bgpayment.getId() + " does not exist. Was removed? Missing from the contract_payment table? Or just a mistake...");
            }
            ccpayment = ccpayments.get(0);
            if (ccpayment.getLogDate() != null) {
                throw new BGException("cashcheck autoprint (" + printMode.name() + "): payment #" + bgpayment.getId() + " is contained in the log, printing is impossible. maybe, it has already been printed");
            }
            printer = CashCheckUtils.getPrinter(kkmNum);
            check = new Check(Check.Type.PAYMENT);
            CashCheckUtils.runCheckMakerAddPayment(printMode, setup, con, conSlave, ccpayments.get(0), check, printer);
        }
        catch (Exception e) {
            boolean ismessage = e instanceof BGMessageException;
            log.log(ismessage ? Level.WARN : Level.ERROR, "cashcheck autoprint (" + printMode.name() + "): " + (ismessage ? "MESSAGE" : "ERROR") + " prepare check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on mapped printer #" + kkmNum + ")", (Throwable)e);
            CashCheckUtils.sendAlarm(ismessage ? "check.message" : "check.error", kkmNum, "CashCheck Autoprint (" + printMode.name() + "): " + (ismessage ? "MESSAGE" : "ERROR") + " prepare check", "(payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on mapped printer #" + kkmNum + ")", e);
            return;
        }
        try {
            int kkmPass = paymentMapping.pass != -1 ? paymentMapping.pass : printer.getPass();
            CashCheckUtils.printCheck(check, printer, kkmPass, con, ccpayment.getPaymentId(), printMode.name(), bgpayment.getContractId(), null);
            log.info("cashcheck autoprint (" + printMode.name() + "): check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ")) was printed on printer #" + printer.getId());
        }
        catch (Exception e) {
            log.error("cashcheck autoprint (" + printMode.name() + "): ERROR check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on printer #" + printer.getId() + ")", (Throwable)e);
            CashCheckUtils.sendAlarm("check.error", printer.getId(), "CashCheck Autoprint (" + printMode.name() + "): ERROR check", "(payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on printer #" + printer.getId() + ")", e);
        }
    }

    public static void processErroredPayment(Payment bgpayment, final int logId, Setup setup, Connection con, Connection conSlave) {
        PrinterManager.PaymentMapping paymentMapping = PrinterManager.getPt(bgpayment.getTypeId());
        if (paymentMapping != null) {
            if (paymentMapping.print != PrinterManager.PaymentPrintMode.auto && paymentMapping.print != PrinterManager.PaymentPrintMode.delay) {
                if (log.isTraceEnabled()) {
                    log.trace("cashcheck autoprint errored: payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ") mapped no auto/delay-mode (print-mode: " + String.valueOf((Object)paymentMapping.print) + ")");
                }
                return;
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("cashcheck autoprint errored: payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ") not automatically re-printed - there are no mapping");
            }
            return;
        }
        int kkmNum = paymentMapping.getRandomFr();
        log.info("cashcheck autoprint errored: payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ")(print mode: " + paymentMapping.print.name() + ") automatically re-printed on mapped printer #" + kkmNum + "  (log-id=" + logId + ")...");
        ru.bitel.bgbilling.plugins.cashcheck.common.Payment ccpayment = null;
        Printer printer = null;
        Check check = null;
        try {
            PaymentQueueManager paymentQueueManager = new PaymentQueueManager(con);
            List ccpayments = paymentQueueManager.getPaymentLog(null, 0, null, null, null, null, (Collection<Integer>)new ArrayList<Integer>(){
                {
                    this.add(logId);
                }
            }).getList();
            if (1 != ccpayments.size()) {
                throw new BGException("cashcheck autoprint errored: log record #" + logId + " does not exist. Was removed? Missing from table? Or just a mistake...");
            }
            ccpayment = (ru.bitel.bgbilling.plugins.cashcheck.common.Payment)ccpayments.get(0);
            if (Utils.isBlankString((String)ccpayment.getLastError())) {
                throw new BGException("cashcheck autoprint errored: payment #" + bgpayment.getId() + " is contained in the log NO-error, re-printing is impossible. maybe, it has already been printed sucessful");
            }
            log.info("cashcheck autoprint errored: payment #" + bgpayment.getId() + " previous error: \"" + ccpayment.getLastError() + "\", re-print...");
            printer = CashCheckUtils.getPrinter(kkmNum);
            check = new Check(Check.Type.PAYMENT);
            CashCheckUtils.runCheckMakerAddPayment(paymentMapping.print, setup, con, conSlave, ccpayment, check, printer);
        }
        catch (Exception e) {
            boolean ismessage = e instanceof BGMessageException;
            log.log(ismessage ? Level.WARN : Level.ERROR, "cashcheck autoprint errored: " + (ismessage ? "MESSAGE" : "ERROR") + " prepare check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ")(print mode: " + paymentMapping.print.name() + "), on mapped printer #" + kkmNum + ")", (Throwable)e);
            CashCheckUtils.sendAlarm(ismessage ? "check.message" : "check.error", kkmNum, "CashCheck Autoprint Errored: " + (ismessage ? "MESSAGE" : "ERROR") + " prepare check", "(payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ")(print mode: " + paymentMapping.print.name() + "), on mapped printer #" + kkmNum + ")", e);
            return;
        }
        try {
            int kkmPass = paymentMapping.pass != -1 ? paymentMapping.pass : printer.getPass();
            CashCheckUtils.printCheck(check, printer, kkmPass, con, ccpayment.getPaymentId(), paymentMapping.print.name(), bgpayment.getContractId(), logId);
            log.info("cashcheck autoprint errored: check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + ")) was sucessful re-printed on printer #" + printer.getId());
        }
        catch (Exception e) {
            log.error("cashcheck autoprint errored: ERROR check (payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on printer #" + printer.getId() + ")", (Throwable)e);
            CashCheckUtils.sendAlarm("check.error", printer.getId(), "CashCheck Autoprint Errored: ERROR check", "(payment #" + bgpayment.getId() + " (type_id=" + bgpayment.getTypeId() + "), on printer #" + printer.getId() + ")\n" + BGException.printStackTraceToString((Throwable)e) + "\n\nprevious error: \"" + ccpayment.getLastError() + "\"", null);
        }
    }

    public static void processErroredAsIsPayment(ru.bitel.bgbilling.plugins.cashcheck.common.Payment ccpayment, Setup setup, Connection con, Connection conSlave) {
        int kkmNum = ccpayment.getPosId();
        String posMapping = ccpayment.getPosMapping();
        log.info("cashcheck autoprint as is errored: log-id #" + ccpayment.getLogId() + " (print mode: " + posMapping + ") automatically re-printed on mapped printer #" + kkmNum + "...");
        Printer printer = null;
        Check check = null;
        try {
            if (Utils.isBlankString((String)ccpayment.getLastError())) {
                throw new BGException("cashcheck autoprint as is errored: log-id #" + ccpayment.getLogId() + " is contained in the log NO-error, re-printing is impossible. maybe, it has already been printed sucessful");
            }
            log.info("cashcheck autoprint as is errored: log-id #" + ccpayment.getLogId() + " previous error: \"" + ccpayment.getLastError() + "\", re-print...");
            printer = CashCheckUtils.getPrinter(kkmNum);
            check = Check.fromCheckData(ccpayment.getCheckData());
        }
        catch (Exception e) {
            log.error("cashcheck autoprint as is errored: ERROR prepare check (log-id #" + ccpayment.getLogId() + " (print mode: " + posMapping + "), on mapped printer #" + kkmNum + ")", (Throwable)e);
            CashCheckUtils.sendAlarm("check.error", kkmNum, "CashCheck Autoprint as is Errored: ERROR prepare check", "(log-id #" + ccpayment.getLogId() + " (print mode: " + posMapping + "), on mapped printer #" + kkmNum + ")", e);
            return;
        }
        try {
            int kkmPass = printer.getPass();
            CashCheckUtils.printCheck(check, printer, kkmPass, con, ccpayment.getPaymentId(), posMapping, ccpayment.getContractId(), ccpayment.getLogId());
            log.info("cashcheck autoprint as is errored: check (log-id #" + ccpayment.getLogId() + ") was sucessful re-printed on printer #" + printer.getId());
        }
        catch (Exception e) {
            log.error("cashcheck autoprint as is errored: ERROR check (log-id #" + ccpayment.getLogId() + ", on printer #" + printer.getId() + ")", (Throwable)e);
            CashCheckUtils.sendAlarm("check.error", printer.getId(), "CashCheck Autoprint as is Errored: ERROR check", "(log-id #" + ccpayment.getLogId() + ", on printer #" + printer.getId() + ")\n" + BGException.printStackTraceToString((Throwable)e) + "\n\nprevious error: \"" + ccpayment.getLastError() + "\"", null);
        }
    }
}

