/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.task;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyManager;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.TransactionResult;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class CheckPaymentsStatus
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c BuyEmoney. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
            ProtocolManager protocolManager = new ProtocolManager((ParameterMap)moduleSetup);
            BuyemoneyManager manager = new BuyemoneyManager(con, this.moduleId);
            Map<Integer, List<BuyemoneyPayment>> paymentMap = manager.getUnstatusedPaymentMap();
            for (Map.Entry<Integer, ProtocolCurrency> entry : protocolManager.getProtocols().entrySet()) {
                int protocolId = entry.getKey();
                ProtocolCurrency protocolCurrency = entry.getValue();
                List<BuyemoneyPayment> paymentsOfProtocol = paymentMap.get(protocolId);
                if (paymentsOfProtocol == null || paymentsOfProtocol.isEmpty()) continue;
                int chargeType = Utils.parseInt((String)protocolCurrency.getProtocolParameter("chargeType"));
                String chargeCommentTemplate = protocolCurrency.getProtocolParameter("chargeCommentTemplate");
                HashMap<Integer, TransactionResult> resultsPaymentsOfProtocol = new HashMap<Integer, TransactionResult>();
                for (BuyemoneyPayment payment : paymentsOfProtocol) {
                    TransactionResult result = new TransactionResult();
                    result.setTransactId(payment.getId());
                    result.setStatus(payment.getStatus());
                    result.setDate(payment.getDate());
                    result.setComment(payment.getComment());
                    resultsPaymentsOfProtocol.put(payment.getId(), result);
                }
                protocolCurrency.getResults(resultsPaymentsOfProtocol.values());
                for (BuyemoneyPayment payment : paymentsOfProtocol) {
                    TransactionResult trRes = (TransactionResult)resultsPaymentsOfProtocol.get(payment.getId());
                    if (trRes != null) {
                        if (trRes.getStatus() != null) {
                            payment.setStatus(trRes.getStatus());
                        }
                        if (trRes.getDate() != null) {
                            payment.setDate(trRes.getDate());
                        }
                        if (trRes.getComment() != null) {
                            payment.setComment(trRes.getComment());
                        }
                    } else {
                        throw new Exception("error mapping getResults->paymentsOfProtocol, WTF?");
                    }
                    switch (payment.getStatus()) {
                        case OK: {
                            String commentCharge = manager.formatComment(chargeCommentTemplate, payment, null, protocolManager);
                            manager.carryOutCharge(payment, chargeType, commentCharge);
                            this.getLogger().info("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d.");
                            break;
                        }
                        case FAIL: {
                            this.getLogger().info("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439. " + payment.getComment());
                            break;
                        }
                        case NEW: {
                            this.getLogger().info("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getId() + " \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.");
                        }
                    }
                    manager.updatePayment(payment);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("error execute task", (Throwable)e);
            this.error = e;
        }
    }
}

