/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionDetailOrder;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDetailOrderDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.mail.MailTaskSessionDetailNotification;
import ru.bitel.bgbilling.modules.voice.server.mail.MailTaskSessionDetailReport;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class VoiceSessionDetailTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             ContractDao contractDao = new ContractDao(con, 0);
             VoiceAccountDao voiceAccountDao = new VoiceAccountDao(con, this.moduleId);
             VoiceSessionDetailOrderDao sessionDetailOrderDao = new VoiceSessionDetailOrderDao(con, this.moduleId);){
            for (VoiceSessionDetailOrder order : sessionDetailOrderDao.list(VoiceSessionDetailOrder.Status.WAIT)) {
                try {
                    String mailText;
                    String mailSubject;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(order.toString());
                    }
                    VoiceSessionDetailOrder executeOrder = VoiceSessionDetailOrder.builder().copy(order).setStatus(VoiceSessionDetailOrder.Status.EXECUTE).build();
                    sessionDetailOrderDao.update(executeOrder);
                    LocalDate date = LocalDate.of(executeOrder.getYear(), executeOrder.getMonth(), 1);
                    Period period = new Period(date, date.withDayOfMonth(date.lengthOfMonth()));
                    VoiceSessionFilter voiceSessionFilter = new VoiceSessionFilter().setContractIds(new HashSet<Integer>(Arrays.asList(executeOrder.getContractId()))).setAccountIds(new HashSet<Integer>(Arrays.asList(executeOrder.getAccountId()))).setDateFrom(TimeUtils.convertLocalDateToDate((LocalDate)period.getLocalDateFrom())).setDateTo(TimeUtils.convertLocalDateToDate((LocalDate)period.getLocalDateTo()));
                    ArrayList<VoiceSession> sessionList = new ArrayList();
                    try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(con, this.moduleId, voiceSessionFilter.getDateFrom());){
                        sessionList = sessionDao.list(voiceSessionFilter, null, false);
                    }
                    Path path = Files.createTempFile("voice-session-detail-", "-" + executeOrder.getYear() + "-" + executeOrder.getMonth(), new FileAttribute[0]);
                    VoiceAccount voiceAccount = (VoiceAccount)voiceAccountDao.get(executeOrder.getAccountId());
                    if (VoiceSessionDetailOrder.FormatType.CSV.equals((Object)executeOrder.getFormatType())) {
                        this.doCsv(path, sessionList);
                    } else if (VoiceSessionDetailOrder.FormatType.PDF.equals((Object)executeOrder.getFormatType())) {
                        Contract contract = (Contract)contractDao.get(order.getContractId());
                        this.doPdf(path, sessionList, period, (String)(voiceAccount != null ? voiceAccount.getTitle() : "ID#" + executeOrder.getAccountId()), (String)(contract != null ? contract.getTitle() : "Contract not found [ID#" + order.getContractId() + "]"));
                    }
                    Path targetPath = Paths.get("webroot", "data", String.valueOf(this.moduleId), "session", String.valueOf(executeOrder.getYear()), String.valueOf(executeOrder.getMonth()), String.valueOf(executeOrder.getAccountId()) + "." + executeOrder.getFormatType().name().toLowerCase());
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.move(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    VoiceSessionDetailOrder doneOrder = VoiceSessionDetailOrder.builder().copy(executeOrder).setStatus(VoiceSessionDetailOrder.Status.DONE).setFileSize(Files.size(targetPath)).build();
                    sessionDetailOrderDao.update(doneOrder);
                    if (!Utils.notBlankString((String)executeOrder.getEmail())) continue;
                    ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
                    if (VoiceSessionDetailOrder.EmailSend.NOTIFICATION.equals((Object)executeOrder.getEmailSend()) || doneOrder.getFileSize() > moduleSetup.getLong("mail.session.detail.report.file.size.max", 0x100000L)) {
                        mailSubject = moduleSetup.get("mail.session.detail.notification.subject", "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0439 ${ACCOUNT}");
                        mailSubject = mailSubject.replace("${ACCOUNT}", voiceAccount.getTitle());
                        mailText = moduleSetup.get("mail.session.detail.notification.text", "\u0417\u0430\u043a\u0430\u0437 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0439 ${ACCOUNT} \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d. \u0424\u0430\u0439\u043b \u0441 \u043e\u0442\u0447\u0435\u0442\u043e\u043c \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0432 \u041b\u041a");
                        mailText = mailText.replace("${ACCOUNT}", voiceAccount.getTitle());
                        MailTaskSessionDetailNotification mailData = MailTaskSessionDetailNotification.builder().setModuleId(this.moduleId).setRecipients(executeOrder.getEmail()).setSubject(mailSubject).addTextPart("text", mailText).build();
                        new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
                        continue;
                    }
                    if (!VoiceSessionDetailOrder.EmailSend.REPORT.equals((Object)executeOrder.getEmailSend())) continue;
                    mailSubject = moduleSetup.get("mail.session.detail.report.subject", "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0439 ${ACCOUNT}");
                    mailSubject = mailSubject.replace("${ACCOUNT}", voiceAccount.getTitle());
                    mailText = moduleSetup.get("mail.session.detail.report.text", "\u0417\u0430\u043a\u0430\u0437 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0439 ${ACCOUNT} \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d. \u0424\u0430\u0439\u043b \u0441 \u043e\u0442\u0447\u0435\u0442\u043e\u043c \u0432\u043e \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0438");
                    mailText = mailText.replace("${ACCOUNT}", voiceAccount.getTitle());
                    String contentType = switch (executeOrder.getFormatType()) {
                        case VoiceSessionDetailOrder.FormatType.PDF -> "application/pdf";
                        case VoiceSessionDetailOrder.FormatType.CSV -> "text/csv";
                        default -> "application/octet-stream";
                    };
                    MailTaskSessionDetailReport mailData = new MailTaskSessionDetailReport();
                    mailData.setModuleId(this.moduleId);
                    mailData.setRecipients(executeOrder.getEmail());
                    mailData.setSubject(mailSubject);
                    mailData.addTextPart("text", mailText, "text/" + moduleSetup.get("mail.session.detail.report.text.type", "plain") + "; charset=utf-8;");
                    mailData.addPart("file", "attachment", contentType, targetPath.getFileName().toString(), Files.readAllBytes(targetPath));
                    new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
                }
                catch (Exception ex) {
                    VoiceSessionDetailOrder doneOrder = VoiceSessionDetailOrder.builder().copy(order).setStatus(VoiceSessionDetailOrder.Status.ERROR).build();
                    sessionDetailOrderDao.update(doneOrder);
                    this.logError(ex);
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public String getDescription() {
        return "Voice: \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u0439 \u043d\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0441 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0435\u0439 \u0441\u0435\u0441\u0441\u0438\u0439";
    }

    private void doCsv(Path path, List<VoiceSession> sessionList) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        CSVWriter csvWriter = new CSVWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));
        csvWriter.writeNext(new String[]{"\u0414\u0430\u0442\u0430\u0412\u0440\u0435\u043c\u044f", "\u041d\u043e\u043c\u0435\u0440 \u0410", "\u041d\u043e\u043c\u0435\u0440 \u0411", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c"});
        for (VoiceSession voiceSession : sessionList) {
            csvWriter.writeNext(new String[]{TimeUtils.format((Date)voiceSession.getSessionStart(), (DateFormat)dateFormat), voiceSession.getE164CalledStationId(), voiceSession.getE164CallingStationId(), String.valueOf(voiceSession.getRoundedSessionTime()), voiceSession.getSessionCost().toPlainString()});
        }
        csvWriter.flush();
        csvWriter.close();
    }

    private void doPdf(Path path, List<VoiceSession> sessionList, Period period, String accountTitle, String contractTitle) throws Exception {
        BigDecimal sessionSum = BigDecimal.ZERO;
        int sessionTime = 0;
        for (VoiceSession voiceSession : sessionList) {
            sessionTime = (int)((long)sessionTime + voiceSession.getRoundedSessionTime());
            sessionSum = sessionSum.add(voiceSession.getSessionCost());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        StringWriter writer = new StringWriter();
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<data");
        writer.write(" contractTitle=\"" + contractTitle + "\"");
        writer.write(" accountTitle=\"" + accountTitle + "\"");
        writer.write(" period=\"" + TimeUtils.formatPeriod((Period)period) + "\"");
        writer.write(" sessionCount=\"" + Utils.formatInteger((int)sessionList.size()) + "\"");
        writer.write(" sessionTime=\"" + Utils.formatInteger((int)sessionTime) + "\"");
        writer.write(" sessionSum=\"" + Utils.formatSessionCost((BigDecimal)sessionSum) + "\"");
        writer.write(">\n");
        for (VoiceSession voiceSession : sessionList) {
            writer.write("  <session ");
            writer.write("dateTime=\"" + TimeUtils.format((Date)voiceSession.getSessionStart(), (DateFormat)dateFormat) + "\" ");
            writer.write("called=\"" + voiceSession.getE164CalledStationId() + "\" ");
            writer.write("calling=\"" + voiceSession.getE164CallingStationId() + "\" ");
            writer.write("sessionTime=\"" + voiceSession.getRoundedSessionTime() + "\" ");
            writer.write("sessionCost=\"" + voiceSession.getSessionCost().toPlainString() + "\"");
            writer.write("/>\n");
        }
        writer.write("</data>");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XML for PDF session detail:\n", (Object)writer.toString());
        }
        OutputStream bufferedWriter = Files.newOutputStream(path, new OpenOption[0]);
        StreamSource xslt = new StreamSource(Paths.get("webroot", "xsl", "voice_session_detail.xsl").toFile());
        FOUtils.render((Source)new StreamSource(new StringReader(writer.toString())), (Source)xslt, (OutputStream)bufferedWriter, (String)"application/pdf");
        bufferedWriter.close();
    }

    public static void main(String[] args) {
        try {
            Setup.setSetup((Setup)new Setup("data", "data"));
            ArrayList<VoiceSession> sessions = new ArrayList<VoiceSession>();
            for (int i = 0; i < 1000; ++i) {
                sessions.add(VoiceSession.builder().setSessionStart(new Date(System.currentTimeMillis() - (long)(i * 10000))).setE164CalledStationId("73472924823").setE164CallingStationId("73472900405").setRoundedSessionTime(Math.round(Math.random() * 300.0)).setSessionCost(new BigDecimal(Math.round(Math.random() * 10000.0) / 100L)).build());
            }
            Path path = Files.createTempFile("voice-session-detail-", "-2023-01.pdf", new FileAttribute[0]);
            System.out.println(path.toString());
            LocalDate now = LocalDate.now();
            new VoiceSessionDetailTask().doPdf(path, sessions, new Period(now, now.withDayOfMonth(now.lengthOfMonth())), "Test", "TEST");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

