/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.intercom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercom;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercomFlat;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseIntercomService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class IntercomPanel
extends BGUPanel {
    private SmartHouseIntercomService intercomService = null;
    private IntercomTableModel intercomTableModel = new IntercomTableModel();
    private IntercomFlatTableModel intercomFlatTableModel = new IntercomFlatTableModel();
    private IntercomParameterTableModel intercomParameterTableModel = new IntercomParameterTableModel();

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getIntercomListPanel(), (Component)this.getDataPanel(), 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getIntercomListPanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.intercomTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SmartHouseIntercom intercom = (SmartHouseIntercom)IntercomPanel.this.intercomTableModel.getSelectedRow();
                if (intercom != null) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        IntercomPanel.this.getPopupMenu().show((Component)table, mouseEvent.getX(), mouseEvent.getY());
                    } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        IntercomPanel.this.setFlatData(intercom.getId());
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getIntercomParameterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        FilterField streetText = new FilterField(30, "\u0433\u043e\u0440\u043e\u0434, \u0443\u043b\u0438\u0446\u0430");
        FilterField houseText = new FilterField(10, "\u0434\u043e\u043c");
        FilterField podText = new FilterField(10, "\u043f\u043e\u0434\u044a\u0435\u0437\u0434");
        JPanel housePodPanel = new JPanel(new GridBagLayout());
        housePodPanel.add((Component)((Object)streetText), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        housePodPanel.add((Component)((Object)houseText), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        housePodPanel.add((Component)((Object)podText), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u043c\u043e\u0444\u043e\u043d\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)housePodPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getIntercomParameterPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.intercomParameterTableModel));
        table.setSelectionMode(0);
        Dimension dimension = new Dimension(100, 200);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u0430:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getDataPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.getFlatPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFlatPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.intercomFlatTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SmartHouseIntercomFlat intercomFlat;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (intercomFlat = (SmartHouseIntercomFlat)IntercomPanel.this.intercomFlatTableModel.getSelectedRow()) != null) {
                    new FlatEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b", intercomFlat, IntercomPanel.this.intercomFlatTableModel.getContractData(intercomFlat.getContractId())).open();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void setFlatData(int intercomId) {
        try {
            SmartHouseIntercom intercom = this.getIntercomService().smartHouseIntercomGet(intercomId);
            this.intercomParameterTableModel.setData(intercom);
            List flats = this.getIntercomService().smartHouseIntercomFlatList(intercomId);
            this.intercomFlatTableModel.setContractData(this.getIntercomService().getContractData(flats.stream().map(e -> e.getContractId()).collect(Collectors.toList())));
            this.intercomFlatTableModel.setData(flats);
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add("\u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u0432\u0430\u0440\u0442\u0438\u0440").addActionListener(e -> {
                SmartHouseIntercom intercom = (SmartHouseIntercom)this.intercomTableModel.getSelectedRow();
                if (intercom != null) {
                    this.tryCall(() -> {
                        this.getIntercomService().doGetIntercomFlats(intercom.getId());
                        this.setFlatData(intercom.getId());
                        this.performAction("refresh");
                    });
                }
            });
            this.popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u0434\u0440\u0435\u0441").addActionListener(e -> this.intercomTableModel.optSelectedRow().ifPresent(intercom -> new IntercomAddressEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u0430", (SmartHouseIntercom)intercom).open()));
        }
        return this.popupMenu;
    }

    private SmartHouseIntercomService getIntercomService() {
        if (this.intercomService == null) {
            this.intercomService = (SmartHouseIntercomService)((ClientContext)this.getContext()).getPort(SmartHouseIntercomService.class);
        }
        return this.intercomService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List intercoms = this.getIntercomService().smartHouseIntercomList();
            ArrayList<Integer> houseIds = new ArrayList<Integer>();
            for (SmartHouseIntercom intercom : intercoms) {
                if (houseIds.contains(intercom.getHouseId())) continue;
                houseIds.add(intercom.getHouseId());
            }
            this.intercomTableModel.setHouseData(this.getIntercomService().houseInfoData(houseIds));
            this.intercomTableModel.setData(intercoms);
        });
    }

    class IntercomTableModel
    extends BGTableModel<SmartHouseIntercom> {
        private JSONObject houseInfo;

        public IntercomTableModel() {
            super(IntercomTableModel.class.getName());
            this.houseInfo = null;
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440", 130, 130, 130, "serialNumber", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0423\u043b\u0438\u0446\u0430", 100, 200, -1, "street", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043c", 100, 100, 100, "house", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u044a\u0435\u0437\u0434", 80, 80, 80, "entrance", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041a\u0432\u0430\u0440\u0442\u0438\u0440", 80, 80, 80, "flatCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", Boolean.class, 80, 80, 80, "status", true);
        }

        public void setHouseData(JSONObject houseInfo) {
            this.houseInfo = houseInfo;
        }

        public Object getValue(SmartHouseIntercom intercom, int column) throws Exception {
            JSONObject json = new JSONObject(intercom.getData());
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return json.optBoolean("is_online");
            }
            if ("type".equals(identifier)) {
                return intercom.getType().getTitle();
            }
            if ("serialNumber".equals(identifier)) {
                return json.optString("serial_number");
            }
            if ("street".equals(identifier)) {
                String houseId = String.valueOf(intercom.getHouseId());
                JSONObject houseData = this.houseInfo.optJSONObject(houseId);
                return houseData != null ? houseData.optString("street") : "#" + houseId;
            }
            if ("house".equals(identifier)) {
                String houseId = String.valueOf(intercom.getHouseId());
                JSONObject houseData = this.houseInfo.optJSONObject(houseId);
                return houseData != null ? houseData.optString("house") + houseData.optString("frac") : "#" + houseId;
            }
            if ("flatCount".equals(identifier)) {
                return this.getFlatCount(intercom.getFlatRange());
            }
            return super.getValue((Object)intercom, column);
        }

        private int getFlatCount(String flatRange) {
            int count = 0;
            for (String range : flatRange.split(",")) {
                int s2;
                int pos;
                int s1;
                if (range.matches("^\\d+$")) {
                    ++count;
                    continue;
                }
                if (!range.matches("^\\d+-\\d+$") || (s1 = Utils.parseInt((String)range.substring(0, pos = range.indexOf(45)))) >= (s2 = Utils.parseInt((String)range.substring(pos + 1)))) continue;
                count += s2 - s1 + 1;
            }
            return count;
        }
    }

    class IntercomFlatTableModel
    extends BGTableModel<SmartHouseIntercomFlat> {
        private Map<Integer, JSONObject> contractMap;

        public IntercomFlatTableModel() {
            super(IntercomFlatTableModel.class.getName());
            this.contractMap = new HashMap<Integer, JSONObject>();
        }

        protected void initColumns() {
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 100, 100, 100, "flatNumber", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439)", 100, 100, -1, "contract", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 300, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", Boolean.class, 100, 100, 100, "status", true);
        }

        public void setContractData(List<String> data) {
            this.contractMap.clear();
            for (String contractData : data) {
                JSONObject json = new JSONObject(contractData);
                this.contractMap.put(json.optInt("id"), json);
            }
        }

        public JSONObject getContractData(int contractId) {
            return this.contractMap.getOrDefault(contractId, null);
        }

        public Object getValue(SmartHouseIntercomFlat intercomFlat, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("contract".equals(identifier)) {
                int contractId = intercomFlat.getContractId();
                JSONObject json = this.contractMap.get(contractId);
                return json != null ? json.getString("title") + " [" + json.getString("comment") + "]" : (contractId > 0 ? "#" + String.valueOf(contractId) : "");
            }
            return super.getValue((Object)intercomFlat, column);
        }
    }

    class IntercomParameterTableModel
    extends BGTableModel<KeyValue> {
        public IntercomParameterTableModel() {
            super(IntercomParameterTableModel.class.getName());
        }

        public void setData(SmartHouseIntercom intercom) {
            ArrayList<KeyValue> params = new ArrayList<KeyValue>();
            if (intercom != null) {
                JSONObject json = new JSONObject(intercom.getData());
                params.add(new KeyValue("\u0410\u0434\u0440\u0435\u0441 (\u0434\u043e\u043c)", String.valueOf(intercom.getHouseId())));
                params.add(new KeyValue("\u041f\u043e\u0434\u044a\u0435\u0437\u0434", String.valueOf(intercom.getEntrance())));
                params.add(new KeyValue("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0432\u0430\u0440\u0442\u0438\u0440", intercom.getFlatRange()));
                params.add(new KeyValue("ID device", json.optString("device_id")));
                params.add(new KeyValue("ID motherboard", json.optString("motherboard_id")));
                params.add(new KeyValue("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440", json.optString("serial_number")));
                params.add(new KeyValue("\u0421\u0442\u0430\u0442\u0443\u0441", String.valueOf(json.optBoolean("is_online"))));
            }
            super.setData(params);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 300, 500, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class FilterField
    extends BGTextField {
        public FilterField(int column, String messageText) {
            super(column);
            super.setPromptText(messageText);
            this.setHorizontalAlignment(0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                // empty if block
            }
        }
    }

    class IntercomAddressEditor
    extends BGEditorDialog<SmartHouseIntercom> {
        private JTextField search;
        private JTextField pod;
        private DefaultListModel<String> searchListModel;
        private JList<String> searchList;

        public IntercomAddressEditor(String title, SmartHouseIntercom data) {
            super(title, (Object)data);
            this.search = new JTextField(50);
            this.pod = new JTextField(50);
            this.searchListModel = new DefaultListModel();
            this.searchList = new JList<String>(this.searchListModel);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
        }

        public void doDialogPanel() {
            this.searchList.setSelectionMode(0);
            this.searchList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JSONObject json = new JSONObject((String)value);
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    ((JLabel)component).setText(json.optString("city") + ", " + json.optString("street") + ", " + json.optInt("houseN") + json.optString("houseF"));
                    return component;
                }
            });
            this.pod.setHorizontalAlignment(0);
            this.pod.setInputVerifier(new InputVerifier(this){

                @Override
                public boolean verify(JComponent input) {
                    return ((JTextField)input).getText().matches("^\\d+$");
                }
            });
            this.search.setHorizontalAlignment(0);
            this.search.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    IntercomAddressEditor.this.seachUpdate(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    IntercomAddressEditor.this.seachUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    IntercomAddressEditor.this.seachUpdate(e);
                }
            });
            this.panel.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0443\u043b\u0438\u0446\u0443, \u0434\u043e\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.search, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.searchList), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.pod, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            String selectHouse = this.searchList.getSelectedValue();
            if (selectHouse == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043c");
                return false;
            }
            if (this.pod.getText().isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0434\u044a\u0435\u0437\u0434\u0430");
                return false;
            }
            ((SmartHouseIntercom)this.data).setHouseId(new JSONObject(selectHouse).getInt("houseId"));
            ((SmartHouseIntercom)this.data).setEntrance(Utils.parseInt((String)this.pod.getText()));
            IntercomPanel.this.getIntercomService().smartHouseIntercomUpdate((SmartHouseIntercom)this.data);
            IntercomPanel.this.performAction("refresh");
            return true;
        }

        private void seachUpdate(DocumentEvent e) {
            this.searchListModel.removeAllElements();
            try {
                if (e.getDocument().getLength() > 2) {
                    this.searchListModel.addAll(IntercomPanel.this.getIntercomService().searchHouse(e.getDocument().getText(0, e.getDocument().getLength())));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    class FlatEditor
    extends BGEditorDialog<SmartHouseIntercomFlat> {
        private int contractId;
        private JSONObject contractJson;
        private JTextField flatNumber;
        private JTextField contract;
        JToggleButton onButton;
        JToggleButton offButton;
        private ButtonGroup onOffButtonGroup;
        private ContractTableModel contractTableModel;
        private BGControlPanelPeriodNoB period;

        public FlatEditor(String title, SmartHouseIntercomFlat data, JSONObject contractJson) {
            super(title, (Object)data);
            this.contractId = 0;
            this.contractJson = null;
            this.flatNumber = new JTextField(5);
            this.contract = new JTextField(5);
            this.onButton = new JToggleButton("\u0432\u043a\u043b.");
            this.offButton = new JToggleButton("\u0432\u044b\u043a\u043b.");
            this.onOffButtonGroup = new ButtonGroup();
            this.contractTableModel = new ContractTableModel();
            this.period = new BGControlPanelPeriodNoB();
            this.contractJson = contractJson;
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.getDataPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getContractPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.contractId = ((SmartHouseIntercomFlat)this.data).getContractId();
            this.flatNumber.setText(String.valueOf(((SmartHouseIntercomFlat)this.data).getFlatNumber()));
            this.period.setPeriod(((SmartHouseIntercomFlat)this.data).getPeriod());
            (((SmartHouseIntercomFlat)this.data).isStatus() ? this.onButton : this.offButton).setSelected(true);
        }

        public boolean doApply() throws Exception {
            ((SmartHouseIntercomFlat)this.data).setContractId(this.contractId);
            ((SmartHouseIntercomFlat)this.data).setPeriod(this.period.getPeriod());
            ((SmartHouseIntercomFlat)this.data).setStatus("on".equals(this.onOffButtonGroup.getSelection().getActionCommand()));
            IntercomPanel.this.getIntercomService().smartHouseIntercomFlatUpdate((SmartHouseIntercomFlat)this.data);
            IntercomPanel.this.setFlatData(((SmartHouseIntercomFlat)this.data).getIntercomId());
            return true;
        }

        private JPanel getDataPanel() {
            Color bgColor = this.flatNumber.getBackground();
            this.flatNumber.setEditable(false);
            this.flatNumber.setHorizontalAlignment(0);
            this.flatNumber.setBackground(bgColor);
            this.contract.setEditable(false);
            this.contract.setHorizontalAlignment(0);
            this.contract.setBackground(bgColor);
            this.contract.setText(this.contractJson != null ? this.contractJson.optString("title") : "");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.flatNumber, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.contract, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.getStatusPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getStatusPanel() {
            this.onButton.setActionCommand("on");
            this.onButton.setSelected(true);
            this.onOffButtonGroup.add(this.onButton);
            this.offButton.setActionCommand("off");
            this.onOffButtonGroup.add(this.offButton);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.onButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.offButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getContractPanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.contractTableModel));
            table.setSelectionMode(0);
            BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.contractSelect());
            Dimension dimension = new Dimension(500, 200);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JButton applyButton = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
            applyButton.addActionListener(e -> this.contractSelect());
            JPanel panel = new JPanel(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)panel, (String)"\u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            panel.add((Component)this.getContractButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)applyButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
            return panel;
        }

        private void contractSelect() {
            ContractIdTitleComment contractIdTitleComment = (ContractIdTitleComment)this.contractTableModel.getSelectedRow();
            if (contractIdTitleComment != null) {
                this.contractId = contractIdTitleComment.getId();
                this.contract.setText(contractIdTitleComment.getTitle());
            }
        }

        private void searchContractByMask(DocumentEvent e) {
            this.contractTableModel.setData(new ArrayList());
            try {
                if (e.getDocument().getLength() > 2) {
                    this.contractTableModel.setData(IntercomPanel.this.getIntercomService().searchContractByMask(e.getDocument().getText(0, e.getDocument().getLength())));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        private JPanel getContractButtonPanel() {
            JTextField contractMask = new JTextField();
            contractMask.setHorizontalAlignment(0);
            contractMask.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FlatEditor.this.searchContractByMask(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FlatEditor.this.searchContractByMask(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FlatEditor.this.searchContractByMask(e);
                }
            });
            ActionListener actionListener = e -> {
                try {
                    switch (e.getActionCommand()) {
                        case "address": {
                            this.contractTableModel.setData(IntercomPanel.this.getIntercomService().searchContractByAddress(((SmartHouseIntercomFlat)this.data).getId()));
                            break;
                        }
                        case "open": {
                            this.contractTableModel.setData(BGClient.getFrame().getTabbedPane().getContracts());
                            break;
                        }
                        case "mask": {
                            this.contractTableModel.setData(IntercomPanel.this.getIntercomService().searchContractByMask(contractMask.getText()));
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            };
            ButtonGroup buttonGroup = new ButtonGroup();
            JToggleButton addressButton = new JToggleButton("\u041f\u043e \u0430\u0434\u0440\u0435\u0441\u0443");
            addressButton.setActionCommand("address");
            addressButton.addActionListener(actionListener);
            addressButton.setSelected(true);
            buttonGroup.add(addressButton);
            JToggleButton openContractButton = new JToggleButton("\u0418\u0437 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445");
            openContractButton.setActionCommand("open");
            openContractButton.addActionListener(actionListener);
            buttonGroup.add(openContractButton);
            JToggleButton findContractButton = new JToggleButton("\u041f\u043e \u043c\u0430\u0441\u043a\u0435");
            findContractButton.setActionCommand("mask");
            findContractButton.addActionListener(actionListener);
            buttonGroup.add(findContractButton);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)addressButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)openContractButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)findContractButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)contractMask, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        class ContractTableModel
        extends BGTableModel<ContractIdTitleComment> {
            public ContractTableModel() {
                super(ContractTableModel.class.getName());
            }

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 150, 150, 150, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 150, 150, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }
        }
    }
}

