/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.include;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;

public class BGHidingPanel
extends JPanel {
    private final JLabel header;
    private final JPanel container;
    private final boolean ready;
    private static final String open = " >>";
    private static final String close = " <<";

    public BGHidingPanel(String title) {
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder());
        this.header = new JLabel(title + open, 10);
        this.header.setIconTextGap(8);
        this.header.setCursor(Cursor.getPredefinedCursor(12));
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BGHidingPanel.this.toggle();
            }
        });
        this.container = new JPanel(new GridBagLayout());
        this.add((Component)this.header, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.container, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.container.setVisible(false);
        this.ready = true;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.ready) {
            this.container.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public String getTitle() {
        return this.header.getText();
    }

    public void setTitle(String title) {
        if (this.ready) {
            this.header.setText(title);
        }
    }

    public boolean isExpanded() {
        return this.container.isVisible();
    }

    public void toggle() {
        boolean state = !this.isExpanded();
        String title = this.header.getText();
        this.container.setVisible(state);
        title = state ? title.replace(open, close) : title.replace(close, open);
        this.header.setText(title);
        this.getParent().validate();
    }
}

